/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.quorum.test;

import com.sun.enterprise.ee.quorum.core.GroupEvent;
import com.sun.enterprise.ee.quorum.core.GroupEventListener;
import com.sun.enterprise.ee.quorum.core.GroupEventNotification;
import com.sun.enterprise.ee.quorum.core.GroupServiceCreateException;
import com.sun.enterprise.ee.quorum.core.GroupServiceFactory;
import com.sun.enterprise.ee.quorum.core.GroupServiceProvider;
import com.sun.enterprise.ee.quorum.core.JoinGroupException;
import com.sun.enterprise.ee.quorum.core.Member;
import com.sun.enterprise.ee.quorum.core.MemberExistsException;
import com.sun.enterprise.ee.quorum.core.NoSuchMemberException;
import com.sun.enterprise.ee.quorum.core.UnknownGroupEventException;
import com.sun.enterprise.ee.quorum.test.GroupCommunicatorMBean;
import java.io.Serializable;
import java.util.Vector;
import javax.management.NotificationBroadcasterSupport;
import javax.management.remote.JMXServiceURL;

public class GroupCommunicator
extends NotificationBroadcasterSupport
implements GroupCommunicatorMBean,
GroupEventListener {
    String MEMBERPROCESSFAILEDEVENT = "com.sun.enterprise.ee.quorum.MemberProcessFailedEvent";
    String MACHINEORNETWORKFAILEDEVENT = "com.sun.enterprise.ee.quorum.MachineOrNetworkFailedEvent";
    String MEMBERNORMALSHUTDOWNEVENT = "com.sun.enterprise.ee.quorum.MemberNormalShutdownEvent";
    String MEMBERADDEDEVENT = "com.sun.enterprise.ee.quorum.MemberAddedEvent";
    String MEMBERMESSAGEEVENT = "com.sun.enterprise.ee.quorum.MemberMessageEvent";
    GroupServiceProvider qs = null;
    Member member = null;

    public GroupCommunicator() {
        try {
            this.qs = GroupServiceFactory.getGroupServiceProvider();
            this.qs.addGroupEventsListener(this);
        }
        catch (GroupServiceCreateException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void joinGroup(String groupName, String memberHost, Integer memberPort) throws JoinGroupException, MemberExistsException {
        Member m = null;
        if (memberHost != null && memberPort != null) {
            m = new Member(memberHost, memberPort, null, null);
        }
        this.qs.joinGroup(groupName, m);
    }

    public void leaveGroup(String groupName, String memberHost, Integer memberPort) throws NoSuchMemberException {
        Member m = null;
        if (memberHost != null && memberPort != null) {
            m = new Member(memberHost, memberPort, null, null);
        }
        this.qs.leaveGroup(groupName, m);
    }

    public void sendMessage(Serializable userData, Member target) {
        this.qs.sendMessage(userData, target);
    }

    public void sendMessage(Serializable userData, Member[] targets) {
        this.qs.sendMessage(userData, targets);
    }

    public void handleGroupEvent(GroupEvent event) {
        int type = event.getType();
        if (type == 0) {
            this.memberAdded(event);
        } else if (type == 1) {
            this.processFailureSuspected(event);
        } else if (type == 2) {
            this.machineOrNetworkFailureSuspected(event);
        } else if (type == 4) {
            this.memberShutdown(event);
        } else if (type == 3) {
            this.memberMessageReceived(event);
        } else {
            try {
                this.handleUnknownEvent(event);
            }
            catch (UnknownGroupEventException e) {
                e.printStackTrace();
            }
        }
    }

    public Vector getMembers(String groupName) {
        return (Vector)this.qs.getQuorum(groupName);
    }

    private void processFailureSuspected(GroupEvent event) {
        System.out.println("GroupCommunicatorMBean: Received Process Failure Event. Calling listeners...\n");
        Member failedMember = event.getMember();
        GroupEventNotification n = new GroupEventNotification(this.MEMBERPROCESSFAILEDEVENT, (Object)this, event.getSequenceNumber(), event.getTimeStamp(), event);
        System.out.println("GroupCommunicatorMBean: Sending Notification to listeners now\n");
        this.sendNotification(n);
    }

    private void machineOrNetworkFailureSuspected(GroupEvent event) {
        System.out.println("GroupCommunicatorMBean: Received Machine/Network Failure Event. Calling listeners...\n");
        Member failedMember = event.getMember();
        GroupEventNotification n = new GroupEventNotification(this.MACHINEORNETWORKFAILEDEVENT, (Object)this, event.getSequenceNumber(), event.getTimeStamp(), event);
        System.out.println("GroupCommunicatorMBean: Sending Notification to listeners now\n");
        this.sendNotification(n);
    }

    private void memberAdded(GroupEvent event) {
        Member newMember = event.getMember();
        GroupEventNotification n = new GroupEventNotification(this.MEMBERADDEDEVENT, (Object)this, event.getSequenceNumber(), event.getTimeStamp(), event);
        this.sendNotification(n);
        this.printState("GroupComm MBEAN: A new member " + newMember.getHost() + ":" + newMember.getPort() + " was added to the group \n" + ((Vector)event.getGroupNames()).firstElement());
    }

    private void memberShutdown(GroupEvent event) {
        Member shutdownMember = event.getMember();
        GroupEventNotification n = new GroupEventNotification(this.MEMBERNORMALSHUTDOWNEVENT, (Object)this, event.getSequenceNumber(), event.getTimeStamp(), event);
        this.sendNotification(n);
    }

    private void memberMessageReceived(GroupEvent event) {
        Member sendingMember = event.getMember();
        GroupEventNotification n = new GroupEventNotification(this.MEMBERMESSAGEEVENT, (Object)this, event.getSequenceNumber(), event.getTimeStamp(), event);
        this.sendNotification(n);
        this.printState("GroupComm MBEAN: The following message from " + sendingMember.getName() + " was received");
        this.printState(event.getUserData().toString());
    }

    private void handleUnknownEvent(GroupEvent event) throws UnknownGroupEventException {
        throw new UnknownGroupEventException("GroupComm MBean: An unknown event was reported: Event Type=" + event.getType());
    }

    private void printState(String state) {
        System.out.println(state);
    }

    public void reestablishConnection(JMXServiceURL url, String groupName) {
        this.qs.recreateConnection(url, groupName);
    }
}

