/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.quorum.test;

import com.sun.enterprise.ee.quorum.core.GroupEvent;
import com.sun.enterprise.ee.quorum.core.GroupEventNotification;
import com.sun.enterprise.ee.quorum.core.Member;
import java.io.Serializable;
import java.util.ArrayList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class EventConsumerExample
implements NotificationListener,
NotificationFilter {
    MBeanServer server = null;
    ObjectName grpCommMBean;
    String MEMBER_PROCESS_FAILED_EVENT = "com.sun.enterprise.ee.quorum.MemberProcessFailedEvent";
    String MACHINE_OR_NETWORK_FAILED_EVENT = "com.sun.enterprise.ee.quorum.MachineOrNetworkFailedEvent";
    String MEMBER_NORMAL_SHUTDOWN_EVENT = "com.sun.enterprise.ee.quorum.MemberNormalShutdownEvent";
    String MEMBER_ADDED_EVENT = "com.sun.enterprise.ee.quorum.MemberAddedEvent";
    String MEMBER_MESSAGE_RECEIVED_EVENT = "com.sun.enterprise.ee.quorum.MemberMessageEvent";

    public EventConsumerExample() throws InstanceNotFoundException, MalformedObjectNameException {
        ArrayList<MBeanServer> list = MBeanServerFactory.findMBeanServer(null);
        this.server = (MBeanServer)list.iterator().next();
        this.grpCommMBean = new ObjectName("example:name=GrpCommMBean");
        this.server.addNotificationListener(this.grpCommMBean, this, (NotificationFilter)this, (Object)this);
    }

    public boolean isNotificationEnabled(Notification n) {
        String type = n.getType();
        return type.equals(this.MEMBER_PROCESS_FAILED_EVENT) || type.equals(this.MACHINE_OR_NETWORK_FAILED_EVENT) || type.equals(this.MEMBER_ADDED_EVENT) || type.equals(this.MEMBER_MESSAGE_RECEIVED_EVENT);
    }

    public void handleNotification(Notification notif, Object handback) {
        ObjectName mbean = (ObjectName)notif.getSource();
        GroupEvent event = ((GroupEventNotification)notif).getGroupEvent();
        String type = notif.getType();
        long ts = notif.getTimeStamp();
        long seqNum = notif.getSequenceNumber();
        if (type.equals(this.MEMBER_ADDED_EVENT)) {
            System.out.println("Event CONSUMER: Received Member Addition event for member:" + event.getMember().getHost() + event.getMember().getPort());
            System.out.println("Seq Num " + seqNum + " TimeStamp " + ts + "\n");
        } else if (type.equals(this.MEMBER_PROCESS_FAILED_EVENT)) {
            System.out.println("Event CONSUMER: Received MEMBER FAILURE event for member:" + event.getMember().getHost() + event.getMember().getPort());
            System.out.println("Seq Num " + seqNum + " TimeStamp " + ts + "\n");
        } else if (type.equals(this.MACHINE_OR_NETWORK_FAILED_EVENT)) {
            System.out.println("Event CONSUMER: Received MACHINE OR NETWORK Failure event :" + event.getMember().getHost() + event.getMember().getPort());
            System.out.println("Seq Num " + seqNum + " TimeStamp " + ts + "\n");
        } else if (type.equals(this.MEMBER_MESSAGE_RECEIVED_EVENT)) {
            Object userData = ((GroupEventNotification)notif).getGroupEvent().getUserData();
            System.out.println("CONSUMER: Received Member Message event from member:" + event.getMember().getHost() + event.getMember().getPort());
            System.out.println("Seq Num " + seqNum + " TimeStamp " + ts);
            System.out.println(userData.toString() + "\n");
        } else {
            this.handleUnknownEvent(notif, handback);
        }
    }

    private void handleUnknownEvent(Notification n, Object handback) {
        System.out.println("CONSUMER: Unknown Event");
    }

    public void sendRemoteMessage(Serializable m, Member member) throws InstanceNotFoundException, MBeanException, ReflectionException {
        Object[] params = new Object[]{m, member};
        this.server.invoke(this.grpCommMBean, "sendMessage", params, null);
    }

    public void sendRemoteMessage(Serializable m, Member[] members) throws InstanceNotFoundException, MBeanException, ReflectionException {
        Object[] params = new Object[]{m, members};
        this.server.invoke(this.grpCommMBean, "sendMessage", params, null);
    }
}

