/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.nodeagent;

import com.sun.enterprise.admin.servermgmt.RuntimeStatus;
import com.sun.enterprise.ee.nodeagent.InstanceStatus;
import com.sun.enterprise.ee.nodeagent.ProcessInstance;
import com.sun.enterprise.ee.nodeagent.ProcessInstanceExternal;
import com.sun.enterprise.ee.nodeagent.ProcessInstanceInternal;
import com.sun.enterprise.ee.nodeagent.ProcessManagerException;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ProcessManager
implements Observer {
    protected static final String PROCESS_COMMANDS = "process";
    protected static final String PROCESS_NAME = "name";
    protected static final String PROCESS_COMMAND_LINE = "command-line";
    protected static final String PROCESS_START_COMMAND = "start-command";
    protected static final String PROCESS_STOP_COMMAND = "stop-command";
    protected static final String PROCESS_ENVIRONMENT_VARIABLE = "environment-variable";
    protected static final String PROCESS_ENVIRONMENT_ARG = "arg";
    protected static final String PROCESS_WORKING_DIR = "working-dir";
    protected static final String PROCESS_WORKING_DIR_FILE = "directory";
    private static Hashtable _htProcesses = new Hashtable();
    private static ProcessManager _procesManager = new ProcessManager();
    private static ProcessManagerMonitor _processManagerMonitor = null;
    private static ProcessManagerConfig _processManagerConfig = null;
    private static Logger _logger = null;
    protected static final StringManager _strMgr = StringManager.getManager((Class)ProcessManager.class);
    private static boolean bDebug = false;

    private ProcessManager() {
        _processManagerMonitor = new ProcessManagerMonitor();
        _processManagerMonitor.start();
    }

    public static ProcessManager getInstance() {
        if (System.getProperty("Debug") != null) {
            bDebug = true;
        }
        return _procesManager;
    }

    public void initializeConfiguration(String configFile) throws ProcessManagerException {
        _processManagerConfig = new ProcessManagerConfig(configFile);
        this.setProcesses(_processManagerConfig.initializeConfig());
    }

    public void startProcess(String name) throws ProcessManagerException, IOException {
        ProcessInstance pInstance = (ProcessInstance)this.getProcesses().get(name);
        pInstance.startInstance();
        pInstance.addObserver(this);
        if (bDebug) {
            System.err.println("\tObserver Registered for :" + name);
        }
    }

    public void startAll() throws ProcessManagerException, IOException {
        Object sxLine = null;
        String key = null;
        Iterator it = this.getProcesses().keySet().iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            this.startProcess(key);
        }
    }

    public void stopProcess(String name) throws ProcessManagerException, IOException {
        ProcessInstance pInstance = (ProcessInstance)this.getProcesses().get(name);
        if (pInstance != null) {
            pInstance.stopInstance();
            if (bDebug) {
                System.err.println("\tProcess Stopped for :" + name);
            }
        } else {
            throw new ProcessManagerException("Instance was not started by ProcessManager");
        }
    }

    public void stopAll() throws ProcessManagerException, IOException {
        Object sxLine = null;
        String key = null;
        Iterator it = this.getProcesses().keySet().iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            this.stopProcess(key);
        }
    }

    public void setMonitorSleepInterval(int sleepTime) {
        if (this.getProcessManagerMonitor() != null) {
            this.getProcessManagerMonitor().setSleepInterval(sleepTime);
        }
    }

    public int getMonitorSleepInterval() {
        int iRet = 0;
        if (this.getProcessManagerMonitor() != null) {
            iRet = this.getProcessManagerMonitor().getSleepInterval();
        }
        return iRet;
    }

    private ProcessManagerMonitor getProcessManagerMonitor() {
        return _processManagerMonitor;
    }

    public void addProcessInstance(String key, ProcessInstance pi) {
        this.getProcesses().put(key, pi);
    }

    public void removeProcessInstance(String key) {
        this.getProcesses().remove(key);
    }

    private Hashtable getProcesses() {
        return _htProcesses;
    }

    public boolean processExists(String key) {
        boolean bRet = false;
        ProcessInstance obj = this.getProcess(key);
        if (obj != null) {
            bRet = true;
        }
        return bRet;
    }

    public ProcessInstance getProcess(String key) {
        return (ProcessInstance)_htProcesses.get(key);
    }

    private void setProcesses(Hashtable ht) {
        _htProcesses = ht;
    }

    public static void main(String[] args) {
        try {
            if (args.length > 0) {
                ProcessManager.getInstance().initializeConfiguration(args[0]);
            }
            ProcessManager.getInstance().startAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ProcessManager instances:");
        Hashtable htTemp = this.getProcesses();
        Iterator it = htTemp.keySet().iterator();
        String key = null;
        String status = null;
        String type = null;
        Process process = null;
        ProcessInstance pInstance = null;
        while (it.hasNext()) {
            key = (String)it.next();
            pInstance = (ProcessInstance)htTemp.get(key);
            process = pInstance.getProcess();
            status = process != null ? "Has Process" : "No Process";
            type = pInstance instanceof ProcessInstanceInternal ? "Internal" : "External";
            sb.append("\nName:" + key + "  - Process:" + status + "  - Type:" + type + " - ExitCode:" + pInstance.getExitCode());
        }
        return sb.toString();
    }

    protected Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.nodeagent", "com.sun.logging.ee.enterprise.system.nodeagent.LogStrings");
        }
        return _logger;
    }

    public void update(Observable observable, Object arg) {
        if (observable instanceof ProcessInstance) {
            ProcessInstance pi = (ProcessInstance)((Object)observable);
            String instanceName = pi.getName();
            if (bDebug) {
                System.err.println("ProcessManager: ***** CHANGE-NOTIFICATION for:" + instanceName + " EXIT CODE=" + pi.getExitCode());
            }
            if (pi.restartProcess()) {
                boolean wasRunning = InstanceStatus.getInstance().updateStatusIfStopped(instanceName, 1);
                if (wasRunning) {
                    this.getLogger().log(Level.INFO, "processManager.restartingProcessInstance", instanceName);
                    try {
                        pi.startInstance();
                        InstanceStatus.getInstance().updateStatusFromAdminChannel(instanceName, 0);
                    }
                    catch (ProcessManagerException e) {
                        e.printStackTrace();
                        InstanceStatus.getInstance().updateStatusFromAdminChannel(instanceName, 3);
                    }
                } else {
                    this.getLogger().log(Level.FINE, "ProcessManager: did not restart" + instanceName + " since it is " + InstanceStatus.getInstance().getStatus(instanceName).getStatus().getStatusString() + " and not running.");
                }
            }
        }
    }

    protected class ProcessManagerConfig {
        private String _file = null;

        protected ProcessManagerConfig(String file) {
            this._file = file;
        }

        protected String getFile() {
            return this._file;
        }

        protected Hashtable initializeConfig() throws ProcessManagerException {
            Hashtable<String, ProcessInstanceExternal> htRet = new Hashtable<String, ProcessInstanceExternal>();
            try {
                Document doc = this.readDOM(this.getFile());
                Object commandLine = null;
                String key = null;
                ProcessInstanceExternal pInstance = null;
                Node childNode = null;
                Object grandNode = null;
                Element processElement = null;
                Element childElement = null;
                NodeList nl = doc.getElementsByTagName(ProcessManager.PROCESS_COMMANDS);
                Object nlx = null;
                for (int ii = 0; ii < nl.getLength(); ++ii) {
                    pInstance = new ProcessInstanceExternal();
                    processElement = (Element)nl.item(ii);
                    key = processElement.getAttribute(ProcessManager.PROCESS_NAME);
                    pInstance.setName(key);
                    if (bDebug) {
                        System.err.println(this.getClass().getName() + ": Creating process:" + pInstance.getName());
                    }
                    for (childNode = processElement.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                        if (!(childNode instanceof Element)) continue;
                        childElement = (Element)childNode;
                        if (childElement.getTagName().equals(ProcessManager.PROCESS_START_COMMAND)) {
                            this.addCommandLine(pInstance, childElement, "start");
                            continue;
                        }
                        if (childElement.getTagName().equals(ProcessManager.PROCESS_STOP_COMMAND)) {
                            this.addCommandLine(pInstance, childElement, "stop");
                            continue;
                        }
                        if (childElement.getTagName().equals(ProcessManager.PROCESS_ENVIRONMENT_VARIABLE)) {
                            pInstance.setEnvironmentVariable(childElement.getAttribute(ProcessManager.PROCESS_ENVIRONMENT_ARG));
                            continue;
                        }
                        if (!childElement.getTagName().equals(ProcessManager.PROCESS_WORKING_DIR)) continue;
                        pInstance.setWorkingDirectory(childElement.getAttribute(ProcessManager.PROCESS_WORKING_DIR_FILE));
                    }
                    if (bDebug) {
                        System.err.println(this.getClass().getName() + ": Process Created: " + pInstance);
                    }
                    htRet.put(key, pInstance);
                }
            }
            catch (Exception e) {
                throw new ProcessManagerException(e);
            }
            return htRet;
        }

        private void addCommandLine(ProcessInstanceExternal pInstance, Element element, String type) {
            Node grandNode = null;
            String commandLine = null;
            NodeList nlx = element.getElementsByTagName(ProcessManager.PROCESS_COMMAND_LINE);
            for (int jj = 0; jj < nlx.getLength(); ++jj) {
                for (grandNode = nlx.item(jj).getFirstChild(); grandNode != null; grandNode = grandNode.getNextSibling()) {
                    if (!(grandNode instanceof Text)) continue;
                    commandLine = grandNode.getNodeValue();
                    pInstance.addCommandLine(type, commandLine);
                }
            }
        }

        protected Document readDOM(String file) throws SAXException, ParserConfigurationException, IOException {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(file);
        }
    }

    class ProcessManagerMonitor
    extends Thread {
        private int _sleepTime = 5000;

        ProcessManagerMonitor() {
        }

        public void setSleepInterval(int sleepTime) {
            this._sleepTime = sleepTime;
        }

        public int getSleepInterval() {
            return this._sleepTime;
        }

        public void run() {
            ProcessManager.this.getLogger().log(Level.FINE, "Start monitoring Processes in ProcessManager...");
            block6: while (true) {
                try {
                    while (true) {
                        Iterator it = ProcessManager.getInstance().getProcesses().values().iterator();
                        Process process = null;
                        ProcessInstance pInstance = null;
                        int iExit = 0;
                        while (it.hasNext()) {
                            pInstance = (ProcessInstance)it.next();
                            process = pInstance.getProcess();
                            if (process == null || pInstance.isStopping()) continue;
                            ProcessManager.this.getLogger().log(Level.FINEST, "ProcessManagerMonitor checking server - " + pInstance.getName());
                            try {
                                iExit = process.exitValue();
                                ProcessManager.this.getLogger().log(Level.FINEST, "exitValue returned - " + iExit);
                                ProcessManager.this.getLogger().log(Level.FINE, "Should Restart Process - " + pInstance.getName());
                                RuntimeStatus status = InstanceStatus.getInstance().getStatus(pInstance.getName());
                                if (status.isStopped()) {
                                    pInstance.setExitCode(iExit);
                                    pInstance.setProcess(null);
                                    pInstance.notifyObservers();
                                    continue;
                                }
                                ProcessManager.this.getLogger().log(Level.FINE, "ProcessManager: did not restart" + pInstance.getName() + " since it is " + status.getStatus().getStatusString() + " and not running.");
                            }
                            catch (IllegalThreadStateException itse) {
                                ProcessManager.this.getLogger().log(Level.FINEST, "exitValue exception returned - " + itse.toString());
                            }
                        }
                        try {
                            ProcessManagerMonitor.sleep(this._sleepTime);
                            continue block6;
                        }
                        catch (InterruptedException ie) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

