/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.nodeagent;

import com.sun.enterprise.admin.common.Status;
import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.admin.servermgmt.RuntimeStatus;
import com.sun.enterprise.ee.admin.servermgmt.EEInstancesManager;
import com.sun.enterprise.ee.admin.servermgmt.InstanceConfig;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class InstanceStatus
extends HashMap {
    private static InstanceStatus _instanceStatus = null;
    private static Logger _logger = null;

    private InstanceStatus() {
    }

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.nodeagent");
        }
        return _logger;
    }

    public static synchronized InstanceStatus getInstance() {
        if (_instanceStatus == null) {
            _instanceStatus = new InstanceStatus();
        }
        return _instanceStatus;
    }

    public synchronized RuntimeStatus getStatus(String instanceName) {
        RuntimeStatus result = (RuntimeStatus)this.get(instanceName);
        if (result == null) {
            result = new RuntimeStatus(instanceName);
            result.setStatus(new Status(3));
            this.put(result.getName(), result);
        }
        if (result.isRunning() || result.isStopped()) {
            this.updateStatusFromAdminChannel(instanceName, result.getStatus().getStatusCode());
        }
        return result;
    }

    public synchronized RuntimeStatus updateStatus(String instanceName, int statusCode) {
        RuntimeStatus result = this.getStatus(instanceName);
        result.setStatus(new Status(statusCode));
        return result;
    }

    private synchronized boolean updateStatusConditionally(String instanceName, int requiredStatusCode, int newStatusCode) {
        RuntimeStatus result = this.getStatus(instanceName);
        if (result.getStatus().getStatusCode() != requiredStatusCode) {
            return false;
        }
        result.setStatus(new Status(newStatusCode));
        return true;
    }

    public synchronized RuntimeStatus updateStatusFromAdminChannel(String instanceName, int statusCode) {
        int newStatusCode = statusCode;
        try {
            InstanceConfig instanceConfig = new InstanceConfig();
            instanceConfig.setInstanceName(instanceName);
            EEInstancesManager eeInstancesManager = new EEInstancesManager(instanceConfig);
            newStatusCode = eeInstancesManager.getInstanceStatus();
            if (newStatusCode != statusCode) {
                InstanceStatus.getLogger().log(Level.INFO, "server " + instanceName + " has admin channel status of " + Status.getStatusString((int)newStatusCode) + " and desired status of " + Status.getStatusString((int)statusCode));
            }
        }
        catch (InstanceException ex) {
            ex.printStackTrace();
        }
        RuntimeStatus result = (RuntimeStatus)this.get(instanceName);
        if (result == null) {
            result = new RuntimeStatus(instanceName);
            this.put(result.getName(), result);
        }
        result.setStatus(new Status(newStatusCode));
        return result;
    }

    public synchronized boolean updateStatusIfStopped(String instanceName, int newStatusCode) {
        return this.updateStatusConditionally(instanceName, 3, newStatusCode);
    }

    public synchronized boolean updateStatusIfRunning(String instanceName, int newStatusCode) {
        return this.updateStatusConditionally(instanceName, 0, newStatusCode);
    }
}

