/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.nodeagent;

import com.sun.enterprise.ee.admin.servermgmt.DASPropertyReader;
import com.sun.enterprise.ee.synchronization.DASCommunicationException;
import com.sun.enterprise.security.LoginException;
import java.io.IOException;
import java.net.ConnectException;
import java.rmi.ConnectIOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CommunicationException;
import javax.naming.ServiceUnavailableException;

class CommunicationExceptionLogUtils {
    private final String configDasHost;
    private final String configDasPort;
    private final String configDasProtocol;
    private final Logger logger;
    private final Level level;

    public CommunicationExceptionLogUtils(Logger logger, Level level, DASPropertyReader dr) {
        this.configDasHost = dr.getHost();
        this.configDasPort = dr.getPort();
        this.configDasProtocol = dr.getProtocol();
        this.logger = logger;
        this.level = level == null ? Level.SEVERE : level;
    }

    public void handleDASCommunicationException(DASCommunicationException de) {
        Throwable wrapped = null;
        if (de != null) {
            wrapped = de.getCause();
            if (wrapped instanceof ConnectException) {
                this.logConnectException((ConnectException)wrapped);
            } else if (wrapped instanceof LoginException) {
                this.logLoginException((LoginException)wrapped);
            } else if (wrapped instanceof IOException) {
                this.logIOException((IOException)wrapped);
            } else {
                this.logThrowable(wrapped);
            }
        }
    }

    private void logConnectException(ConnectException c) {
        Object[] hp = new String[]{this.configDasHost, this.configDasPort};
        this.logger.log(this.level, "nodeagent.connectException", hp);
    }

    private void logLoginException(LoginException l) {
        Object[] hp = new String[]{this.configDasHost, this.configDasPort};
        this.logger.log(this.level, "nodeagent.loginException", hp);
    }

    private void logIOException(IOException c) {
        Throwable pc = c.getCause();
        Object[] hpp = new String[]{this.configDasHost, this.configDasPort, this.configDasProtocol};
        if (pc instanceof ServiceUnavailableException) {
            if (pc.getCause() instanceof ConnectException || pc.getCause() instanceof java.rmi.ConnectException) {
                this.logger.log(this.level, "nodeagent.serverEndDown", hpp);
            }
        } else if (pc instanceof CommunicationException && (pc = pc.getCause()) instanceof ConnectIOException) {
            Object[] hp = new String[]{this.configDasHost, this.configDasPort};
            this.logger.log(this.level, "nodeagent.nonJrmpEndPoint", hp);
        }
    }

    private void logThrowable(Throwable t) {
        this.logger.log(this.level, "nodeagent.unknownCommunicationError", t);
    }
}

