/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.core;

import com.sun.enterprise.ee.cms.core.DoorManager;
import com.sun.enterprise.ee.cms.core.FailureNotificationSignalImpl;
import com.sun.enterprise.ee.cms.core.FailureRecoverySignal;
import com.sun.enterprise.ee.cms.core.SignalAcquireException;
import com.sun.enterprise.ee.cms.core.SignalReleaseException;
import java.util.logging.Level;
import org.jgroups.Address;

public class FailureRecoverySignalImpl
extends FailureNotificationSignalImpl
implements FailureRecoverySignal {
    private DoorManager doorManager;

    FailureRecoverySignalImpl(FailureRecoverySignalImpl signal) {
        this.setFailedMemberAddress((Address)signal.getFailedMemberAddress());
        this.setDoorManager(signal.getDoorManager());
    }

    public FailureRecoverySignalImpl(Address failedMember) {
        this.failedMember = failedMember;
        this.doorManager = new DoorManager();
    }

    private DoorManager getDoorManager() {
        return this.doorManager;
    }

    private void setDoorManager(DoorManager doorManager) {
        this.doorManager = doorManager;
    }

    protected void setFailedMemberAddress(Address failedMember) {
        super.setFailedMemberAddress(failedMember);
    }

    public void acquire() throws SignalAcquireException {
        if (this.failedMember == null) {
            throw new SignalAcquireException("Cannot acquire resource without knowing identity of the Failed Member");
        }
        if (this.doorManager.isOpen()) {
            try {
                this.doorManager.close(this.getFailedMemberToken());
                logger.log(Level.FINE, "FailureRecoverySignal Acquired...");
            }
            catch (Exception e) {
                throw new SignalAcquireException(e);
            }
        } else {
            throw new SignalAcquireException("Cannot acquire resource as it was already acquired and not released");
        }
    }

    public void release() throws SignalReleaseException {
        if (this.doorManager.isOpen()) {
            throw new SignalReleaseException("Cannot release resource as it was already released and later not acquired");
        }
        try {
            this.doorManager.open();
            logger.log(Level.FINE, "FailureRecoverySignal Released...");
        }
        catch (Exception e) {
            throw new SignalReleaseException(e);
        }
        this.failedMember = null;
    }
}

