/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.proxy;

import com.sun.enterprise.ee.admin.clientreg.MBeanServerConnectionInfo;
import com.sun.enterprise.ee.admin.clientreg.MBeanServerRegistry;
import com.sun.enterprise.ee.admin.proxy.BaseProxy;
import com.sun.enterprise.ee.admin.servermgmt.AgentException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class MBeanServerProxy
extends BaseProxy
implements InvocationHandler {
    private static Logger _logger = null;
    private ObjectName _objectName = null;
    private MBeanServerConnectionInfo _connectionInfo = null;
    private MBeanServerConnection _connection = null;
    private MBeanServerRegistry _registry = null;

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    public static Object getMBeanServerProxy(Class theInterface, ObjectName objName, MBeanServerConnectionInfo connectionInfo) {
        return Proxy.newProxyInstance(theInterface.getClassLoader(), new Class[]{theInterface}, (InvocationHandler)new MBeanServerProxy(objName, connectionInfo));
    }

    private MBeanServerProxy(ObjectName objName, MBeanServerConnectionInfo connectionInfo) {
        this._objectName = objName;
        this._connectionInfo = connectionInfo;
    }

    private MBeanServerConnection getConnection() throws AgentException {
        if (this._connection == null) {
            if (this._registry == null) {
                this._registry = new MBeanServerRegistry(this.getConnectionInfo());
            }
            this._connection = this._registry.getMBeanServerConnection();
        }
        return this._connection;
    }

    private ObjectName getObjectName() {
        return this._objectName;
    }

    private MBeanServerConnectionInfo getConnectionInfo() {
        return this._connectionInfo;
    }

    public void connect() throws AgentException {
        this.getConnection();
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        MBeanServerProxy.getLogger().log(Level.FINEST, "MBeanServerProxy:invoke " + methodName);
        try {
            return this.getConnection().invoke(this.getObjectName(), methodName, args, MBeanServerProxy.getParameterTypes(method.getParameterTypes()));
        }
        catch (Exception ex) {
            if (!MBeanServerProxy.isUnreachable(ex)) {
                MBeanServerProxy.getLogger().log(Level.FINE, "mbs.proxy.exception", ex);
            } else {
                MBeanServerProxy.getLogger().log(Level.FINE, "mbs.proxy.cannotConnect", this.getObjectName());
            }
            throw ex;
        }
    }
}

