/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.lbadmin.reader.impl;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.HealthChecker;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.ClusterReader;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.HealthCheckerReader;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.InstanceReader;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.LbReaderException;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.WebModuleReader;
import com.sun.enterprise.ee.admin.lbadmin.reader.impl.ClusterReaderHelper;
import com.sun.enterprise.ee.admin.lbadmin.reader.impl.HealthCheckerReaderImpl;
import com.sun.enterprise.ee.admin.lbadmin.reader.impl.InstanceReaderImpl;
import com.sun.enterprise.ee.admin.lbadmin.transform.ClusterVisitor;
import com.sun.enterprise.ee.admin.lbadmin.transform.Visitor;
import com.sun.enterprise.util.i18n.StringManager;

public class StandAloneClusterReaderImpl
implements ClusterReader {
    private ConfigContext _configCtx = null;
    private ServerRef _serverRef = null;
    private static final StringManager _strMgr = StringManager.getManager((Class)StandAloneClusterReaderImpl.class);

    public StandAloneClusterReaderImpl(ConfigContext ctx, ServerRef ref) throws LbReaderException {
        if (ctx == null || ref == null) {
            String iMsg = _strMgr.getString("InvalidArgs");
            throw new RuntimeException(iMsg);
        }
        this._configCtx = ctx;
        this._serverRef = ref;
    }

    public String getName() {
        return this._serverRef.getRef();
    }

    public InstanceReader[] getInstances() throws LbReaderException {
        InstanceReader[] readers = new InstanceReader[]{new InstanceReaderImpl(this._configCtx, this._serverRef)};
        return readers;
    }

    public HealthCheckerReader getHealthChecker() throws LbReaderException {
        HealthChecker bean = this._serverRef.getHealthChecker();
        if (bean == null) {
            return null;
        }
        HealthCheckerReaderImpl reader = new HealthCheckerReaderImpl(bean);
        return reader;
    }

    public WebModuleReader[] getWebModules() throws LbReaderException {
        ApplicationRef[] refs = null;
        try {
            refs = ServerHelper.getApplicationReferences((ConfigContext)this._configCtx, (String)this._serverRef.getRef());
        }
        catch (ConfigException ce) {
            String msg = _strMgr.getString("ErrorFindingClusteredApplications", (Object)this._serverRef.getRef());
            throw new LbReaderException(msg, ce);
        }
        return ClusterReaderHelper.getWebModules(this._configCtx, refs, this._serverRef.getRef());
    }

    public void accept(Visitor v) {
        ClusterVisitor cv = (ClusterVisitor)v;
        cv.visit(this);
    }
}

