/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.lbadmin.mbeans;

import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.ClusterRef;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HealthChecker;
import com.sun.enterprise.config.serverbeans.LbConfig;
import com.sun.enterprise.config.serverbeans.LbConfigs;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.ee.admin.lbadmin.mbeans.HTTPLBAdminConfigMBean;
import com.sun.enterprise.ee.admin.lbadmin.mbeans.LbConfigHelper;
import com.sun.enterprise.ee.admin.lbadmin.writer.LbConfigWriter;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.i18n.StringManagerBase;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;
import javax.management.ObjectName;

public final class HTTPLBAdminConfig
extends BaseConfigMBean
implements HTTPLBAdminConfigMBean {
    private static final StringManager _strMgr = StringManager.getManager((Class)HTTPLBAdminConfigMBean.class);
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
    private static final StringManagerBase _sMgr = StringManagerBase.getStringManager((String)_logger.getResourceBundleName());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] listLBConfigs(String target) throws MBeanException {
        _logger.log(Level.FINE, "[LBAdminMBean] listLBConfigs called");
        LbConfigs lbConfigs = this.getLbConfigs();
        if (lbConfigs == null) {
            _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.NoLbConfigs"));
            return null;
        }
        String[] names = null;
        if (target == null) {
            LbConfig[] lbConfigArray = lbConfigs.getLbConfig();
            if (lbConfigArray.length == 0) {
                _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.NoLbConfigs"));
                return null;
            }
            names = new String[lbConfigArray.length];
            int i = 0;
            while (i < lbConfigArray.length) {
                names[i] = lbConfigArray[i].getName();
                ++i;
            }
            return names;
        }
        ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        try {
            int i;
            if (ClusterHelper.isACluster((ConfigContext)ctx, (String)target)) {
                return this.getLBConfigsForCluster(target);
            }
            if (ServerHelper.isAServer((ConfigContext)ctx, (String)target)) {
                return this.getLBConfigsForServer(target);
            }
            LbConfig lbConfig = lbConfigs.getLbConfigByName(target);
            if (lbConfig == null) return names;
            String[] clusters = this.getClustersInLBConfig(target);
            String[] servers = this.getServersInLBConfig(target);
            ArrayList<String> list = new ArrayList<String>();
            if (clusters != null) {
                String cPrefix = _strMgr.getString("ClusterPrefix");
                for (i = 0; i < clusters.length; ++i) {
                    list.add(cPrefix + clusters[i]);
                }
            }
            if (servers != null) {
                String sPrefix = _strMgr.getString("ServerPrefix");
                for (i = 0; i < servers.length; ++i) {
                    list.add(sPrefix + servers[i]);
                }
            }
            names = new String[list.size()];
            return list.toArray(names);
        }
        catch (ConfigException ce) {
            throw new MBeanException((Exception)((Object)ce));
        }
    }

    public String[] getLBConfigsForServer(String serverName) throws MBeanException {
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            return LbConfigHelper.getLBsForStandAloneServer(ctx, serverName);
        }
        catch (ConfigException ce) {
            throw new MBeanException((Exception)((Object)ce));
        }
    }

    public String[] getLBConfigsForCluster(String clusterName) throws MBeanException {
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            return LbConfigHelper.getLBsForCluster(ctx, clusterName);
        }
        catch (ConfigException ce) {
            throw new MBeanException((Exception)((Object)ce));
        }
    }

    public String[] getServersInLBConfig(String configName) throws MBeanException {
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            return LbConfigHelper.getServersInLB(ctx, configName);
        }
        catch (ConfigException ce) {
            throw new MBeanException((Exception)((Object)ce));
        }
    }

    public String[] getClustersInLBConfig(String configName) throws MBeanException {
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            return LbConfigHelper.getClustersInLB(ctx, configName);
        }
        catch (ConfigException ce) {
            throw new MBeanException((Exception)((Object)ce));
        }
    }

    public ObjectName getHTTPLBConfigObjectName(String name) {
        _logger.log(Level.FINE, "[LBAdminMBean] getHttpLbConfigObjectName called for configname " + name);
        LbConfigs lbConfigs = this.getLbConfigs();
        if (lbConfigs == null) {
            _logger.log(Level.FINE, _sMgr.getString("http_lb_admin.NoLbConfigs"));
            return null;
        }
        LbConfig lbConfig = lbConfigs.getLbConfigByName(name);
        if (lbConfig == null) {
            _logger.log(Level.FINE, _sMgr.getString("http_lb_admin.NoLbConfigs"));
            return null;
        }
        return null;
    }

    public void createLBConfig(String configName, String responseTimeout, String httpsRouting, String reloadInterval, String monitor, String routeCookie, String target) throws MBeanException {
        LbConfigs lbConfigs = null;
        LbConfig newConfig = null;
        try {
            lbConfigs = this.getLbConfigs();
            newConfig = new LbConfig();
            if (configName == null) {
                if (target == null) {
                    target = "server";
                }
                configName = target + "-http-lb-config";
            }
            newConfig.setName(configName);
            newConfig.setResponseTimeoutInSeconds(new Integer(responseTimeout).toString());
            newConfig.setReloadPollIntervalInSeconds(new Integer(reloadInterval).toString());
            newConfig.setMonitoringEnabled(Boolean.valueOf(monitor).booleanValue());
            newConfig.setRouteCookieEnabled(Boolean.valueOf(routeCookie).booleanValue());
            newConfig.setHttpsRouting(Boolean.valueOf(httpsRouting).booleanValue());
            lbConfigs.addLbConfig(newConfig);
        }
        catch (ConfigException ce) {
            throw new MBeanException((Exception)((Object)ce));
        }
        try {
            if (target != null) {
                this.createLBRef(target, configName);
            }
            _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.LbConfigCreated", (Object)configName));
        }
        catch (MBeanException me) {
            try {
                if (newConfig != null) {
                    lbConfigs.removeLbConfig(newConfig);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw me;
        }
    }

    public void deleteLBConfig(String name) throws MBeanException {
        LbConfigs lbConfigs = this.getLbConfigs();
        if (lbConfigs == null) {
            String msg = _strMgr.getString("NoLbConfigsElement");
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        LbConfig lbConfig = lbConfigs.getLbConfigByName(name);
        if (lbConfig == null) {
            String msg = _strMgr.getString("InvalidLbConfigName", (Object)name);
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        if (lbConfig.getServerRef() != null && lbConfig.getServerRef().length != 0 || lbConfig.getClusterRef() != null && lbConfig.getClusterRef().length != 0) {
            String msg = _strMgr.getString("LbConfigNotEmpty", (Object)name);
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        lbConfigs.removeLbConfig(lbConfig);
        _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.LbConfigDeleted", (Object)name));
    }

    public void disableServer(String target, String time) throws MBeanException {
        _logger.log(Level.FINE, "[LBAdminMBean] disableServer - Target " + target + ", Timeout " + time);
        int timeout = Integer.parseInt(time);
        if (timeout < 0) {
            String msg = _strMgr.getString("InvalidNumber");
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        try {
            if (ClusterHelper.isACluster((ConfigContext)ctx, (String)target)) {
                this.disableCluster(target, timeout);
                _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.ClusterDisabled", (Object)target));
            } else {
                boolean enabled;
                boolean foundTarget = false;
                LbConfig[] lbConfigs = this.getLbConfigs().getLbConfig();
                for (int i = 0; i < lbConfigs.length; ++i) {
                    ServerRef sRef = lbConfigs[i].getServerRefByRef(target);
                    if (sRef == null) {
                        _logger.log(Level.FINEST, " server " + target + " does not exist in " + lbConfigs[i]);
                        continue;
                    }
                    foundTarget = true;
                    enabled = sRef.isLbEnabled();
                    int curTout = Integer.parseInt(sRef.getDisableTimeoutInMinutes());
                    if (!enabled && curTout == timeout) {
                        String msg = _strMgr.getString("ServerDisabled", (Object)sRef.getRef());
                        throw new MBeanException((Exception)((Object)new ConfigException(msg)));
                    }
                    sRef.setLbEnabled(false);
                    sRef.setDisableTimeoutInMinutes(new Integer(timeout).toString());
                    _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.ServerDisabled", (Object)target));
                }
                if (!foundTarget) {
                    ServerRef sRef = this.getServerRefFromCluster(ctx, target);
                    if (sRef == null) {
                        _logger.log(Level.FINEST, " server " + target + " does not exist in any cluster in the domain");
                        String msg = _strMgr.getString("ServerNotDefined", (Object)target);
                        throw new MBeanException(new RuntimeException(msg));
                    }
                    int curTout = Integer.parseInt(sRef.getDisableTimeoutInMinutes());
                    enabled = sRef.isLbEnabled();
                    if (!enabled && curTout == timeout) {
                        String msg = _strMgr.getString("ServerDisabled", (Object)sRef.getRef());
                        throw new MBeanException((Exception)((Object)new ConfigException(msg)));
                    }
                    sRef.setLbEnabled(false);
                    sRef.setDisableTimeoutInMinutes(new Integer(timeout).toString());
                    _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.ServerDisabled", (Object)target));
                }
            }
        }
        catch (ConfigException ce) {
            throw new MBeanException((Exception)((Object)ce));
        }
    }

    public void enableServer(String target) throws MBeanException {
        _logger.log(Level.FINE, "[LBAdminMBean] enableServer called for target " + target);
        ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        try {
            if (ClusterHelper.isACluster((ConfigContext)ctx, (String)target)) {
                this.enableCluster(target);
                _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.ClusterEnabled", (Object)target));
            } else {
                boolean foundTarget = false;
                LbConfig[] lbConfigs = this.getLbConfigs().getLbConfig();
                for (int i = 0; i < lbConfigs.length; ++i) {
                    ServerRef sRef = lbConfigs[i].getServerRefByRef(target);
                    if (sRef == null) {
                        _logger.log(Level.FINEST, " server " + target + " does not exist in " + lbConfigs[i]);
                        continue;
                    }
                    boolean enabled = sRef.isLbEnabled();
                    if (enabled) {
                        String msg = _strMgr.getString("ServerEnabled", (Object)sRef.getRef());
                        throw new MBeanException((Exception)((Object)new ConfigException(msg)));
                    }
                    sRef.setLbEnabled(true);
                    foundTarget = true;
                    _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.ServerEnabled", (Object)target));
                }
                if (!foundTarget) {
                    ServerRef sRef = this.getServerRefFromCluster(ctx, target);
                    if (sRef == null) {
                        _logger.log(Level.FINEST, " server " + target + " does not exist in any cluster in the domain");
                        String msg = _strMgr.getString("ServerNotDefined", (Object)target);
                        throw new MBeanException(new RuntimeException(msg));
                    }
                    boolean enabled = sRef.isLbEnabled();
                    if (enabled) {
                        String msg = _strMgr.getString("ServerEnabled", (Object)sRef.getRef());
                        throw new MBeanException((Exception)((Object)new ConfigException(msg)));
                    }
                    sRef.setLbEnabled(true);
                    _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.ServerEnabled", (Object)target));
                }
            }
        }
        catch (ConfigException ce) {
            throw new MBeanException((Exception)((Object)ce));
        }
    }

    private ServerRef getServerRefFromCluster(ConfigContext ctx, String target) throws MBeanException {
        Cluster c = null;
        try {
            c = ClusterHelper.getClusterForInstance((ConfigContext)ctx, (String)target);
        }
        catch (ConfigException ce) {
            // empty catch block
        }
        if (c == null) {
            String msg = _strMgr.getString("ServerNotDefined", (Object)target);
            throw new MBeanException(new RuntimeException(msg));
        }
        return c.getServerRefByRef(target);
    }

    private void disableCluster(String clusterName, int timeout) throws MBeanException {
        if (timeout < 0) {
            String msg = _strMgr.getString("InvalidNumber");
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        Cluster c = null;
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            c = ClusterHelper.getClusterByName((ConfigContext)ctx, (String)clusterName);
        }
        catch (ConfigException ce) {
            throw new MBeanException((Exception)((Object)ce));
        }
        if (c == null) {
            String msg = _strMgr.getString("ClusterNotDefined", (Object)clusterName);
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        ServerRef[] sRefs = c.getServerRef();
        for (int i = 0; i < sRefs.length; ++i) {
            sRefs[i].setLbEnabled(false);
            sRefs[i].setDisableTimeoutInMinutes(new Integer(timeout).toString());
        }
    }

    private void enableCluster(String clusterName) throws MBeanException {
        Cluster c = null;
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            c = ClusterHelper.getClusterByName((ConfigContext)ctx, (String)clusterName);
        }
        catch (ConfigException ce) {
            throw new MBeanException((Exception)((Object)ce));
        }
        if (c == null) {
            String msg = _strMgr.getString("ClusterNotDefined", (Object)clusterName);
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        ServerRef[] sRefs = c.getServerRef();
        for (int i = 0; i < sRefs.length; ++i) {
            sRefs[i].setLbEnabled(true);
        }
    }

    private void disableApplicationForServer(String appName, String serverName, int timeout) throws MBeanException {
        if (timeout < 0) {
            String msg = _strMgr.getString("InvalidNumber");
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        Server s = null;
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            s = ServerHelper.getServerByName((ConfigContext)ctx, (String)serverName);
        }
        catch (ConfigException ce) {
            throw new MBeanException((Exception)((Object)ce));
        }
        if (s == null) {
            String msg = _strMgr.getString("ServerNotDefined", (Object)serverName);
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        ApplicationRef appRef = s.getApplicationRefByRef(appName);
        if (appRef == null) {
            String msg = _strMgr.getString("AppRefNotDefined", (Object)appName, (Object)serverName);
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        int curTout = Integer.parseInt(appRef.getDisableTimeoutInMinutes());
        boolean enabled = appRef.isLbEnabled();
        if (!enabled && curTout == timeout) {
            String msg = _strMgr.getString("AppDisabledOnServer", (Object)appRef.getRef(), (Object)serverName);
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        appRef.setLbEnabled(false);
        appRef.setDisableTimeoutInMinutes(new Integer(timeout).toString());
        _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.ApplicationDisabled", (Object)appName, (Object)serverName));
    }

    private void enableApplicationForServer(String appName, String serverName) throws MBeanException {
        Server s = null;
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            s = ServerHelper.getServerByName((ConfigContext)ctx, (String)serverName);
        }
        catch (ConfigException ce) {
            throw new MBeanException((Exception)((Object)ce));
        }
        if (s == null) {
            String msg = _strMgr.getString("ServerNotDefined", (Object)serverName);
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        ApplicationRef appRef = s.getApplicationRefByRef(appName);
        if (appRef == null) {
            String msg = _strMgr.getString("AppRefNotDefined", (Object)appName);
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        boolean enabled = appRef.isLbEnabled();
        if (enabled) {
            String msg = _strMgr.getString("AppEnabledOnServer", (Object)appRef.getRef(), (Object)serverName);
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        appRef.setLbEnabled(true);
        _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.ApplicationEnabled", (Object)appName, (Object)serverName));
    }

    public void disableApplication(String target, String timeout, String appName) throws MBeanException {
        block4: {
            _logger.log(Level.FINE, "[LBAdminMBean] disableApplication called - Target " + target + ", App Name " + appName + ", Timeout " + timeout);
            try {
                ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
                int iTimeout = Integer.parseInt(timeout);
                if (ClusterHelper.isACluster((ConfigContext)ctx, (String)target)) {
                    this.disableApplicationForCluster(appName, target, iTimeout);
                    break block4;
                }
                if (ServerHelper.isAServer((ConfigContext)ctx, (String)target)) {
                    this.disableApplicationForServer(appName, target, iTimeout);
                    break block4;
                }
                String msg = _strMgr.getString("InvalidTarget", (Object)target);
                throw new MBeanException(new RuntimeException(msg));
            }
            catch (ConfigException ce) {
                throw new MBeanException((Exception)((Object)ce));
            }
        }
    }

    private void disableApplicationForCluster(String appName, String clusterName, int timeout) throws MBeanException {
        if (timeout < 0) {
            String msg = _strMgr.getString("InvalidNumber");
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        Cluster c = null;
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            c = ClusterHelper.getClusterByName((ConfigContext)ctx, (String)clusterName);
        }
        catch (ConfigException ce) {
            throw new MBeanException((Exception)((Object)ce));
        }
        if (c == null) {
            String msg = _strMgr.getString("ClusterNotDefined", (Object)clusterName);
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        ApplicationRef appRef = c.getApplicationRefByRef(appName);
        if (appRef == null) {
            String msg = _strMgr.getString("AppRefNotDefined", (Object)appName, (Object)clusterName);
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        int curTout = Integer.parseInt(appRef.getDisableTimeoutInMinutes());
        boolean enabled = appRef.isLbEnabled();
        if (!enabled && curTout == timeout) {
            String msg = _strMgr.getString("AppDisabledOnCluster", (Object)appRef.getRef(), (Object)clusterName);
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        appRef.setLbEnabled(false);
        appRef.setDisableTimeoutInMinutes(new Integer(timeout).toString());
        _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.ApplicationDisabled", (Object)appName, (Object)clusterName));
    }

    public void enableApplication(String target, String appName) throws MBeanException {
        block4: {
            _logger.log(Level.FINE, "[LBAdminMBean] enableApplication called - Target " + target + ", App Name " + appName);
            try {
                ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
                if (ClusterHelper.isACluster((ConfigContext)ctx, (String)target)) {
                    this.enableApplicationForCluster(appName, target);
                    break block4;
                }
                if (ServerHelper.isAServer((ConfigContext)ctx, (String)target)) {
                    this.enableApplicationForServer(appName, target);
                    break block4;
                }
                String msg = _strMgr.getString("InvalidTarget", (Object)target);
                throw new MBeanException(new RuntimeException(msg));
            }
            catch (ConfigException ce) {
                throw new MBeanException((Exception)((Object)ce));
            }
        }
    }

    private void enableApplicationForCluster(String appName, String clusterName) throws MBeanException {
        _logger.log(Level.FINE, "[LBAdminMBean] disableApplication called for target " + clusterName + " app name is " + appName);
        Cluster c = null;
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            c = ClusterHelper.getClusterByName((ConfigContext)ctx, (String)clusterName);
        }
        catch (ConfigException ce) {
            throw new MBeanException((Exception)((Object)ce));
        }
        if (c == null) {
            String msg = _strMgr.getString("ClusterNotDefined", (Object)clusterName);
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        ApplicationRef appRef = c.getApplicationRefByRef(appName);
        if (appRef == null) {
            String msg = _strMgr.getString("AppRefNotDefined", (Object)appName, (Object)clusterName);
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        boolean enabled = appRef.isLbEnabled();
        if (enabled) {
            String msg = _strMgr.getString("AppEnabledOnCluster", (Object)appRef.getRef(), (Object)clusterName);
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        appRef.setLbEnabled(true);
        _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.ApplicationEnabled", (Object)appName, (Object)clusterName));
    }

    public void createHealthChecker(String url, String interval, String timeout, String lbConfigName, String target) throws MBeanException {
        if (lbConfigName != null) {
            LbConfig lbConfig = this.getLbConfigs().getLbConfigByName(lbConfigName);
            this.createHealthCheckerInternal(url, interval, timeout, lbConfig, lbConfigName, target, false);
        } else {
            LbConfig[] lbConfigs = this.getLbConfigs().getLbConfig();
            if (lbConfigs == null) {
                String msg = _strMgr.getString("NoLbConfigsElement");
                throw new MBeanException((Exception)((Object)new ConfigException(msg)));
            }
            LbConfig[] match = null;
            try {
                match = this.matchLbConfigToTarget(lbConfigs, target);
            }
            catch (ConfigException ce) {
                String msg = _strMgr.getString("UnassociatedTarget", (Object)target);
                throw new MBeanException((Exception)((Object)ce), msg);
            }
            if (match == null || match.length == 0) {
                String msg = _strMgr.getString("UnassociatedTarget", (Object)target);
                throw new MBeanException((Exception)((Object)new ConfigException(msg)));
            }
            for (int lbIdx = 0; lbIdx < match.length; ++lbIdx) {
                this.createHealthCheckerInternal(url, interval, timeout, match[lbIdx], lbConfigName, target, true);
            }
        }
    }

    private LbConfig[] matchLbConfigToTarget(LbConfig[] lbConfigs, String target) throws ConfigException {
        ArrayList<LbConfig> list = null;
        if (target == null) {
            String msg = _strMgr.getString("NullTarget");
            throw new ConfigException(msg);
        }
        ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        if (lbConfigs != null) {
            list = new ArrayList<LbConfig>();
            for (int i = 0; i < lbConfigs.length; ++i) {
                ServerRef sRef;
                if (ClusterHelper.isACluster((ConfigContext)ctx, (String)target)) {
                    ClusterRef cRef = lbConfigs[i].getClusterRefByRef(target);
                    if (cRef == null) continue;
                    list.add(lbConfigs[i]);
                    continue;
                }
                if (!ServerHelper.isAServer((ConfigContext)ctx, (String)target) || (sRef = lbConfigs[i].getServerRefByRef(target)) == null) continue;
                list.add(lbConfigs[i]);
            }
        }
        LbConfig[] lbcArray = null;
        if (list != null) {
            lbcArray = new LbConfig[list.size()];
            lbcArray = list.toArray(lbcArray);
        }
        return lbcArray;
    }

    private void createHealthCheckerInternal(String url, String interval, String timeout, LbConfig lbConfig, String lbConfigName, String target, boolean ignoreError) throws MBeanException {
        block17: {
            if (lbConfig == null) {
                String msg = _strMgr.getString("InvalidLbConfigName", (Object)lbConfigName);
                throw new MBeanException((Exception)((Object)new ConfigException(msg)));
            }
            lbConfigName = lbConfig.getName();
            _logger.log(Level.FINE, "[LBAdminMBean] createHealthChecker called - URL " + url + ", Interval " + interval + ", Time out " + timeout + ", LB Config  " + lbConfigName + ", Target " + target);
            if (target == null) {
                String msg = _strMgr.getString("NullTarget");
                throw new MBeanException(new RuntimeException(msg));
            }
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            try {
                HealthChecker hc = new HealthChecker();
                if (url != null) {
                    hc.setUrl(url);
                }
                if (interval != null) {
                    hc.setIntervalInSeconds(interval);
                }
                if (timeout != null) {
                    hc.setTimeoutInSeconds(timeout);
                }
                if (ClusterHelper.isACluster((ConfigContext)ctx, (String)target)) {
                    ClusterRef cRef = lbConfig.getClusterRefByRef(target);
                    if (cRef == null && !ignoreError) {
                        String msg = _strMgr.getString("UnassociatedCluster", (Object)lbConfigName, (Object)target);
                        throw new MBeanException((Exception)((Object)new ConfigException(msg)));
                    }
                    if (cRef != null && cRef.getHealthChecker() == null) {
                        cRef.setHealthChecker(hc);
                        _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.HealthCheckerCreated", (Object)target));
                    } else if (!ignoreError) {
                        String msg = _strMgr.getString("HealthCheckerExists", (Object)cRef.getRef());
                        throw new MBeanException((Exception)((Object)new ConfigException(msg)));
                    }
                    break block17;
                }
                if (ServerHelper.isAServer((ConfigContext)ctx, (String)target)) {
                    ServerRef sRef = lbConfig.getServerRefByRef(target);
                    if (sRef == null && !ignoreError) {
                        String msg = _strMgr.getString("UnassociatedServer", (Object)lbConfigName, (Object)target);
                        throw new MBeanException((Exception)((Object)new ConfigException(msg)));
                    }
                    if (sRef != null && sRef.getHealthChecker() == null) {
                        sRef.setHealthChecker(hc);
                        _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.HealthCheckerCreated", (Object)target));
                    } else if (!ignoreError) {
                        String msg = _strMgr.getString("HealthCheckerExits", (Object)sRef.getRef());
                        throw new MBeanException((Exception)((Object)new ConfigException(msg)));
                    }
                    break block17;
                }
                String msg = _strMgr.getString("InvalidTarget", (Object)target);
                throw new MBeanException(new RuntimeException(msg));
            }
            catch (ConfigException ce) {
                String msg = _strMgr.getString("ConfigErrorInHealthChecker", (Object)lbConfigName, (Object)target);
                throw new MBeanException((Exception)((Object)ce), msg);
            }
        }
    }

    public void deleteHealthChecker(String lbConfigName, String target) throws MBeanException {
        if (lbConfigName != null) {
            LbConfig lbConfig = this.getLbConfigs().getLbConfigByName(lbConfigName);
            this.deleteHealthCheckerInternal(lbConfig, target, false);
        } else {
            LbConfig[] lbConfigs = this.getLbConfigs().getLbConfig();
            if (lbConfigs == null) {
                String msg = _strMgr.getString("NoLbConfigsElement");
                throw new MBeanException((Exception)((Object)new ConfigException(msg)));
            }
            for (int lbIdx = 0; lbIdx < lbConfigs.length; ++lbIdx) {
                this.deleteHealthCheckerInternal(lbConfigs[lbIdx], target, true);
            }
        }
    }

    private void deleteHealthCheckerInternal(LbConfig lbConfig, String target, boolean ignoreFailure) throws MBeanException {
        block14: {
            if (lbConfig == null) {
                String msg = _strMgr.getString("InvalidLbConfigName", (Object)target);
                throw new MBeanException((Exception)((Object)new ConfigException(msg)));
            }
            String lbConfigName = lbConfig.getName();
            _logger.log(Level.FINE, "[LBAdminMBean] deleteHealthChecker called - LB Config Name: " + lbConfigName + ", Target: " + target);
            if (target == null) {
                String msg = _strMgr.getString("NullTarget");
                throw new MBeanException(new RuntimeException(msg));
            }
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            try {
                if (ClusterHelper.isACluster((ConfigContext)ctx, (String)target)) {
                    ClusterRef cRef = lbConfig.getClusterRefByRef(target);
                    if (cRef == null && !ignoreFailure) {
                        String msg = _strMgr.getString("UnassociatedCluster", (Object)lbConfigName, (Object)target);
                        throw new MBeanException((Exception)((Object)new ConfigException(msg)));
                    }
                    HealthChecker hc = cRef.getHealthChecker();
                    if (hc != null) {
                        cRef.removeChild((ConfigBean)hc, true);
                        _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.HealthCheckerDeleted", (Object)target));
                    } else if (!ignoreFailure) {
                        String msg = _strMgr.getString("HealthCheckerDoesNotExist", (Object)target, (Object)lbConfigName);
                        throw new MBeanException((Exception)((Object)new ConfigException(msg)));
                    }
                    break block14;
                }
                if (ServerHelper.isAServer((ConfigContext)ctx, (String)target)) {
                    ServerRef sRef = lbConfig.getServerRefByRef(target);
                    if (sRef == null && !ignoreFailure) {
                        String msg = _strMgr.getString("UnassociatedServer", (Object)lbConfigName, (Object)target);
                        throw new MBeanException((Exception)((Object)new ConfigException(msg)));
                    }
                    HealthChecker hc = sRef.getHealthChecker();
                    if (hc != null) {
                        sRef.removeChild((ConfigBean)hc, true);
                        _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.HealthCheckerDeleted", (Object)target));
                    } else if (!ignoreFailure) {
                        String msg = _strMgr.getString("HealthCheckerDoesNotExist", (Object)target, (Object)lbConfigName);
                        throw new MBeanException((Exception)((Object)new ConfigException(msg)));
                    }
                    break block14;
                }
                String msg = _strMgr.getString("InvalidTarget", (Object)target);
                throw new MBeanException(new RuntimeException(msg));
            }
            catch (ConfigException ce) {
                String msg = _strMgr.getString("ConfigErrorInHealthChecker", (Object)lbConfigName, (Object)target);
                throw new MBeanException((Exception)((Object)ce), msg);
            }
        }
    }

    protected LbConfigs getLbConfigs() {
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            Domain domain = (Domain)ctx.getRootConfigBean();
            LbConfigs cfgs = domain.getLbConfigs();
            if (cfgs == null) {
                cfgs = new LbConfigs();
                domain.setLbConfigs(cfgs);
            }
            return cfgs;
        }
        catch (ConfigException ce) {
            return null;
        }
    }

    protected LbConfig getLbConfig(String configName) throws MBeanException {
        LbConfigs lbConfigs = this.getLbConfigs();
        if (lbConfigs == null) {
            _logger.log(Level.FINE, _sMgr.getString("http_lb_admin.NoLbConfigs"));
            String msg = _strMgr.getString("NoLbConfigsElement");
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        LbConfig lbConfig = lbConfigs.getLbConfigByName(configName);
        if (lbConfig == null) {
            _logger.log(Level.FINE, _sMgr.getString("http_lb_admin.NoLbConfigs"));
            String msg = _strMgr.getString("InvalidLbConfigName", (Object)configName);
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        return lbConfig;
    }

    public void createLBRef(String target, String configName) throws MBeanException {
        block4: {
            _logger.log(Level.FINE, "[LBAdminMbean] createLBRef called for target " + target);
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            try {
                if (ClusterHelper.isACluster((ConfigContext)ctx, (String)target)) {
                    this.addClusterToLbConfig(configName, target);
                    _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.AddClusterToConfig", (Object)target, (Object)configName));
                    break block4;
                }
                if (ServerHelper.isAServer((ConfigContext)ctx, (String)target)) {
                    this.addServerToLBConfig(configName, target);
                    _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.AddServerToConfig", (Object)target, (Object)configName));
                    break block4;
                }
                String msg = _strMgr.getString("InvalidTarget", (Object)target);
                throw new MBeanException(new RuntimeException(msg));
            }
            catch (ConfigException ce) {
                throw new MBeanException((Exception)((Object)ce));
            }
        }
    }

    private void addServerToLBConfig(String configName, String serverName) throws MBeanException {
        LbConfig lbConfig = this.getLbConfig(configName);
        ServerRef sRef = lbConfig.getServerRefByRef(serverName);
        if (sRef != null) {
            return;
        }
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            if (!ServerHelper.isServerStandAlone((ConfigContext)ctx, (String)serverName)) {
                String msg = _strMgr.getString("NotStandAloneInstance", (Object)serverName);
                throw new MBeanException((Exception)((Object)new ConfigException(msg)));
            }
            sRef = new ServerRef();
            sRef.setRef(serverName);
            lbConfig.addServerRef(sRef);
        }
        catch (ConfigException ce) {
            throw new MBeanException((Exception)((Object)ce));
        }
    }

    private void addClusterToLbConfig(String configName, String clusterName) throws MBeanException {
        LbConfig lbConfig = this.getLbConfig(configName);
        ClusterRef cRef = lbConfig.getClusterRefByRef(clusterName);
        if (cRef != null) {
            return;
        }
        cRef = new ClusterRef();
        cRef.setRef(clusterName);
        try {
            lbConfig.addClusterRef(cRef);
        }
        catch (ConfigException ce) {
            throw new MBeanException((Exception)((Object)ce));
        }
    }

    public void deleteLBRef(String target, String configName) throws MBeanException {
        block4: {
            _logger.log(Level.FINE, "[LBAdminMBean] deleteLBRef called for target " + target);
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            try {
                if (ClusterHelper.isACluster((ConfigContext)ctx, (String)target)) {
                    this.deleteClusterFromLBConfig(configName, target);
                    _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.DeleteClusterFromConfig", (Object)target, (Object)configName));
                    break block4;
                }
                if (ServerHelper.isAServer((ConfigContext)ctx, (String)target)) {
                    this.deleteServerFromLBConfig(configName, target);
                    _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.DeleteServerFromConfig", (Object)target, (Object)configName));
                    break block4;
                }
                String msg = _strMgr.getString("InvalidTarget", (Object)target);
                throw new MBeanException(new RuntimeException(msg));
            }
            catch (ConfigException ce) {
                throw new MBeanException((Exception)((Object)ce));
            }
        }
    }

    private void deleteServerFromLBConfig(String configName, String serverName) throws MBeanException {
        LbConfig lbConfig = this.getLbConfig(configName);
        ServerRef sRef = lbConfig.getServerRefByRef(serverName);
        if (sRef == null) {
            return;
        }
        if (sRef.isLbEnabled()) {
            String msg = _strMgr.getString("ServerEnabled", (Object)serverName);
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        Server s = null;
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            s = ServerHelper.getServerByName((ConfigContext)ctx, (String)sRef.getRef());
        }
        catch (ConfigException ce) {
            throw new MBeanException((Exception)((Object)ce));
        }
        if (s == null) {
            String msg = _strMgr.getString("ServerNotDefined", (Object)serverName);
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        ApplicationRef[] appRef = s.getApplicationRef();
        if (appRef == null) {
            String msg = _strMgr.getString("AppRefsNotDefined", (Object)serverName);
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        int i = 0;
        for (i = 0; i < appRef.length && !appRef[i].isLbEnabled(); ++i) {
        }
        if (i < appRef.length) {
            String msg = _strMgr.getString("AppsNotDisabled");
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        lbConfig.removeServerRef(sRef);
    }

    private void deleteClusterFromLBConfig(String configName, String clusterName) throws MBeanException {
        LbConfig lbConfig = this.getLbConfig(configName);
        ClusterRef cRef = lbConfig.getClusterRefByRef(clusterName);
        if (cRef == null) {
            return;
        }
        Cluster c = null;
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            c = ClusterHelper.getClusterByName((ConfigContext)ctx, (String)clusterName);
        }
        catch (ConfigException ce) {
            throw new MBeanException((Exception)((Object)ce));
        }
        if (c == null) {
            String msg = _strMgr.getString("ClusterNotDefined", (Object)clusterName);
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        ServerRef[] sRefs = c.getServerRef();
        for (int i = 0; i < sRefs.length; ++i) {
            if (!sRefs[i].isLbEnabled()) continue;
            String msg = _strMgr.getString("ServerEnabled", (Object)clusterName);
            throw new MBeanException((Exception)((Object)new ConfigException(msg)));
        }
        lbConfig.removeClusterRef(cRef);
    }

    public String exportLBConfig(String configName, String filePath) throws MBeanException {
        _logger.log(Level.FINE, "[LBAdminMBean] exportLbConfig called - LB Config " + configName + ", File Path " + filePath);
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            LbConfigWriter lbw = new LbConfigWriter(ctx, configName, filePath);
            String fName = lbw.write();
            _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.ExportConfig", (Object)configName, (Object)fName));
            return fName;
        }
        catch (Exception e) {
            String msg = _strMgr.getString("LbExportFailed", (Object)configName, (Object)filePath);
            throw new MBeanException(e, msg);
        }
    }
}

