/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import com.sun.enterprise.ee.admin.hadbmgmt.HADBSetupException;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBUtils;
import com.sun.enterprise.ee.admin.hadbmgmt.LoggerHelper;
import com.sun.enterprise.ee.admin.hadbmgmt.StringHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class HADBMExecutor {
    private File executable = null;
    private StringBuffer stdout = new StringBuffer();
    private StringBuffer stderr = new StringBuffer();
    private InputStream is;
    private InputStream es;

    public static void main(String[] args) {
        File f = new File("c:/bin/hadbm.exe");
        String[] ss = new String[]{"foo", "goo", "hoo"};
        HADBMExecutor ex = new HADBMExecutor();
        try {
            ex.exec(f, ss);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int exec(File exe, String[] args) throws HADBSetupException {
        if (exe == null) {
            throw new HADBSetupException("hadbmgmt-res.InternalError", StringHelper.get("hadbmgmt-res.no_executable"));
        }
        String[] commands = new String[args.length + 1];
        commands[0] = exe.getAbsolutePath();
        System.arraycopy(args, 0, commands, 1, args.length);
        StringBuffer info = new StringBuffer("HADBM Command: ");
        for (int i = 0; i < commands.length; ++i) {
            info.append(commands[i]);
            info.append(' ');
        }
        if (HADBUtils.noHADB()) {
            LoggerHelper.info("Feeble Hardware Test Mode.  Simulating running HADB commands.  ");
            LoggerHelper.info(info.toString());
            return HADBUtils.getPhonyReturnValue();
        }
        LoggerHelper.info(info.toString());
        try {
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(commands);
            this.is = new BufferedInputStream(p.getInputStream());
            this.es = new BufferedInputStream(p.getErrorStream());
            int ret = p.waitFor();
            this.readFromStream(this.is, this.stdout);
            this.readFromStream(this.es, this.stderr);
            return ret;
        }
        catch (Exception e) {
            throw new HADBSetupException("hadbmgmt-res.error_executing", (Throwable)e, this.getCommandLine(commands));
        }
    }

    public String getStdout() {
        return this.stdout.toString();
    }

    public String getStderr() {
        return this.stderr.toString();
    }

    private String getCommandLine(String[] cmds) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < cmds.length; ++i) {
            if (i != 0) {
                sb.append(' ');
            }
            sb.append(cmds[i]);
        }
        return sb.toString();
    }

    private void readFromStream(InputStream stream, StringBuffer buffer) throws IOException {
        byte[] bytes = new byte[16384];
        int count = 0;
        while ((count = stream.read(bytes)) != -1) {
            buffer.append(new String(bytes, 0, count));
        }
    }
}

