/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.configbeans;

import com.sun.enterprise.admin.configbeans.BaseConfigBean;
import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.admin.util.IAdminConstants;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.ee.admin.ExceptionHandler;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Logger;

public abstract class ServersAndClustersBaseBean
extends BaseConfigBean
implements IAdminConstants {
    private static final StringManager _strMgr = StringManager.getManager((Class)ServersAndClustersBaseBean.class);
    private static Logger _logger = null;
    private static ExceptionHandler _handler = null;

    public ServersAndClustersBaseBean(ConfigContext configContext) {
        super(configContext);
    }

    protected static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    protected static ExceptionHandler getExceptionHandler() {
        if (_handler == null) {
            _handler = new ExceptionHandler(ServersAndClustersBaseBean.getLogger());
        }
        return _handler;
    }

    private boolean isSystemApp(String objectType) {
        return objectType.equals("system-all") || objectType.equals("system-instance");
    }

    protected void addApplicationReference(Object clusterOrServer, boolean enabled, String name) throws ConfigException {
        this.addApplicationReference(clusterOrServer, enabled, name, null);
    }

    protected abstract void addApplicationReference(Object var1, boolean var2, String var3, String var4) throws ConfigException;

    protected void addSystemApplications(Object clusterOrServer) throws ConfigException {
        ConfigContext configContext = this.getConfigContext();
        Domain domain = ConfigAPIHelper.getDomainConfigBean((ConfigContext)configContext);
        Applications applications = domain.getApplications();
        ConnectorModule[] connectors = applications.getConnectorModule();
        for (int i = 0; i < connectors.length; ++i) {
            if (!this.isSystemApp(connectors[i].getObjectType())) continue;
            this.addApplicationReference(clusterOrServer, connectors[i].isEnabled(), connectors[i].getName());
        }
        EjbModule[] ejbs = applications.getEjbModule();
        for (int i = 0; i < ejbs.length; ++i) {
            if (!this.isSystemApp(ejbs[i].getObjectType())) continue;
            this.addApplicationReference(clusterOrServer, ejbs[i].isEnabled(), ejbs[i].getName());
        }
        J2eeApplication[] apps = applications.getJ2eeApplication();
        for (int i = 0; i < apps.length; ++i) {
            if (!this.isSystemApp(apps[i].getObjectType())) continue;
            this.addApplicationReference(clusterOrServer, apps[i].isEnabled(), apps[i].getName());
        }
        WebModule[] webs = applications.getWebModule();
        for (int i = 0; i < webs.length; ++i) {
            if (!this.isSystemApp(webs[i].getObjectType())) continue;
            this.addApplicationReference(clusterOrServer, webs[i].isEnabled(), webs[i].getName());
        }
    }

    protected abstract void addResourceReference(Object var1, boolean var2, String var3) throws ConfigException;

    protected void addSystemResources(Object clusterOrServer) throws ConfigException {
        ConfigContext configContext = this.getConfigContext();
        Domain domain = ConfigAPIHelper.getDomainConfigBean((ConfigContext)configContext);
        Resources resources = domain.getResources();
        ConnectorResource[] crs = resources.getConnectorResource();
        for (int i = 0; i < crs.length; ++i) {
            if (!this.isSystemApp(crs[i].getObjectType())) continue;
            this.addResourceReference(clusterOrServer, crs[i].isEnabled(), crs[i].getJndiName());
        }
        JdbcResource[] jrs = resources.getJdbcResource();
        for (int i = 0; i < jrs.length; ++i) {
            if (!this.isSystemApp(jrs[i].getObjectType())) continue;
            this.addResourceReference(clusterOrServer, jrs[i].isEnabled(), jrs[i].getJndiName());
        }
    }

    protected Config validateSharedConfiguration(ConfigContext configContext, String configName) throws ConfigException, InstanceException {
        if (configName.equals("default-config")) {
            throw new InstanceException(_strMgr.getString("cannotReferenceDefaultConfigTemplate", (Object)"default-config"));
        }
        Server das = ServerHelper.getDAS((ConfigContext)configContext);
        Config dasConfig = ServerHelper.getConfigForServer((ConfigContext)configContext, (String)das.getName());
        String dasConfigName = dasConfig.getName();
        if (configName.equals(dasConfigName)) {
            throw new InstanceException(_strMgr.getString("cannotReferenceDASConfig", (Object)dasConfigName));
        }
        return ConfigAPIHelper.getConfigByName((ConfigContext)configContext, (String)configName);
    }
}

