/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.configbeans;

import com.sun.enterprise.admin.configbeans.BaseConfigBean;
import com.sun.enterprise.admin.configbeans.ResourceReferenceHelper;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.admin.util.IAdminConstants;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ResourceHelper;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.ee.admin.ExceptionHandler;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ResourcesConfigBean
extends BaseConfigBean
implements IAdminConstants {
    private static final TargetType[] VALID_LIST_TYPES;
    private static final StringManager _strMgr;
    private static Logger _logger;
    private static ExceptionHandler _handler;
    private static final String[] mappedTypes;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    private ResourceReferenceHelper getResourceReferenceHelper() {
        return new ResourceReferenceHelper(this.getConfigContext());
    }

    protected static ExceptionHandler getExceptionHandler() {
        if (_handler == null) {
            _handler = new ExceptionHandler(ResourcesConfigBean.getLogger());
        }
        return _handler;
    }

    public ResourcesConfigBean(ConfigContext configContext) {
        super(configContext);
    }

    public void createResourceReference(String targetName, boolean enabled, String referenceName) throws ConfigException {
        try {
            this.getResourceReferenceHelper().createResourceReference(targetName, enabled, referenceName);
        }
        catch (Exception ex) {
            throw ResourcesConfigBean.getExceptionHandler().handleConfigException(ex, "eeadmin.createResourceReference.Exception", new String[]{referenceName, targetName});
        }
    }

    public void deleteResourceReference(String targetName, String referenceName) throws ConfigException {
        try {
            this.getResourceReferenceHelper().deleteResourceReference(targetName, referenceName);
        }
        catch (Exception ex) {
            throw ResourcesConfigBean.getExceptionHandler().handleConfigException(ex, "eeadmin.deleteResourceReference.Exception", new String[]{referenceName, targetName});
        }
    }

    public String[] listResourceReferencesAsString(String targetName) throws ConfigException {
        try {
            ConfigContext configContext = this.getConfigContext();
            Target target = TargetBuilder.INSTANCE.createTarget(VALID_LIST_TYPES, targetName, configContext);
            String refName = null;
            ResourceRef[] refs = target.getResourceRefs();
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < refs.length; ++i) {
                refName = refs[i].getRef();
                if (ResourceHelper.isSystemResource((ConfigContext)configContext, (String)refName)) continue;
                result.add(refName);
            }
            return result.toArray(new String[result.size()]);
        }
        catch (Exception ex) {
            throw ResourcesConfigBean.getExceptionHandler().handleConfigException(ex, "eeadmin.listResourceReferences.Exception", targetName);
        }
    }

    public String getResourceType(String id) throws ConfigException {
        String type = ResourceHelper.getResourceType((ConfigContext)this.getConfigContext(), (String)id);
        if (null == type) {
            throw new ConfigException(_strMgr.getString("noSuchResource", (Object)id));
        }
        String externalType = ResourceTypeMapper.extern(type);
        if (!$assertionsDisabled && externalType == null) {
            throw new AssertionError((Object)("No external mapping found for " + type));
        }
        return externalType;
    }

    static {
        $assertionsDisabled = !ResourcesConfigBean.class.desiredAssertionStatus();
        VALID_LIST_TYPES = new TargetType[]{TargetType.CLUSTER, TargetType.SERVER, TargetType.DAS};
        _strMgr = StringManager.getManager((Class)ResourcesConfigBean.class);
        _logger = null;
        _handler = null;
        mappedTypes = new String[]{"CustomResource", ServerTags.CUSTOM_RESOURCE, "ExternalJndiResource", ServerTags.EXTERNAL_JNDI_RESOURCE, "JdbcResource", ServerTags.JDBC_RESOURCE, "MailResource", ServerTags.MAIL_RESOURCE, "AdminObjectResource", ServerTags.ADMIN_OBJECT_RESOURCE, "ConnectorResource", ServerTags.CONNECTOR_RESOURCE, "ResourceAdapterConfig", ServerTags.RESOURCE_ADAPTER_CONFIG, "JdbcConnectionPool", ServerTags.JDBC_CONNECTION_POOL, "ConnectorConnectionPool", ServerTags.CONNECTOR_CONNECTION_POOL, "PersistenceManagerFactoryResource", ServerTags.PERSISTENCE_MANAGER_FACTORY_RESOURCE};
    }

    private static final class ResourceTypeMapper {
        private ResourceTypeMapper() {
        }

        private static String extern(String internalType) {
            for (int i = 0; i < mappedTypes.length; i += 2) {
                if (!mappedTypes[i].equals(internalType)) continue;
                return mappedTypes[i + 1];
            }
            return null;
        }
    }
}

