/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.configbeans;

import com.sun.enterprise.admin.WarningException;
import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.admin.servermgmt.RuntimeStatusList;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.admin.util.IAdminConstants;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.ee.admin.concurrent.Executor;
import com.sun.enterprise.ee.admin.concurrent.Task;
import com.sun.enterprise.ee.admin.configbeans.ConfigsConfigBean;
import com.sun.enterprise.ee.admin.configbeans.ServersAndClustersBaseBean;
import com.sun.enterprise.ee.admin.configbeans.ServersConfigBean;
import com.sun.enterprise.ee.admin.servermgmt.EEInstancesManager;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public class ClustersConfigBean
extends ServersAndClustersBaseBean
implements IAdminConstants {
    private static final TargetType[] VALID_TYPES;
    private static final StringManager _strMgr;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ClustersConfigBean(ConfigContext configContext) {
        super(configContext);
    }

    public String[] listClustersAsString(String targetName, boolean withStatus) throws InstanceException {
        try {
            StringManager stringMgr = StringManager.getManager((Class)EEInstancesManager.class);
            String[] result = this.toStringArray(this.getClusters(targetName));
            int numClusters = result.length;
            for (int i = 0; i < numClusters; ++i) {
                String name = result[i];
                if (withStatus) {
                    RuntimeStatusList statusList = this.getRuntimeStatus(name);
                    result[i] = stringMgr.getString("listInstanceElement", (Object)name, (Object)statusList.toString());
                    continue;
                }
                result[i] = name;
            }
            return result;
        }
        catch (Exception ex) {
            throw ClustersConfigBean.getExceptionHandler().handleInstanceException(ex, "eeadmin.listClusters.Exception", targetName);
        }
    }

    public RuntimeStatusList getRuntimeStatus(String clusterName) throws InstanceException {
        try {
            String[] servers = this.getServersInCluster(clusterName);
            ServersConfigBean cmb = this.getServersConfigBean();
            return cmb.getRuntimeStatus(servers);
        }
        catch (Exception ex) {
            throw ClustersConfigBean.getExceptionHandler().handleInstanceException(ex, "eeadmin.getClusterStatus.Exception", clusterName);
        }
    }

    public void clearRuntimeStatus(String clusterName) throws InstanceException {
        try {
            String[] servers = this.getServersInCluster(clusterName);
            ServersConfigBean cmb = this.getServersConfigBean();
            for (int i = 0; i < servers.length; ++i) {
                cmb.clearRuntimeStatus(servers[i]);
            }
        }
        catch (Exception ex) {
            throw ClustersConfigBean.getExceptionHandler().handleInstanceException(ex, "eeadmin.getClusterStatus.Exception", clusterName);
        }
    }

    public RuntimeStatusList startCluster(String clusterName) throws InstanceException {
        RuntimeStatusList status = this.getRuntimeStatus(clusterName);
        if (status.isEmpty()) {
            throw new InstanceException(_strMgr.getString("clusterIsEmpty", (Object)clusterName));
        }
        if (status.allRunning()) {
            throw new InstanceException(_strMgr.getString("clusterAlreadyStarted", (Object)clusterName));
        }
        ArrayList msgsList = new ArrayList();
        this.doStartCluster(clusterName, msgsList);
        status = this.getRuntimeStatus(clusterName);
        if (!status.allRunning()) {
            boolean bAny = status.anyRunning();
            String msg = _strMgr.getString(bAny ? "clusterNotFullyStarted" : "clusterNotStarted", (Object)clusterName);
            for (int i = 0; i < msgsList.size(); ++i) {
                msg = msg + "\n" + msgsList.get(i);
            }
            if (bAny) {
                throw new WarningException(msg);
            }
            throw new InstanceException(msg);
        }
        return status;
    }

    private void doStartCluster(String clusterName, ArrayList msgsList) throws InstanceException {
        try {
            String[] servers = this.getServersInCluster(clusterName);
            Task[] tasks = new StartServerTask[servers.length];
            for (int i = 0; i < servers.length; ++i) {
                tasks[i] = new StartServerTask(servers[i], msgsList);
            }
            Executor exec = new Executor(tasks);
            exec.run();
        }
        catch (Exception ex) {
            throw ClustersConfigBean.getExceptionHandler().handleInstanceException(ex, "eeadmin.startCluster.Exception", clusterName);
        }
    }

    public RuntimeStatusList stopCluster(String clusterName) throws InstanceException {
        RuntimeStatusList status = this.getRuntimeStatus(clusterName);
        if (status.isEmpty()) {
            throw new InstanceException(_strMgr.getString("clusterIsEmpty", (Object)clusterName));
        }
        if (!status.anyRunning()) {
            throw new InstanceException(_strMgr.getString("clusterAlreadyStopped", (Object)clusterName));
        }
        this.doStopCluster(clusterName);
        status = this.getRuntimeStatus(clusterName);
        if (status.anyRunning()) {
            throw new InstanceException(_strMgr.getString("clusterNotFullyStopped", (Object)clusterName));
        }
        return status;
    }

    private void doStopCluster(String clusterName) throws InstanceException {
        try {
            String[] servers = this.getServersInCluster(clusterName);
            Task[] tasks = new StopServerTask[servers.length];
            for (int i = 0; i < servers.length; ++i) {
                tasks[i] = new StopServerTask(servers[i]);
            }
            Executor exec = new Executor(tasks);
            exec.run();
        }
        catch (Exception ex) {
            throw ClustersConfigBean.getExceptionHandler().handleInstanceException(ex, "eeadmin.stopCluster.Exception", clusterName);
        }
    }

    public void deleteCluster(String clusterName) throws InstanceException {
        try {
            ConfigContext configContext = this.getConfigContext();
            Cluster cluster = ClusterHelper.getClusterByName((ConfigContext)configContext, (String)clusterName);
            Server[] servers = ServerHelper.getServersInCluster((ConfigContext)configContext, (String)clusterName);
            if (servers.length > 0) {
                throw new InstanceException(_strMgr.getString("clusterNotEmpty", (Object)clusterName, (Object)ServerHelper.getServersAsString((Server[])servers)));
            }
            Domain domain = ConfigAPIHelper.getDomainConfigBean((ConfigContext)configContext);
            Clusters clusters = domain.getClusters();
            if (ClusterHelper.isClusterStandAlone((ConfigContext)configContext, (String)clusterName)) {
                String configName = cluster.getConfigRef();
                clusters.removeCluster(cluster, true);
                this.getConfigsConfigBean().deleteConfiguration(configName);
            } else {
                clusters.removeCluster(cluster, true);
            }
        }
        catch (Exception ex) {
            throw ClustersConfigBean.getExceptionHandler().handleInstanceException(ex, "eeadmin.deleteCluster.Exception", clusterName);
        }
    }

    protected void addApplicationReference(Object cluster, boolean enabled, String name, String virtualServers) throws ConfigException {
        ApplicationRef ref = new ApplicationRef();
        ref.setEnabled(enabled);
        ref.setRef(name);
        if (virtualServers != null) {
            ref.setVirtualServers(virtualServers);
        }
        ((Cluster)cluster).addApplicationRef(ref, true);
    }

    protected void addResourceReference(Object cluster, boolean enabled, String name) throws ConfigException {
        ResourceRef ref = new ResourceRef();
        ref.setEnabled(enabled);
        ref.setRef(name);
        ((Cluster)cluster).addResourceRef(ref, true);
    }

    public void createCluster(String clusterName, String configName, Properties props) throws InstanceException {
        try {
            ConfigContext configContext = this.getConfigContext();
            if (!ConfigAPIHelper.isNameUnique((ConfigContext)configContext, (String)clusterName)) {
                throw new InstanceException(_strMgr.getString("clusterNameNotUnique", (Object)clusterName));
            }
            Domain domain = ConfigAPIHelper.getDomainConfigBean((ConfigContext)configContext);
            Clusters clusters = domain.getClusters();
            Cluster cluster = clusters.getClusterByName(clusterName);
            if (cluster != null) {
                throw new InstanceException(_strMgr.getString("clusterAlreadyExists", (Object)clusterName));
            }
            cluster = new Cluster();
            cluster.setName(clusterName);
            if (configName != null) {
                Config config = this.validateSharedConfiguration(configContext, configName);
                cluster.setConfigRef(configName);
                if (props != null) {
                    Enumeration<?> e = props.propertyNames();
                    while (e.hasMoreElements()) {
                        String propName = (String)e.nextElement();
                        String propValue = props.getProperty(propName);
                        if (propValue == null) continue;
                        SystemProperty ep = new SystemProperty();
                        ep.setName(propName);
                        ep.setValue(propValue);
                        cluster.addSystemProperty(ep, true);
                    }
                }
            } else {
                String stanaloneConfigName = this.getConfigsConfigBean().createStandAloneConfiguration(clusterName, props);
                cluster.setConfigRef(stanaloneConfigName);
            }
            this.addSystemApplications(cluster);
            this.addSystemResources(cluster);
            clusters.addCluster(cluster, true);
        }
        catch (Exception ex) {
            throw ClustersConfigBean.getExceptionHandler().handleInstanceException(ex, "eeadmin.createCluster.Exception", clusterName);
        }
    }

    private Cluster[] getClusters(String targetName) throws ConfigException {
        Target target = TargetBuilder.INSTANCE.createTarget("domain", VALID_TYPES, targetName, this.getConfigContext());
        Cluster[] clusters = target.getClusters();
        if (!$assertionsDisabled && clusters == null) {
            throw new AssertionError();
        }
        return clusters;
    }

    private String[] getServersInCluster(String clusterName) throws ConfigException {
        String[] sa = new String[]{};
        Server[] servers = ServerHelper.getServersInCluster((ConfigContext)this.getConfigContext(), (String)clusterName);
        if (servers != null) {
            sa = new String[servers.length];
            for (int i = 0; i < sa.length; ++i) {
                sa[i] = servers[i].getName();
            }
        }
        return sa;
    }

    private ConfigsConfigBean getConfigsConfigBean() {
        return new ConfigsConfigBean(this.getConfigContext());
    }

    private ServersConfigBean getServersConfigBean() {
        return new ServersConfigBean(this.getConfigContext());
    }

    private String[] toStringArray(Cluster[] ca) {
        int numClusters = ca.length;
        String[] result = new String[numClusters];
        for (int i = 0; i < numClusters; ++i) {
            result[i] = ca[i].getName();
        }
        return result;
    }

    static {
        $assertionsDisabled = !ClustersConfigBean.class.desiredAssertionStatus();
        VALID_TYPES = new TargetType[]{TargetType.DOMAIN, TargetType.CLUSTER, TargetType.SERVER, TargetType.NODE_AGENT};
        _strMgr = StringManager.getManager((Class)ClustersConfigBean.class);
    }

    class StopServerTask
    extends Task {
        private static final long TIMEOUT_IN_MILLIS = 120000L;
        String _serverName;

        public StopServerTask(String serverName) {
            super(120000L);
            this._serverName = serverName;
        }

        public void run() {
            try {
                ClustersConfigBean.this.getServersConfigBean().stopServerInstance(this._serverName);
            }
            catch (InstanceException instanceException) {
                // empty catch block
            }
        }
    }

    class StartServerTask
    extends Task {
        private static final long TIMEOUT_IN_MILLIS = 600000L;
        String _serverName;
        ArrayList _msgsList;

        public StartServerTask(String serverName, ArrayList msgsList) {
            super(600000L);
            this._serverName = serverName;
            this._msgsList = msgsList;
        }

        public void run() {
            try {
                ClustersConfigBean.this.getServersConfigBean().startServerInstance(this._serverName);
            }
            catch (InstanceException ex) {
                this.addMsgToList(ex.getMessage());
            }
        }

        synchronized void addMsgToList(String msg) {
            this._msgsList.add(msg);
        }
    }
}

