/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.framework;

import com.sun.enterprise.cli.framework.Command;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.LocalStringsManager;
import com.sun.enterprise.cli.framework.LocalStringsManagerFactory;
import com.sun.enterprise.cli.framework.ValidCommand;
import com.sun.enterprise.cli.framework.ValidOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class CommandFactory {
    public static Command createCommand(ValidCommand commandMatched, HashMap options, Vector operands) throws CommandValidationException {
        Command command = null;
        String commandName = commandMatched.getName();
        String className = commandMatched.getClassName();
        if (className == null) {
            LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
            throw new CommandValidationException(lsm.getString("InvalidCommand", new Object[]{commandName}));
        }
        try {
            Class<?> theClass = Class.forName(className);
            command = (Command)theClass.newInstance();
            command.setName(commandName);
            command.setOptions(options);
            command.setOperands(CommandFactory.determineOperand(operands, commandMatched.getDefaultOperand()));
            command.setUsageText(commandMatched.getUsageText());
            command.setProperties(commandMatched.getProperties());
            command.setBooleanOptions(CommandFactory.constructBooleanOptionsList(commandMatched));
        }
        catch (Exception e) {
            LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
            throw new CommandValidationException(lsm.getString("UnableToCreateCommand", new Object[]{commandName}), e);
        }
        return command;
    }

    private static List constructBooleanOptionsList(ValidCommand validCommand) {
        Vector<String> booleanOptionsList = new Vector<String>();
        Vector requiredOptions = validCommand.getRequiredOptions();
        for (int ii = 0; ii < requiredOptions.size(); ++ii) {
            ValidOption validOption = (ValidOption)requiredOptions.get(ii);
            if (!validOption.getType().equals("boolean")) continue;
            booleanOptionsList.add(validOption.getName());
        }
        Vector validOptions = validCommand.getValidOptions();
        for (int ii = 0; ii < validOptions.size(); ++ii) {
            ValidOption validOption = (ValidOption)validOptions.get(ii);
            if (!validOption.getType().equals("boolean")) continue;
            booleanOptionsList.add(validOption.getName());
        }
        return booleanOptionsList;
    }

    private static Vector determineOperand(Vector operands, String defaultOperand) {
        return operands.size() < 1 && defaultOperand != null ? new Vector<String>(Arrays.asList(defaultOperand)) : operands;
    }
}

