/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class OldUndeployCommand
extends S1ASCommand {
    private static final String CASCADE_OPTION = "cascade";
    private static final String DROPTABLES_OPTION = "droptables";
    private static final String TARGET_OPTION = "target";

    public void runCommand() throws CommandException, CommandValidationException {
        DeploymentStatus status;
        this.validateOptions();
        ObjectName objectName = this.constructObjectName();
        MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
        Properties props = this.createDeploymentProperties();
        Object[] params = new Object[]{props};
        String[] signature = new String[]{"java.util.Properties"};
        try {
            status = (DeploymentStatus)mbsc.invoke(objectName, "undeploy", params, signature);
        }
        catch (Exception e) {
            if (e.getLocalizedMessage() != null) {
                CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            }
            throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), e);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bos);
        DeploymentStatus.parseDeploymentStatus((DeploymentStatus)status, (PrintWriter)pw);
        byte[] statusBytes = bos.toByteArray();
        String statusString = new String(statusBytes);
        if (status != null && status.getStatus() == 0) {
            throw new CommandException(this.getLocalizedString("CommandUnSuccessfulWithMsg", new Object[]{this.name, statusString}));
        }
        if (status != null && status.getStatus() == 1) {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessfulWithMsg", new Object[]{this.name, statusString}));
        } else {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
    }

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    private ObjectName constructObjectName() throws CommandValidationException {
        try {
            return new ObjectName(this.getObjectName());
        }
        catch (Exception e) {
            throw new CommandValidationException(e);
        }
    }

    private String getComponentName() {
        return (String)this.getOperands().get(0);
    }

    private Properties createDeploymentProperties() {
        Properties props = new Properties();
        String cascadeOption = this.getOption(CASCADE_OPTION);
        String dropTablesOption = this.getOption(DROPTABLES_OPTION);
        String target = this.getOption(TARGET_OPTION);
        if (props != null) {
            props.setProperty(TARGET_OPTION, target);
        }
        props.setProperty("name", this.getComponentName());
        if (cascadeOption != null) {
            props.setProperty(CASCADE_OPTION, cascadeOption);
        }
        if (dropTablesOption != null) {
            props.setProperty("CmpInfo.DROP_TABLES", dropTablesOption);
        }
        return props;
    }
}

