/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.portable;

import java.io.FileInputStream;
import java.util.Properties;
import javax.ejb.spi.HandleDelegate;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class HandleDelegateUtil {
    private static final String JNDI_PROPERTY_FILE_NAME = "com.sun.ejb.portable.jndi.propertyfilename";
    private static boolean checkedJndiProperties = false;
    private static Properties jndiProperties = null;

    static HandleDelegate getHandleDelegate() throws NamingException {
        HandleDelegate handleDelegate;
        try {
            InitialContext ctx = new InitialContext();
            handleDelegate = (HandleDelegate)ctx.lookup("java:comp/HandleDelegate");
        }
        catch (NamingException ne) {
            Properties props = null;
            try {
                props = HandleDelegateUtil.getJndiProperties();
            }
            catch (Exception e) {
                NamingException ne2 = new NamingException("Error while accessing com.sun.ejb.portable.jndi.propertyfilename : " + e.getMessage());
                ne2.initCause(e);
                throw ne2;
            }
            if (props == null) {
                NamingException ne3 = new NamingException("java:comp/HandleDelegate not found. Unable to  use jndi property file override since com.sun.ejb.portable.jndi.propertyfilename has NOT been set");
                ne3.initCause(ne);
                throw ne3;
            }
            try {
                InitialContext ctx = new InitialContext(props);
                handleDelegate = (HandleDelegate)ctx.lookup("java:comp/HandleDelegate");
            }
            catch (NamingException ne4) {
                NamingException overrideEx = new NamingException("Unable to lookup HandleDelegate with override properties = " + props.toString());
                overrideEx.initCause(ne4);
                throw overrideEx;
            }
        }
        return handleDelegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getJndiProperties() throws Exception {
        Class clazz = HandleDelegateUtil.class;
        synchronized (clazz) {
            if (!checkedJndiProperties) {
                try {
                    String jndiPropertyFileName = System.getProperty(JNDI_PROPERTY_FILE_NAME);
                    if (jndiPropertyFileName != null) {
                        FileInputStream fis = new FileInputStream(jndiPropertyFileName);
                        jndiProperties = new Properties();
                        jndiProperties.load(fis);
                    }
                }
                finally {
                    checkedJndiProperties = true;
                }
            }
        }
        return jndiProperties;
    }
}

