/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.impl;

import com.sun.jdo.api.persistence.support.ConnectionFactory;
import com.sun.jdo.api.persistence.support.JDOCanRetryException;
import com.sun.jdo.api.persistence.support.JDODataStoreException;
import com.sun.jdo.api.persistence.support.JDOException;
import com.sun.jdo.api.persistence.support.JDOFatalException;
import com.sun.jdo.api.persistence.support.JDOUnsupportedOptionException;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.connection.ConnectionManager;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ResourceBundle;

public class ConnectionFactoryImpl
implements ConnectionFactory,
Serializable {
    private String URL = null;
    private String userName = null;
    private String password = null;
    private String driverName = null;
    private int maxPool = 0;
    private int minPool = 0;
    private int msInterval = 0;
    private int loginTimeout = 0;
    private int msWait = 0;
    private int _txIsolation = -1;
    private PrintWriter logWriter = null;
    private transient boolean _configured = false;
    private transient ConnectionManager connectionManager = null;
    private static final transient ResourceBundle messages = I18NHelper.loadBundle(ConnectionFactoryImpl.class);

    public ConnectionFactoryImpl() {
    }

    public ConnectionFactoryImpl(String URL2, String userName, String password, String driverName) {
        this.driverName = driverName;
        this.URL = URL2;
        this.userName = userName;
        this.password = password;
    }

    public ConnectionFactoryImpl(String URL2, String userName, String password, String driverName, int minPool, int maxPool) {
        this.driverName = driverName;
        this.URL = URL2;
        this.userName = userName;
        this.password = password;
        this.minPool = minPool;
        this.maxPool = maxPool;
    }

    public void setDriverName(String driverName) {
        this.assertNotConfigured();
        if (this.connectionManager == null) {
            this.driverName = driverName;
        } else {
            try {
                this.connectionManager.setDriverName(driverName);
            }
            catch (Exception e) {
                throw new JDOFatalException(null, e);
            }
        }
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setURL(String URL2) {
        this.assertNotConfigured();
        if (this.connectionManager == null) {
            this.URL = URL2;
        } else {
            try {
                this.connectionManager.setURL(URL2);
            }
            catch (Exception e) {
                throw new JDOFatalException(null, e);
            }
        }
    }

    public String getURL() {
        return this.URL;
    }

    public void setUserName(String userName) {
        this.assertNotConfigured();
        if (this.connectionManager == null) {
            this.userName = userName;
        } else {
            try {
                this.connectionManager.setUserName(userName);
            }
            catch (Exception e) {
                throw new JDOFatalException(null, e);
            }
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String password) {
        this.assertNotConfigured();
        if (this.connectionManager == null) {
            this.password = password;
        } else {
            try {
                this.connectionManager.setPassword(password);
            }
            catch (Exception e) {
                throw new JDOFatalException(null, e);
            }
        }
    }

    public void setMinPool(int minPool) {
        this.assertNotConfigured();
        if (this.connectionManager == null) {
            this.minPool = minPool;
            return;
        }
        try {
            this.connectionManager.setMinPool(minPool);
        }
        catch (Exception e) {
            throw new JDOFatalException(null, e);
        }
    }

    public int getMinPool() {
        return this.minPool;
    }

    public void setMaxPool(int maxPool) {
        this.assertNotConfigured();
        if (this.connectionManager == null) {
            this.maxPool = maxPool;
            return;
        }
        try {
            this.connectionManager.setMaxPool(maxPool);
        }
        catch (Exception e) {
            throw new JDOFatalException(null, e);
        }
    }

    public int getMaxPool() {
        return this.maxPool;
    }

    public void setMsInterval(int msInterval) {
        this.assertNotConfigured();
        if (this.connectionManager == null) {
            this.msInterval = msInterval;
            return;
        }
        try {
            this.connectionManager.setMsInterval(msInterval);
        }
        catch (Exception e) {
            throw new JDOFatalException(null, e);
        }
    }

    public int getMsInterval() {
        if (this.connectionManager == null) {
            return this.msInterval;
        }
        return this.connectionManager.getMsInterval();
    }

    public void setMsWait(int msWait) {
        this.assertNotConfigured();
        if (this.connectionManager == null) {
            this.msWait = msWait;
            return;
        }
        try {
            this.connectionManager.setMsWait(msWait);
        }
        catch (Exception e) {
            throw new JDOFatalException(null, e);
        }
    }

    public int getMsWait() {
        if (this.connectionManager == null) {
            return this.msWait;
        }
        return this.connectionManager.getMsWait();
    }

    public void setLogWriter(PrintWriter logWriter) {
        this.assertNotConfigured();
        this.logWriter = logWriter;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLoginTimeout(int loginTimeout) {
        this.assertNotConfigured();
        if (this.connectionManager == null) {
            this.loginTimeout = loginTimeout;
            return;
        }
        try {
            this.connectionManager.setLoginTimeout(loginTimeout);
        }
        catch (Exception e) {
            throw new JDOFatalException(null, e);
        }
    }

    public int getLoginTimeout() {
        if (this.connectionManager == null) {
            return this.loginTimeout;
        }
        try {
            return this.connectionManager.getLoginTimeout();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setTransactionIsolation(int level) {
        block7: {
            this.assertNotConfigured();
            if (this.connectionManager == null) {
                this._txIsolation = level;
                return;
            }
            Connection conn = null;
            try {
                conn = this.connectionManager.getConnection();
                DatabaseMetaData dbMetaData = conn.getMetaData();
                if (dbMetaData.supportsTransactionIsolationLevel(level)) {
                    this._txIsolation = level;
                    break block7;
                }
                throw new JDOFatalException(I18NHelper.getMessage(messages, "connectionefactoryimpl.isolationlevel_notsupported", level));
            }
            catch (Exception e) {
                throw new JDOFatalException(null, e);
            }
            finally {
                this.closeConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTransactionIsolation() {
        if (this.connectionManager == null) {
            return this._txIsolation;
        }
        Connection conn = null;
        try {
            if (this._txIsolation == -1) {
                ConnectionFactoryImpl connectionFactoryImpl = this;
                synchronized (connectionFactoryImpl) {
                    if (this._txIsolation == -1) {
                        conn = this.connectionManager.getConnection();
                        this._txIsolation = conn.getTransactionIsolation();
                    }
                }
            }
            int n = this._txIsolation;
            return n;
        }
        catch (Exception e) {
            throw new JDOFatalException(null, e);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public Connection getConnection() {
        try {
            if (this.connectionManager == null) {
                this.initialize();
            }
            Connection conn = this.connectionManager.getConnection();
            conn.setTransactionIsolation(this._txIsolation);
            return conn;
        }
        catch (SQLException e) {
            String sqlState = e.getSQLState();
            int errorCode = e.getErrorCode();
            if (sqlState == null) {
                throw new JDODataStoreException(I18NHelper.getMessage(messages, "connectionefactoryimpl.sqlexception", "null", "" + errorCode), e);
            }
            throw new JDODataStoreException(I18NHelper.getMessage(messages, "connectionefactoryimpl.sqlexception", sqlState, "" + errorCode), e);
        }
        catch (Exception e) {
            throw new JDOCanRetryException(I18NHelper.getMessage(messages, "connectionefactoryimpl.getconnection"), e);
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ConnectionFactoryImpl) {
            ConnectionFactoryImpl cf = (ConnectionFactoryImpl)obj;
            return cf.URL.equals(this.URL) && cf.userName.equals(this.userName) && cf.driverName.equals(this.driverName) && cf.password.equals(this.password);
        }
        return false;
    }

    public int hashCode() {
        return this.URL.hashCode() + this.userName.hashCode() + this.password.hashCode() + this.driverName.hashCode();
    }

    public void configured(boolean flag) {
        this._configured = flag;
    }

    private void assertNotConfigured() {
        if (this._configured) {
            throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "persistencemanagerfactoryimpl.configured"));
        }
    }

    private void assertConnectionWait() {
        if (this.msWait < 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "connection.connectionmanager.mswaitvalue"));
        }
        if (this.msInterval < 0 || this.msInterval > this.msWait || this.msWait > 0 && this.msInterval == 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "connection.connectionmanager.msintervalvalue"));
        }
    }

    private synchronized void initialize() {
        if (this.connectionManager != null) {
            return;
        }
        try {
            this.assertConnectionWait();
            this.connectionManager = new ConnectionManager(this.driverName, this.URL, this.userName, this.password, this.minPool, this.maxPool);
            this.connectionManager.setMsWait(this.msWait);
            this.connectionManager.setMsInterval(this.msInterval);
            this.connectionManager.setLoginTimeout(this.loginTimeout);
            if (this._txIsolation > 0) {
                this.setTransactionIsolation(this._txIsolation);
            } else {
                this._txIsolation = this.getTransactionIsolation();
            }
            this.configured(true);
        }
        catch (JDOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JDOFatalException(null, e);
        }
    }

    private void unsupported() {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "persistencemanagerfactoryimpl.notsupported"));
    }

    private void closeConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        conn = null;
    }
}

