/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.ejb;

import com.sun.ejb.Container;
import com.sun.ejb.containers.EntityContextImpl;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.server.ApplicationRegistry;
import com.sun.jdo.api.persistence.support.JDOException;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOFatalUserException;
import com.sun.jdo.api.persistence.support.PersistenceManager;
import com.sun.jdo.api.persistence.support.PersistenceManagerFactory;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperPersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.CMPHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.ContainerHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.SunTransactionHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.impl.PersistenceManagerFactoryImpl;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.Transaction;

public class SunContainerHelper
extends SunTransactionHelper
implements ContainerHelper {
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", SunContainerHelper.class.getClassLoader());
    private static Logger logger = LogHelperPersistenceManager.getLogger();

    SunContainerHelper() {
    }

    public Object getContainer(Object info) {
        Object[] params = (Object[])info;
        Class cls = (Class)params[0];
        ApplicationRegistry reg = ApplicationRegistry.getInstance();
        Application app = reg.getApplication(cls.getClassLoader());
        EjbCMPEntityDescriptor desc = app.getCMPDescriptorFor((String)params[1]);
        return reg.getContainer((EjbDescriptor)desc);
    }

    public EJBObject getEJBObject(Object pk, Object container) {
        try {
            return ((Container)container).getEJBObjectForPrimaryKey(pk);
        }
        catch (Exception ex) {
            throw new JDOFatalInternalException(ex.getMessage(), ex);
        }
    }

    public EJBLocalObject getEJBLocalObject(Object pk, Object container) {
        try {
            return ((Container)container).getEJBLocalObjectForPrimaryKey(pk);
        }
        catch (Exception ex) {
            throw new JDOFatalInternalException(ex.getMessage(), ex);
        }
    }

    public EJBLocalObject getEJBLocalObject(Object pk, Object container, EJBContext context) {
        EJBLocalObject rc = null;
        try {
            rc = ((Container)container).getEJBLocalObjectForPrimaryKey(pk, context);
        }
        catch (Exception ex) {
            this.processContainerException(ex);
        }
        return rc;
    }

    public void removeByEJBLocalObject(EJBLocalObject ejb, Object container) {
        try {
            ((Container)container).removeBeanUnchecked(ejb);
        }
        catch (Exception ex) {
            this.processContainerException(ex);
        }
    }

    public void removeByPK(Object pk, Object container) {
        try {
            ((Container)container).removeBeanUnchecked(pk);
        }
        catch (Exception ex) {
            this.processContainerException(ex);
        }
    }

    public void assertValidLocalObject(Object o, Object container) {
        ((Container)container).assertValidLocalObject(o);
    }

    public void assertValidRemoteObject(Object o, Object container) {
        ((Container)container).assertValidRemoteObject(o);
    }

    public void setCascadeDeleteAfterSuperEJBRemove(EntityContext context) {
        try {
            ((EntityContextImpl)context).setCascadeDeleteAfterSuperEJBRemove(true);
        }
        catch (Exception ex) {
            this.processContainerException(ex);
        }
    }

    public void preSelect(Object container) {
        ((Container)container).preSelect();
    }

    public PersistenceManagerFactory getPersistenceManagerFactory(Object container) {
        PersistenceManagerFactoryImpl pmf;
        block6: {
            Object rc = null;
            pmf = null;
            ResourceReferenceDescriptor cmpResource = ((Container)container).getEjbDescriptor().getEjbBundleDescriptor().getCMPResourceReference();
            String name = cmpResource.getJndiName();
            try {
                InitialContext ic = new InitialContext();
                rc = ic.lookup(name);
                if (rc instanceof PersistenceManagerFactoryImpl) {
                    pmf = (PersistenceManagerFactoryImpl)rc;
                    break block6;
                }
                if (rc instanceof DataSource) {
                    pmf = new PersistenceManagerFactoryImpl();
                    pmf.setConnectionFactoryName(ResourceInstaller.getPMJndiName((String)name));
                    Iterator it = cmpResource.getProperties();
                    if (it != null) {
                        while (it.hasNext()) {
                            NameValuePairDescriptor prop = (NameValuePairDescriptor)it.next();
                            String n = prop.getName();
                            boolean value = Boolean.valueOf(prop.getValue());
                            pmf.setBooleanProperty(n, value);
                        }
                    }
                    break block6;
                }
                JDOFatalUserException e = new JDOFatalUserException(I18NHelper.getMessage(messages, "ejb.jndi.unexpectedinstance", name, rc.getClass().getName()));
                logger.severe(((Throwable)e).toString());
                throw e;
            }
            catch (NamingException ex) {
                JDOFatalUserException e = new JDOFatalUserException(I18NHelper.getMessage(messages, "ejb.jndi.lookupfailed", name), ex);
                logger.severe(((Throwable)e).toString());
                throw e;
            }
        }
        return pmf;
    }

    public int getNumericConverterPolicy(Object container) {
        return 0;
    }

    public void beginInternalTransaction(PersistenceManager pm) {
        pm.currentTransaction().begin();
    }

    public void commitInternalTransaction(PersistenceManager pm) {
        pm.currentTransaction().commit();
    }

    public void rollbackInternalTransaction(PersistenceManager pm) {
        pm.currentTransaction().rollback();
    }

    public Transaction suspendCurrentTransaction() {
        Transaction tx = null;
        try {
            tx = this.getLocalTransactionManager().suspend();
        }
        catch (Exception ex) {
            this.processContainerException(ex);
        }
        return tx;
    }

    public void resumeCurrentTransaction(Transaction tx) {
        try {
            if (tx != null) {
                this.getLocalTransactionManager().resume(tx);
            }
        }
        catch (Exception ex) {
            this.processContainerException(ex);
        }
    }

    private void processContainerException(Exception ex) {
        if (ex instanceof EJBException) {
            throw (EJBException)((Object)ex);
        }
        if (ex instanceof IllegalArgumentException || ex instanceof IllegalStateException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof JDOException) {
            throw (JDOException)ex;
        }
        throw new EJBException(ex);
    }

    static {
        CMPHelper.registerContainerHelper(new SunContainerHelper());
    }
}

