/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbc;

import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.QueryDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractMethodHelper {
    public static final int LOCAL_RETURN = 0;
    public static final int REMOTE_RETURN = 1;
    public static final int NO_RETURN = 2;
    private EjbCMPEntityDescriptor _cmpDescriptor;
    private List finders = new ArrayList();
    private List selectors = new ArrayList();
    private List createMethods = new ArrayList();
    private Map methodNames = new HashMap();

    public AbstractMethodHelper(EjbCMPEntityDescriptor descriptor) {
        this._cmpDescriptor = descriptor;
        this.categorizeMethods();
    }

    protected EjbCMPEntityDescriptor getDescriptor() {
        return this._cmpDescriptor;
    }

    protected void categorizeMethods() {
        EjbCMPEntityDescriptor descriptor = this.getDescriptor();
        Iterator iterator = descriptor.getMethodDescriptors().iterator();
        while (iterator.hasNext()) {
            MethodDescriptor methodDescriptor = (MethodDescriptor)iterator.next();
            Method method = methodDescriptor.getMethod((EjbDescriptor)descriptor);
            String methodName = methodDescriptor.getName();
            if (methodName.startsWith("find")) {
                this.finders.add(method);
            } else if (methodName.startsWith("ejbSelect")) {
                this.selectors.add(method);
            } else if (methodName.startsWith("create")) {
                this.createMethods.add(method);
            } else if (methodName.startsWith("get") || methodName.startsWith("set")) {
                // empty if block
            }
            this.methodNames.put(methodName, method);
        }
    }

    public List getFinders() {
        return this.finders;
    }

    protected void setFinders(List finderList) {
        this.finders = finderList;
    }

    public List getSelectors() {
        return this.selectors;
    }

    protected void setSelectors(List selectorList) {
        this.selectors = selectorList;
    }

    public List getCreateMethods() {
        return this.createMethods;
    }

    public Map getMethodNames() {
        return this.methodNames;
    }

    public String getLocalHome() {
        return this.getDescriptor().getLocalHomeClassName();
    }

    public String getRemoteHome() {
        return this.getDescriptor().getHomeClassName();
    }

    protected QueryDescriptor getQueryDescriptor(Method method) {
        PersistenceDescriptor persistenceDescriptor = this.getDescriptor().getPersistenceDescriptor();
        return persistenceDescriptor.getQueryFor(method);
    }

    public String getQueryString(Method method) {
        QueryDescriptor queryDescriptor = this.getQueryDescriptor(method);
        return queryDescriptor != null ? queryDescriptor.getQuery() : null;
    }

    public int getQueryReturnType(Method method) {
        QueryDescriptor queryDescriptor = this.getQueryDescriptor(method);
        if (queryDescriptor != null) {
            if (queryDescriptor.getHasLocalReturnTypeMapping()) {
                return 0;
            }
            if (queryDescriptor.getHasRemoteReturnTypeMapping()) {
                return 1;
            }
        }
        return 2;
    }

    public abstract boolean isQueryPrefetchEnabled(Method var1);

    public abstract String getJDOFilterExpression(Method var1);

    public abstract String getJDOParameterDeclaration(Method var1);

    public abstract String getJDOVariableDeclaration(Method var1);

    public abstract String getJDOOrderingSpecification(Method var1);
}

