/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.util;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.forte4j.modules.dbmodel.ColumnPairElement;
import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.jdo.ConcurrencyGroupElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingReferenceKeyElement;
import com.sun.jdo.api.persistence.model.mapping.MappingRelationshipElement;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingClassElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingFieldElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingRelationshipElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingTableElementImpl;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class DumpMapping {
    public static Model model = Model.RUNTIME;

    public static void dumpMappingCache(PrintStream stream) {
        stream.println("Mapping cache (class names -> MappingClassElements)");
        Iterator i = model.getMappingCache().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String className = (String)entry.getKey();
            MappingClassElement mce = (MappingClassElement)entry.getValue();
            String mceRepr = mce.getClass() + "@" + Integer.toHexString(System.identityHashCode(mce));
            stream.println("\t" + className + " ->\t" + mceRepr);
        }
    }

    public static void dumpClassLoaderCache(PrintStream stream) {
        stream.println("ClassLoader cache (class names -> ClassLoaders)");
        Iterator i = model.getClassLoaderCache().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String className = (String)entry.getKey();
            ClassLoader classLoader = (ClassLoader)entry.getValue();
            stream.println("\t" + className + " ->\t" + classLoader);
        }
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String className = args[i];
            DumpMapping.println(0, "\nClass " + className + ":");
            try {
                MappingClassElementImpl mce = (MappingClassElementImpl)model.getMappingClass(className);
                if (mce != null) {
                    DumpMapping.printPersistenceClassElement(mce.getPersistenceElement());
                    DumpMapping.printMappingClassElement(mce);
                    continue;
                }
                DumpMapping.println(0, "Cannot find mapping info for class " + className + " (getMappingClass returns null)");
                continue;
            }
            catch (Exception e) {
                DumpMapping.println(0, "Problems during accessing mapping info for class " + className);
                e.printStackTrace();
            }
        }
    }

    public static void printPersistenceClassElement(PersistenceClassElement pce) {
        DumpMapping.println(0, "\n--> PersistenceClassElement ");
        DumpMapping.println(1, "package  = " + pce.getPackage());
        DumpMapping.println(1, "name     = " + pce.getName());
        DumpMapping.println(1, "identity = " + DumpMapping.getObjectIdentityTypeRepr(pce.getObjectIdentityType()));
        DumpMapping.println(1, "keyClass = " + pce.getKeyClass());
        DumpMapping.printPersistenceFieldElements(1, pce.getFields());
        DumpMapping.printConcurrencyGroupElements(1, pce.getConcurrencyGroups());
        DumpMapping.println(0, "<-- PersistenceClassElement\n ");
    }

    public static void printPersistenceFieldElements(int tabs, PersistenceFieldElement[] fields) {
        if (fields != null && fields.length > 0) {
            DumpMapping.println(tabs, "--> fields ");
            for (int i = 0; i < fields.length; ++i) {
                PersistenceFieldElement pfe = fields[i];
                DumpMapping.println(tabs, "[" + i + "] " + pfe.getClass());
                DumpMapping.println(tabs + 1, "name             = " + pfe.getName());
                DumpMapping.println(tabs + 1, "declaringClass   = " + pfe.getDeclaringClass());
                DumpMapping.println(tabs + 1, "fieldNumber      = " + pfe.getFieldNumber());
                DumpMapping.println(tabs + 1, "persistenceType  = " + DumpMapping.getPersistenceTypeRepr(pfe.getPersistenceType()));
                DumpMapping.println(tabs + 1, "read / write     = " + pfe.isReadSensitive() + " / " + pfe.isWriteSensitive());
                DumpMapping.println(tabs + 1, "isKey            = " + pfe.isKey());
                if (pfe instanceof RelationshipElement) {
                    RelationshipElement re = (RelationshipElement)pfe;
                    DumpMapping.println(tabs + 1, "bounds          = " + re.getLowerBound() + " / " + re.getUpperBound());
                    DumpMapping.println(tabs + 1, "deleteAction    = " + re.getDeleteAction());
                    DumpMapping.println(tabs + 1, "updateAction    = " + re.getUpdateAction());
                    DumpMapping.println(tabs + 1, "collectionClass = " + re.getCollectionClass());
                    DumpMapping.println(tabs + 1, "elementClass\t = " + re.getElementClass());
                    DumpMapping.println(tabs + 1, "isPrefetch      = " + re.isPrefetch());
                }
                DumpMapping.printConcurrencyGroupElements(tabs + 1, pfe.getConcurrencyGroups());
            }
            DumpMapping.println(tabs, "<-- fields ");
        }
    }

    public static void printConcurrencyGroupElements(int tabs, ConcurrencyGroupElement[] groups) {
        if (groups != null && groups.length > 0) {
            DumpMapping.println(tabs, "--> concurrency groups");
            for (int i = 0; i < groups.length; ++i) {
                ConcurrencyGroupElement cg = groups[i];
                DumpMapping.println(tabs, "[" + i + "] " + cg.getClass());
                DumpMapping.println(tabs + 1, "name           = " + cg.getName());
                DumpMapping.println(tabs + 1, "declaringClass = " + cg.getDeclaringClass());
                DumpMapping.println(tabs + 1, "fields         = " + cg.getFields());
            }
            DumpMapping.println(tabs, "<-- concurrency groups");
        }
    }

    public static void printMappingClassElement(MappingClassElement mce) {
        DumpMapping.println(0, "\n--> MappingClassElement");
        DumpMapping.println(1, "databaseRoot = " + mce.getDatabaseRoot());
        DumpMapping.printMappingTableElements(1, mce.getTables());
        DumpMapping.printMappingFieldElements(1, mce.getFields());
        DumpMapping.println(0, "<-- MappingClassElement");
    }

    public static void printMappingTableElements(int tabs, ArrayList tables) {
        int count;
        int n = count = tables != null ? tables.size() : 0;
        if (count > 0) {
            DumpMapping.println(tabs, "--> tables ");
            for (int i = 0; i < count; ++i) {
                MappingTableElementImpl mte = (MappingTableElementImpl)tables.get(i);
                DumpMapping.println(tabs, "[" + i + "] " + mte.getClass());
                DumpMapping.println(tabs + 1, "table           = " + mte.getTable());
                DumpMapping.println(tabs + 1, "tableObject     = " + mte.getTableObject());
                DumpMapping.println(tabs + 1, "key             = " + mte.getKey());
                DumpMapping.println(tabs + 1, "keyObjects      = " + mte.getKeyObjects());
                DumpMapping.printMappingRefKeyElements(tabs + 1, mte.getReferencingKeys());
            }
            DumpMapping.println(tabs, "<-- tables ");
        }
    }

    public static void printMappingRefKeyElements(int tabs, ArrayList refKeys) {
        int count;
        int n = count = refKeys != null ? refKeys.size() : 0;
        if (count > 0) {
            DumpMapping.println(tabs, "--> tables ");
            for (int i = 0; i < count; ++i) {
                MappingReferenceKeyElement mrke = (MappingReferenceKeyElement)refKeys.get(i);
                DumpMapping.println(tabs, "[" + i + "] " + mrke.getClass());
                DumpMapping.println(tabs + 1, "table           = " + mrke.getDeclaringTable());
                DumpMapping.println(tabs + 1, "pairs           = " + mrke.getColumnPairNames());
            }
            DumpMapping.println(tabs, "<-- tables ");
        }
    }

    public static void printMappingFieldElements(int tabs, ArrayList fields) {
        int count;
        int n = count = fields != null ? fields.size() : 0;
        if (count > 0) {
            DumpMapping.println(tabs, "--> fields ");
            for (int i = 0; i < count; ++i) {
                int colCount;
                MappingFieldElementImpl mfe = (MappingFieldElementImpl)fields.get(i);
                DumpMapping.println(tabs, "[" + i + "] " + mfe.getClass());
                DumpMapping.println(tabs + 1, "name            = " + mfe.getName());
                DumpMapping.println(tabs + 1, "fetchGroup      = " + mfe.getFetchGroup());
                DumpMapping.println(tabs + 1, "columns         = " + mfe.getColumns());
                if (!(mfe instanceof MappingRelationshipElement)) {
                    DumpMapping.println(tabs + 1, "columnObjects\t = " + mfe.getColumnObjects());
                    continue;
                }
                MappingRelationshipElementImpl mre = (MappingRelationshipElementImpl)mfe;
                ArrayList columnObjects = mre.getColumnObjects();
                int n2 = colCount = columnObjects != null ? columnObjects.size() : 0;
                if (colCount > 0) {
                    DumpMapping.println(tabs + 1, "--> columnsObjects ");
                    for (int j = 0; j < colCount; ++j) {
                        ColumnPairElement fce = (ColumnPairElement)columnObjects.get(j);
                        ColumnElement rce = fce != null ? fce.getReferencedColumn() : null;
                        DumpMapping.println(tabs + 1, "[" + j + "] " + fce + " -> " + rce);
                    }
                    DumpMapping.println(tabs + 1, "<-- columnsObjects ");
                }
                DumpMapping.println(tabs + 1, "associatedColumns = " + mre.getAssociatedColumns());
                ArrayList associatedColumnObjects = mre.getAssociatedColumnObjects();
                int n3 = colCount = associatedColumnObjects != null ? associatedColumnObjects.size() : 0;
                if (colCount <= 0) continue;
                DumpMapping.println(tabs + 1, "--> associatedColumnObjects ");
                for (int j = 0; j < colCount; ++j) {
                    ColumnPairElement fce = (ColumnPairElement)associatedColumnObjects.get(j);
                    ColumnElement rce = fce != null ? fce.getReferencedColumn() : null;
                    DumpMapping.println(tabs + 1, "[" + j + "] " + fce + " -> " + rce);
                }
                DumpMapping.println(tabs + 1, "<-- associatedColumnObjects ");
            }
            DumpMapping.println(tabs, "<-- fields ");
        }
    }

    static String getObjectIdentityTypeRepr(int objectIdentityType) {
        switch (objectIdentityType) {
            case 0: {
                return "APPLICATION_IDENTITY";
            }
            case 1: {
                return "DATABASE_IDENTITY_IDENTITY";
            }
            case 2: {
                return "UNMANAGED_IDENTITY";
            }
        }
        return "UNKNOWN";
    }

    static String getPersistenceTypeRepr(int persistenceType) {
        switch (persistenceType) {
            case 0: {
                return "PERSISTENT";
            }
            case 1: {
                return "DERIVED";
            }
            case 2: {
                return "TRANSIENT";
            }
        }
        return "UNKNOWN";
    }

    static void println(int indent, String text) {
        for (int i = 0; i < indent; ++i) {
            System.out.print("\t");
        }
        System.out.println(text);
    }
}

