/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte4j.modules.dbmodel.jdbcimpl.wizard;

import com.sun.forte4j.modules.dbmodel.jdbcimpl.wizard.DBSchemaWizardData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class DBSchemaConnectionPanel
extends JPanel
implements ListDataListener {
    static final long serialVersionUID = 5364628520334696421L;
    private ArrayList connInfos;
    private ArrayList list;
    private DBSchemaWizardData data;
    private Node dbNode;
    private String waitNode = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("WaitNode");
    private Node[] drvNodes;
    private Vector conList = new Vector();
    private JTextArea descriptionTextArea;
    private JComboBox existingConnComboBox;
    private JButton newConnectionButton;
    private final ResourceBundle bundle = NbBundle.getBundle((String)"com.sun.forte4j.modules.dbmodel.jdbcimpl.resources.Bundle");
    static /* synthetic */ Class class$org$netbeans$modules$db$explorer$infos$ConnectionNodeInfo;
    static /* synthetic */ Class class$org$netbeans$modules$db$explorer$actions$AddConnectionAction;

    public DBSchemaConnectionPanel(DBSchemaWizardData data, ArrayList list) {
        DataFolder df;
        this.list = list;
        this.connInfos = new ArrayList();
        this.data = data;
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(1));
        this.setName(this.bundle.getString("ConnectionChooser"));
        this.initComponents();
        this.resize();
        this.initAccessibility();
        FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("UI/Runtime");
        try {
            df = (DataFolder)DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException exc) {
            return;
        }
        this.dbNode = df.getNodeDelegate().getChildren().findChild("Databases");
        this.setConnectionCombo(this.getConnectionNodes());
        this.existingConnComboBox.setSelectedIndex(0);
        this.existingConnComboBox.getModel().addListDataListener(this);
    }

    private Node[] getConnectionNodes() {
        Node[] n = this.dbNode.getChildren().getNodes();
        while (n.length == 1 && this.waitNode.equals(n[0].getName())) {
            try {
                Thread.sleep(60L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            n = this.dbNode.getChildren().getNodes();
        }
        return n;
    }

    private void setConnectionCombo(Node[] n) {
        this.existingConnComboBox.removeAllItems();
        for (int i = 0; i < n.length; ++i) {
            Node.Cookie cookie = n[i].getCookie(class$org$netbeans$modules$db$explorer$infos$ConnectionNodeInfo == null ? DBSchemaConnectionPanel.class$("org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo") : class$org$netbeans$modules$db$explorer$infos$ConnectionNodeInfo);
            if (cookie == null) continue;
            ConnectionNodeInfo info = (ConnectionNodeInfo)cookie;
            this.existingConnComboBox.addItem(n[i].getDisplayName());
            this.conList.add(n[i].getDisplayName());
            this.connInfos.add(info);
        }
        if (this.existingConnComboBox.getItemCount() == 0) {
            this.existingConnComboBox.insertItemAt(this.bundle.getString("NoConnection"), 0);
        } else {
            this.existingConnComboBox.insertItemAt(this.bundle.getString("SelectFromTheList"), 0);
        }
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_ConnectionPanelA11yDesc"));
        this.descriptionTextArea.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_DescriptionA11yName"));
        this.descriptionTextArea.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_DescriptionA11yDesc"));
        this.existingConnComboBox.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_ExistingConnectionA11yName"));
        this.existingConnComboBox.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_ExistingConnectionA11yDesc"));
    }

    private void resize() {
        int width = new Double(this.descriptionTextArea.getFontMetrics(this.descriptionTextArea.getFont()).getStringBounds(this.bundle.getString("Description"), this.getGraphics()).getWidth() / 2.0).intValue() + 160;
        int height = 300;
        if (width < 675) {
            width = 675;
        }
        if (height < 390) {
            height = 390;
        }
        Dimension dim = new Dimension(width, height);
        this.setMinimumSize(dim);
        this.setPreferredSize(dim);
    }

    private void initComponents() {
        this.descriptionTextArea = new JTextArea();
        this.existingConnComboBox = new JComboBox();
        this.newConnectionButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setFont(UIManager.getFont("Label.font"));
        this.descriptionTextArea.setText(this.bundle.getString("Description"));
        this.descriptionTextArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.descriptionTextArea.setRequestFocusEnabled(false);
        this.descriptionTextArea.setEnabled(false);
        this.descriptionTextArea.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.descriptionTextArea, gridBagConstraints);
        this.existingConnComboBox.setToolTipText(this.bundle.getString("ACS_ExistingConnectionComboBoxA11yDesc"));
        this.existingConnComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DBSchemaConnectionPanel.this.existingConnComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 5);
        this.add((Component)this.existingConnComboBox, gridBagConstraints);
        this.newConnectionButton.setMnemonic(ResourceBundle.getBundle("com/sun/forte4j/modules/dbmodel/jdbcimpl/resources/Bundle").getString("NewConnectionButton_Mnemonic").charAt(0));
        this.newConnectionButton.setText(this.bundle.getString("NewConnectionButton"));
        this.newConnectionButton.setToolTipText(this.bundle.getString("ACS_NewConnectionButtonDesc"));
        this.newConnectionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DBSchemaConnectionPanel.this.newConnectionButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 5, 0, 11);
        this.add((Component)this.newConnectionButton, gridBagConstraints);
    }

    private void newConnectionButtonActionPerformed(ActionEvent evt) {
        Node[] n = this.getDriverNodes();
        DatabaseAction dbAction = (DatabaseAction)SystemAction.get((Class)(class$org$netbeans$modules$db$explorer$actions$AddConnectionAction == null ? (class$org$netbeans$modules$db$explorer$actions$AddConnectionAction = DBSchemaConnectionPanel.class$("org.netbeans.modules.db.explorer.actions.AddConnectionAction")) : class$org$netbeans$modules$db$explorer$actions$AddConnectionAction));
        dbAction.performAction(n);
        Vector oldConnections = (Vector)this.conList.clone();
        this.setConnectionCombo(this.getConnectionNodes());
        this.existingConnComboBox.setSelectedItem(this.getNewConObject(oldConnections));
    }

    private Object getNewConObject(Vector old) {
        Object ret = null;
        for (int i = 0; i < this.conList.size(); ++i) {
            if (old.contains(this.conList.elementAt(i))) continue;
            ret = this.conList.elementAt(i);
            break;
        }
        return ret;
    }

    private Node[] getDriverNodes() {
        if (this.drvNodes != null) {
            return this.drvNodes;
        }
        this.drvNodes = this.dbNode.getChildren().findChild("Drivers").getChildren().getNodes();
        while (this.drvNodes.length == 1 && this.waitNode.equals(this.drvNodes[0].getName())) {
            try {
                Thread.sleep(60L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.drvNodes = this.dbNode.getChildren().findChild("Drivers").getChildren().getNodes();
        }
        return this.drvNodes;
    }

    private void existingConnComboBoxActionPerformed(ActionEvent evt) {
        if (this.existingConnComboBox.getSelectedIndex() > 0) {
            this.data.setConnectionNodeInfo((ConnectionNodeInfo)this.connInfos.get(this.existingConnComboBox.getSelectedIndex() - 1));
        }
    }

    public boolean isValid() {
        return this.existingConnComboBox.getSelectedIndex() > 0;
    }

    public void intervalAdded(ListDataEvent p1) {
        this.fireChange(this);
    }

    public void intervalRemoved(ListDataEvent p1) {
        this.fireChange(this);
    }

    public void contentsChanged(ListDataEvent p1) {
        this.fireChange(this);
    }

    protected void initData() {
        this.data.setExistingConn(true);
        if (this.existingConnComboBox.getSelectedIndex() > 0) {
            this.data.setConnectionNodeInfo((ConnectionNodeInfo)this.connInfos.get(this.existingConnComboBox.getSelectedIndex() - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChange(Object source) {
        ArrayList lst;
        DBSchemaConnectionPanel dBSchemaConnectionPanel = this;
        synchronized (dBSchemaConnectionPanel) {
            lst = (ArrayList)this.list.clone();
        }
        ChangeEvent event = new ChangeEvent(source);
        for (int i = 0; i < lst.size(); ++i) {
            ChangeListener listener = (ChangeListener)lst.get(i);
            listener.stateChanged(event);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

