/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte4j.modules.dbmodel;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.forte4j.modules.dbmodel.ColumnPairElement;
import com.sun.forte4j.modules.dbmodel.ColumnPairElementHolder;
import com.sun.forte4j.modules.dbmodel.DBException;
import com.sun.forte4j.modules.dbmodel.DBIdentifier;
import com.sun.forte4j.modules.dbmodel.DBMemoryCollection;
import com.sun.forte4j.modules.dbmodel.KeyElement;
import com.sun.forte4j.modules.dbmodel.ReferenceKey;
import com.sun.forte4j.modules.dbmodel.TableElement;

public final class ForeignKeyElement
extends KeyElement
implements ReferenceKey,
ColumnPairElementHolder {
    public ForeignKeyElement() {
        this(new Memory(), null);
    }

    public ForeignKeyElement(Impl impl, TableElement declaringTable) {
        super(impl, declaringTable);
    }

    final Impl getForeignKeyImpl() {
        return (Impl)this.getElementImpl();
    }

    public TableElement getReferencedTable() {
        ColumnPairElement[] columnPairs = this.getColumnPairs();
        if (columnPairs != null && columnPairs.length > 0) {
            return columnPairs[0].getReferencedColumn().getDeclaringTable();
        }
        return null;
    }

    public ColumnElement[] getReferencedColumns() {
        ColumnPairElement[] columnPairs = this.getColumnPairs();
        int count = columnPairs != null ? columnPairs.length : 0;
        ColumnElement[] ce = new ColumnElement[count];
        for (int i = 0; i < count; ++i) {
            ce[i] = columnPairs[i].getReferencedColumn();
        }
        return ce;
    }

    public String getKeyName() {
        return this.getName().getFullName();
    }

    public void setKeyName(String name) throws DBException {
        this.setName(DBIdentifier.create(name));
    }

    public void addColumnPair(ColumnPairElement pair) throws DBException {
        this.addColumnPairs(new ColumnPairElement[]{pair});
    }

    public void addColumnPairs(ColumnPairElement[] pairs) throws DBException {
        this.getForeignKeyImpl().changeColumnPairs(pairs, 1);
    }

    public void removeColumnPair(ColumnPairElement pair) throws DBException {
        this.removeColumnPairs(new ColumnPairElement[]{pair});
    }

    public void removeColumnPairs(ColumnPairElement[] pairs) throws DBException {
        this.getForeignKeyImpl().changeColumnPairs(pairs, -1);
    }

    public void setColumnPairs(ColumnPairElement[] pairs) throws DBException {
        this.getForeignKeyImpl().changeColumnPairs(pairs, 0);
    }

    public ColumnPairElement[] getColumnPairs() {
        return this.getForeignKeyImpl().getColumnPairs();
    }

    public ColumnPairElement getColumnPair(DBIdentifier name) {
        return this.getForeignKeyImpl().getColumnPair(name);
    }

    public ColumnElement[] getLocalColumns() {
        return this.getForeignKeyImpl().getColumns();
    }

    public void addColumn(ColumnElement el) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void addColumns(ColumnElement[] els) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeColumn(ColumnElement el) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeColumns(ColumnElement[] els) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setColumns(ColumnElement[] els) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public ColumnElement[] getColumns() {
        return this.getForeignKeyImpl().getColumns();
    }

    public ColumnElement getColumn(DBIdentifier name) {
        return this.getForeignKeyImpl().getColumn(name);
    }

    static class Memory
    extends KeyElement.Memory
    implements Impl {
        private DBMemoryCollection.ColumnPair pairs;

        Memory() {
        }

        Memory(ForeignKeyElement fk) {
            super(fk);
        }

        public synchronized ColumnPairElement[] getColumnPairs() {
            this.initColumnPairs();
            return (ColumnPairElement[])this.pairs.getElements();
        }

        public synchronized ColumnPairElement getColumnPair(DBIdentifier name) {
            this.initColumnPairs();
            return (ColumnPairElement)this.pairs.getElement(name);
        }

        public synchronized void changeColumnPairs(ColumnPairElement[] pairs, int action) throws DBException {
            this.initColumnPairs();
            this.pairs.change(pairs, action);
        }

        void initColumnPairs() {
            if (this.pairs == null) {
                this.pairs = new DBMemoryCollection.ColumnPair(this);
            }
        }
    }

    public static interface Impl
    extends KeyElement.Impl {
        public void changeColumnPairs(ColumnPairElement[] var1, int var2) throws DBException;

        public ColumnPairElement[] getColumnPairs();

        public ColumnPairElement getColumnPair(DBIdentifier var1);
    }
}

