/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.util;

import com.sun.xml.rpc.util.Version;
import java.util.StringTokenizer;

public final class VersionUtil
implements Version {
    public static final String JAXRPC_VERSION_101 = "1.0.1";
    public static final String JAXRPC_VERSION_103 = "1.0.3";
    public static final String JAXRPC_VERSION_11 = "1.1";
    public static final String JAXRPC_VERSION_111 = "1.1.1";
    public static final String JAXRPC_VERSION_112 = "1.1.2";
    public static final String JAXRPC_VERSION_112_01 = "1.1.2_01";
    public static final String JAXRPC_VERSION_112_02 = "1.1.2_02";
    public static final String JAXRPC_VERSION_112_03 = "1.1.2_03";
    public static final String JAXRPC_VERSION_112_04 = "1.1.2_04";
    public static final String JAXRPC_VERSION_DEFAULT = "1.1.2";

    public static boolean isJavaVersionGreaterThan1_3() {
        try {
            Class.forName("java.net.URI");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isJavaVersionGreaterThan1_4() {
        try {
            Class.forName("java.util.UUID");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static String getJAXRPCCompleteVersion() {
        return "JAX-RPC Standard Implementation1.1.2_04R45";
    }

    public static String getJAXRPCVersion() {
        return JAXRPC_VERSION_112_04;
    }

    public static String getJAXRPCBuildNumber() {
        return "R45";
    }

    public static String getJAXRPCProductName() {
        return "JAX-RPC Standard Implementation";
    }

    public static boolean isVersion101(String version) {
        return JAXRPC_VERSION_101.equals(version);
    }

    public static boolean isVersion103(String version) {
        return JAXRPC_VERSION_103.equals(version);
    }

    public static boolean isVersion11(String version) {
        return JAXRPC_VERSION_11.equals(version);
    }

    public static boolean isVersion111(String version) {
        return JAXRPC_VERSION_111.equals(version);
    }

    public static boolean isVersion112(String version) {
        return "1.1.2".equals(version) || JAXRPC_VERSION_112_01.equals(version) || JAXRPC_VERSION_112_02.equals(version) || JAXRPC_VERSION_112_03.equals(version) || JAXRPC_VERSION_112_04.equals(version);
    }

    public static boolean isValidVersion(String version) {
        return VersionUtil.isVersion101(version) || VersionUtil.isVersion103(version) || VersionUtil.isVersion11(version) || VersionUtil.isVersion111(version) || VersionUtil.isVersion112(version);
    }

    public static int[] getCanonicalVersion(String version) {
        StringTokenizer subTokenizer;
        int[] canonicalVersion = new int[]{1, 1, 0, 0};
        String DASH_DELIM = "_";
        String DOT_DELIM = ".";
        StringTokenizer tokenizer = new StringTokenizer(version, ".");
        String token = tokenizer.nextToken();
        canonicalVersion[0] = Integer.parseInt(token);
        token = tokenizer.nextToken();
        if (token.indexOf("_") == -1) {
            canonicalVersion[1] = Integer.parseInt(token);
        } else {
            subTokenizer = new StringTokenizer(token, "_");
            canonicalVersion[1] = Integer.parseInt(subTokenizer.nextToken());
            canonicalVersion[3] = Integer.parseInt(subTokenizer.nextToken());
        }
        if (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (token.indexOf("_") == -1) {
                canonicalVersion[2] = Integer.parseInt(token);
                if (tokenizer.hasMoreTokens()) {
                    canonicalVersion[3] = Integer.parseInt(tokenizer.nextToken());
                }
            } else {
                subTokenizer = new StringTokenizer(token, "_");
                canonicalVersion[2] = Integer.parseInt(subTokenizer.nextToken());
                canonicalVersion[3] = Integer.parseInt(subTokenizer.nextToken());
            }
        }
        return canonicalVersion;
    }

    public static int compare(String version1, String version2) {
        int[] canonicalVersion2;
        int[] canonicalVersion1 = VersionUtil.getCanonicalVersion(version1);
        if (canonicalVersion1[0] < (canonicalVersion2 = VersionUtil.getCanonicalVersion(version2))[0]) {
            return -1;
        }
        if (canonicalVersion1[0] > canonicalVersion2[0]) {
            return 1;
        }
        if (canonicalVersion1[1] < canonicalVersion2[1]) {
            return -1;
        }
        if (canonicalVersion1[1] > canonicalVersion2[1]) {
            return 1;
        }
        if (canonicalVersion1[2] < canonicalVersion2[2]) {
            return -1;
        }
        if (canonicalVersion1[2] > canonicalVersion2[2]) {
            return 1;
        }
        if (canonicalVersion1[3] < canonicalVersion2[3]) {
            return -1;
        }
        if (canonicalVersion1[3] > canonicalVersion2[3]) {
            return 1;
        }
        return 0;
    }
}

