/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind;

import com.sun.msv.datatype.xsd.Base64BinaryType;
import com.sun.msv.datatype.xsd.BooleanType;
import com.sun.msv.datatype.xsd.ByteType;
import com.sun.msv.datatype.xsd.DateTimeType;
import com.sun.msv.datatype.xsd.DateType;
import com.sun.msv.datatype.xsd.DoubleType;
import com.sun.msv.datatype.xsd.FloatType;
import com.sun.msv.datatype.xsd.HexBinaryType;
import com.sun.msv.datatype.xsd.IntType;
import com.sun.msv.datatype.xsd.IntegerType;
import com.sun.msv.datatype.xsd.LongType;
import com.sun.msv.datatype.xsd.NumberType;
import com.sun.msv.datatype.xsd.ShortType;
import com.sun.msv.datatype.xsd.SimpleURType;
import com.sun.msv.datatype.xsd.TimeType;
import com.sun.msv.datatype.xsd.UnsignedIntType;
import com.sun.msv.datatype.xsd.UnsignedShortType;
import com.sun.msv.datatype.xsd.XmlNames;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class DatatypeConverterImpl
implements DatatypeConverterInterface {
    public static final DatatypeConverterInterface theInstance = new DatatypeConverterImpl();

    protected DatatypeConverterImpl() {
    }

    public String printByte(byte val) {
        return ByteType.save((Byte)new Byte(val));
    }

    public String printDouble(double val) {
        return DoubleType.save((Double)new Double(val));
    }

    public String printFloat(float val) {
        return FloatType.save((Float)new Float(val));
    }

    public String printInt(int val) {
        return IntType.save((Integer)new Integer(val));
    }

    public String printUnsignedShort(int val) {
        return UnsignedShortType.save((Integer)new Integer(val));
    }

    public String printLong(long val) {
        return LongType.save((Long)new Long(val));
    }

    public String printUnsignedInt(long val) {
        return UnsignedIntType.save((Long)new Long(val));
    }

    public byte parseByte(String lexicalXSDByte) {
        return ByteType.load((String)lexicalXSDByte);
    }

    public double parseDouble(String lexicalXSDDouble) {
        return DoubleType.load((String)lexicalXSDDouble);
    }

    public float parseFloat(String lexicalXSDFloat) {
        return FloatType.load((String)lexicalXSDFloat).floatValue();
    }

    public int parseInt(String lexicalXSDInt) {
        return IntType.load((String)lexicalXSDInt);
    }

    public int parseUnsignedShort(String lexicalXSDUnsignedShort) {
        return UnsignedShortType.load((String)lexicalXSDUnsignedShort).shortValue();
    }

    public long parseLong(String lexicalXSLong) {
        return LongType.load((String)lexicalXSLong);
    }

    public long parseUnsignedInt(String lexicalXSDUnsignedInt) {
        return UnsignedIntType.load((String)lexicalXSDUnsignedInt);
    }

    public short parseShort(String lexicalXSDShort) {
        return ShortType.load((String)lexicalXSDShort);
    }

    public boolean parseBoolean(String lexicalXSDBoolean) {
        return BooleanType.load((String)lexicalXSDBoolean);
    }

    public byte[] parseBase64Binary(String lexicalXSDBase64Binary) {
        return Base64BinaryType.load((String)lexicalXSDBase64Binary);
    }

    public byte[] parseHexBinary(String lexicalXSDHexBinary) {
        return HexBinaryType.load((String)lexicalXSDHexBinary);
    }

    public String printShort(short val) {
        return ShortType.save((Short)new Short(val));
    }

    public String printBoolean(boolean val) {
        return BooleanType.save((Boolean)new Boolean(val));
    }

    public String printBase64Binary(byte[] val) {
        return Base64BinaryType.save((byte[])val);
    }

    public String printHexBinary(byte[] val) {
        return HexBinaryType.save((byte[])val);
    }

    public static String installHook(String s) {
        DatatypeConverter.setDatatypeConverter(theInstance);
        return s;
    }

    public String parseAnySimpleType(String lexicalXSDAnySimpleType) {
        return lexicalXSDAnySimpleType;
    }

    public String parseString(String lexicalXSDString) {
        return lexicalXSDString;
    }

    public String printAnySimpleType(String val) {
        return SimpleURType.theInstance.convertToLexicalValue((Object)val, null);
    }

    public String printString(String val) {
        return val;
    }

    public String printDecimal(BigDecimal val) {
        return NumberType.save((Object)val);
    }

    public String printInteger(BigInteger val) {
        return IntegerType.save((BigInteger)val);
    }

    public String printDate(Calendar val) {
        return DateType.theInstance.serializeJavaObject((Object)val, null);
    }

    public String printDateTime(Calendar val) {
        return DateTimeType.theInstance.serializeJavaObject((Object)val, null);
    }

    public String printTime(Calendar val) {
        return TimeType.theInstance.serializeJavaObject((Object)val, null);
    }

    public BigDecimal parseDecimal(String content) {
        if (content.charAt(0) == '+') {
            content = content.substring(1);
        }
        return new BigDecimal(content);
    }

    public BigInteger parseInteger(String lexicalXSDInteger) {
        return IntegerType.load((String)lexicalXSDInteger);
    }

    public Calendar parseDate(String lexicalXSDDate) {
        return (Calendar)DateType.theInstance.createJavaObject(lexicalXSDDate, null);
    }

    public Calendar parseDateTime(String lexicalXSDDateTime) {
        return (Calendar)DateTimeType.theInstance.createJavaObject(lexicalXSDDateTime, null);
    }

    public Calendar parseTime(String lexicalXSDTime) {
        return (Calendar)TimeType.theInstance.createJavaObject(lexicalXSDTime, null);
    }

    private String resolveNamespacePrefix(String prefix, NamespaceContext nsc) {
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        return nsc.getNamespaceURI(prefix);
    }

    public String printQName(QName val, NamespaceContext nsc) {
        String qname = null;
        String prefix = nsc.getPrefix(val.getNamespaceURI());
        String localPart = val.getLocalPart();
        qname = prefix == null || prefix.length() == 0 ? localPart : prefix + ":" + localPart;
        return qname;
    }

    public QName parseQName(String lexicalXSDQName, NamespaceContext nsc) {
        String prefix;
        String uri = null;
        String localPart = null;
        int first = lexicalXSDQName.indexOf(58);
        if (first <= 0) {
            uri = this.resolveNamespacePrefix("", nsc);
            localPart = lexicalXSDQName;
            prefix = "";
        } else {
            prefix = lexicalXSDQName.substring(0, first);
            localPart = lexicalXSDQName.substring(first + 1);
            uri = this.resolveNamespacePrefix(prefix, nsc);
        }
        if (uri == null) {
            return null;
        }
        if (!XmlNames.isUnqualifiedName((String)localPart)) {
            return null;
        }
        return new QName(uri, localPart, prefix);
    }
}

