/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.dv.xs;

import com.sun.org.apache.xerces.internal.impl.dv.InvalidDatatypeValueException;
import com.sun.org.apache.xerces.internal.impl.dv.ValidationContext;
import com.sun.org.apache.xerces.internal.impl.dv.xs.TypeValidator;

public class DoubleDV
extends TypeValidator {
    public short getAllowedFacets() {
        return 2552;
    }

    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        try {
            return new XDouble(content);
        }
        catch (NumberFormatException ex) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "double"});
        }
    }

    public int compare(Object value1, Object value2) {
        return ((XDouble)value1).compareTo((XDouble)value2);
    }

    private static final class XDouble {
        private double value;
        private String canonical;

        public XDouble(String s) throws NumberFormatException {
            try {
                this.value = Double.parseDouble(s);
            }
            catch (NumberFormatException nfe) {
                if (s.equals("INF")) {
                    this.value = Double.POSITIVE_INFINITY;
                }
                if (s.equals("-INF")) {
                    this.value = Double.NEGATIVE_INFINITY;
                }
                if (s.equals("NaN")) {
                    this.value = Double.NaN;
                }
                throw nfe;
            }
        }

        public boolean equals(Object val) {
            if (val == this) {
                return true;
            }
            if (!(val instanceof XDouble)) {
                return false;
            }
            XDouble oval = (XDouble)val;
            if (this.value == oval.value) {
                return true;
            }
            return this.value != this.value && oval.value != oval.value;
        }

        private int compareTo(XDouble val) {
            double oval = val.value;
            if (this.value < oval) {
                return -1;
            }
            if (this.value > oval) {
                return 1;
            }
            if (this.value == oval) {
                return 0;
            }
            if (this.value != this.value) {
                if (oval != oval) {
                    return 0;
                }
                return 2;
            }
            return 2;
        }

        public synchronized String toString() {
            if (this.canonical == null) {
                if (this.value == Double.POSITIVE_INFINITY) {
                    this.canonical = "INF";
                } else if (this.value == Double.NEGATIVE_INFINITY) {
                    this.canonical = "-INF";
                } else if (this.value != this.value) {
                    this.canonical = "NaN";
                } else if (this.value == 0.0) {
                    this.canonical = "0.0E1";
                } else {
                    this.canonical = Double.toString(this.value);
                    if (this.canonical.indexOf(69) == -1) {
                        int edp;
                        int len = this.canonical.length();
                        char[] chars = new char[len + 3];
                        this.canonical.getChars(0, len, chars, 0);
                        int n = edp = chars[0] == '-' ? 2 : 1;
                        if (this.value >= 1.0 || this.value <= -1.0) {
                            int dp;
                            for (int i = dp = this.canonical.indexOf(46); i > edp; --i) {
                                chars[i] = chars[i - 1];
                            }
                            chars[edp] = 46;
                            while (chars[len - 1] == '0') {
                                --len;
                            }
                            if (chars[len - 1] == '.') {
                                // empty if block
                            }
                            int n2 = ++len;
                            chars[n2] = 69;
                            int shift = dp - edp;
                            int n3 = ++len;
                            ++len;
                            chars[n3] = (char)(shift + 48);
                        } else {
                            int nzp = edp + 1;
                            while (chars[nzp] == '0') {
                                ++nzp;
                            }
                            chars[edp - 1] = chars[nzp];
                            chars[edp] = 46;
                            int i = nzp + 1;
                            int j = edp + 1;
                            while (i < len) {
                                chars[j] = chars[i];
                                ++i;
                                ++j;
                            }
                            if ((len -= nzp - edp) == edp + 1) {
                                chars[len++] = 48;
                            }
                            chars[len++] = 69;
                            chars[len++] = 45;
                            int shift = nzp - edp;
                            chars[len++] = (char)(shift + 48);
                        }
                        this.canonical = new String(chars, 0, len);
                    }
                }
            }
            return this.canonical;
        }
    }
}

