/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.beans.Introspector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.schema2beans.AttrProp;
import org.netbeans.modules.schema2beans.BeanBuilder;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.DataEnumRestriction;
import org.netbeans.modules.schema2beans.DataListRestriction;
import org.netbeans.modules.schema2beans.DataTypeRestriction;
import org.netbeans.modules.schema2beans.GenBeans;
import org.netbeans.modules.schema2beans.GraphLink;
import org.netbeans.modules.schema2beans.GraphNode;
import org.netbeans.modules.schema2beans.SchemaRep;
import org.netbeans.modules.schema2beans.TreeBuilder;
import org.netbeans.modules.schema2beans.gen.JavaUtil;
import org.netbeans.modules.schema2beans.gen.JavaWriter;
import org.netbeans.modules.schema2beans.metadd.MetaDD;
import org.netbeans.modules.schema2beans.metadd.MetaElement;
import org.netbeans.modules.schema2beans.metadd.MetaProperty;

public abstract class AbstractCodeGeneratorClass {
    protected GenBeans.Config config;
    protected String packageName;
    protected String className;
    protected String fullClassName;
    protected BeanBuilder.BeanElement beanElement;
    protected BeanBuilder.BeanElement rootBeanElement;
    private String defaultNamespace = null;
    protected MetaDD mdd;
    protected MetaElement metaElement;
    protected ArrayList attrList;
    protected int HEADER_SECTION = 0;
    protected int DECL_SECTION = 1;
    protected int CONSTRUCTOR_SECTION = 2;
    protected int INITIALIZE_SECTION = 3;
    protected int ACCESS_SECTION = 4;
    protected int BODY_SECTION = 5;
    protected int EQUALS_SECTION = 6;
    protected int HASHCODE_SECTION = 7;
    protected int TRAILER_SECTION = 8;
    protected int MAXVALUE = 8;
    JavaWriter jw;
    protected static final int PUBLIC = 0;
    protected static final int PRIVATE = 1;
    protected static final int VOID = 2;
    protected static final int CLASS = 3;
    protected static final int IMPORT = 4;
    protected static final int PACKAGE = 5;
    protected static final int STRING = 6;
    protected static final int BOOLEAN = 7;
    protected static final int STATIC = 8;
    protected static final int FINAL = 9;
    protected static final int INT = 10;
    protected static final int PROTECTED = 11;
    protected static String[] arrKeywords = new String[]{"public", "private", "void", "class", "import", "package", "String", "boolean", "static", "final", "int", "protected"};
    private String cachedRootClassName = null;
    protected static final Signature.TypeOfMethod SETTER = Signature.TypeOfMethod.SETTER;
    protected static final Signature.TypeOfMethod SETTERINDEXED = Signature.TypeOfMethod.SETTERINDEXED;
    protected static final Signature.TypeOfMethod GETTER = Signature.TypeOfMethod.GETTER;
    protected static final Signature.TypeOfMethod GETTERLIST = Signature.TypeOfMethod.GETTERLIST;
    protected static final Signature.TypeOfMethod GETTERINDEXED = Signature.TypeOfMethod.GETTERINDEXED;
    protected static final Signature.TypeOfMethod SIZE = Signature.TypeOfMethod.SIZE;
    protected static final Signature.TypeOfMethod ADD = Signature.TypeOfMethod.ADD;
    protected static final Signature.TypeOfMethod REMOVE = Signature.TypeOfMethod.REMOVE;
    protected static final Signature.TypeOfMethod OTHER = Signature.TypeOfMethod.OTHER;

    protected void init(BeanBuilder.BeanElement be, GenBeans.Config config) {
        this.config = config;
        this.beanElement = be;
        this.packageName = null;
        this.fullClassName = this.className = be.getClassType();
        this.attrList = new ArrayList();
        this.jw = new JavaWriter();
        this.HEADER_SECTION = this.jw.HEADER_SECTION;
        this.DECL_SECTION = this.jw.DECL_SECTION;
        this.CONSTRUCTOR_SECTION = this.jw.CONSTRUCTOR_SECTION;
        this.INITIALIZE_SECTION = this.jw.insertSectionAfter(this.jw.CONSTRUCTOR_SECTION);
        this.ACCESS_SECTION = this.jw.insertSectionAfter(this.INITIALIZE_SECTION);
        this.BODY_SECTION = this.jw.BODY_SECTION;
        this.EQUALS_SECTION = this.jw.insertSectionAfter(this.BODY_SECTION);
        this.HASHCODE_SECTION = this.jw.insertSectionAfter(this.EQUALS_SECTION);
        this.resetGenBuffers();
    }

    protected void resetGenBuffers() {
        this.jw.reset();
        this.jw.select(this.HEADER_SECTION);
    }

    protected void printGenBuffers(OutputStream out) throws IOException {
        this.jw.writeTo(out);
    }

    public void setPackageName(String n) {
        if (n == null || "".equals(n)) {
            this.packageName = null;
            this.fullClassName = this.className;
        } else {
            this.packageName = n.replace('/', '.');
            this.fullClassName = this.packageName + "." + this.className;
        }
    }

    public void setDefaultNamespace(String ns) {
        this.defaultNamespace = ns;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    protected String getBeanFullClassName(Property a, String typeName) {
        if (a.isBean && a.getGraphNode().isCreated() && this.packageName != null) {
            return this.packageName + "." + typeName;
        }
        return typeName;
    }

    public void setIndent(String indent) {
        this.jw.setIndent(indent);
    }

    public void setRootBeanElement(BeanBuilder.BeanElement element) {
        this.rootBeanElement = element;
    }

    protected String getRootClassName() {
        if (this.cachedRootClassName == null) {
            String rootClassName = this.rootBeanElement.getClassType();
            this.cachedRootClassName = this.packageName == null ? rootClassName : this.packageName + "." + rootClassName;
        }
        return this.cachedRootClassName;
    }

    protected void select(int o) {
        this.jw.select(o);
    }

    protected void gen(String s) {
        try {
            this.jw.write(s);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void gen(StringBuffer s) {
        try {
            this.jw.write(s);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void gen(String s1, String s2) {
        this.gen(s1);
        this.gen(s2);
    }

    protected void gen(String s1, String s2, String s3) {
        this.gen(s1);
        this.gen(s2);
        this.gen(s3);
    }

    protected void gen(int a) {
        this.gen(arrKeywords[a]);
    }

    protected void gen(int a, String s) {
        this.gen(a);
        this.sp();
        this.gen(s);
    }

    protected void gen(int a, String s, String s2) {
        this.gen(a, s);
        this.sp();
        this.gen(s2);
    }

    protected void gen(int a, int b, String s, String s2) {
        this.gen(a, b, s);
        this.gen(s2);
    }

    protected void gen(int a, int b, String s) {
        this.gen(a);
        this.sp();
        this.gen(b);
        this.sp();
        this.gen(s);
    }

    protected void gen(int a, int b, int c, String s) {
        this.gen(a);
        this.sp();
        this.gen(b);
        this.sp();
        this.gen(c);
        this.sp();
        this.gen(s);
    }

    protected void gen(int a, int b, int c, int d, String s) {
        this.gen(a);
        this.sp();
        this.gen(b);
        this.sp();
        this.gen(c);
        this.sp();
        this.gen(d);
        this.sp();
        this.gen(s);
    }

    protected void gencr(String s) {
        this.gen(s);
        this.cr();
    }

    protected void gencr(String s, String s2) {
        this.gen(s, s2);
        this.cr();
    }

    protected void gencr(int a, String s) {
        this.gen(a, s);
        this.cr();
    }

    protected void gencr(int a, String s, String s2) {
        this.gen(a, s, s2);
        this.cr();
    }

    protected void gencr(int a, int b, String s, String s2) {
        this.gen(a, b, s, s2);
        this.cr();
    }

    protected void gencr(int a, int b, String s) {
        this.gen(a, b, s);
        this.cr();
    }

    protected void gencr(int a, int b, int c, String s) {
        this.gen(a, b, c, s);
        this.cr();
    }

    protected void get(String s) {
        this.gen(" get");
        this.gen(s);
        this.PO();
        this.PC();
    }

    protected void geti(String s) {
        this.gen(" get");
        this.gen(s, "(int index)");
    }

    protected void getidx(String s, boolean b) {
        if (b) {
            this.geti(s);
        } else {
            this.get(s);
        }
    }

    protected void cr() {
        try {
            this.jw.cr();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void geneol(String s) {
        this.gen(s);
        this.eol();
    }

    protected void PO() {
        this.gen("(");
    }

    protected void PC() {
        this.gen(")");
    }

    protected void begin() {
        try {
            this.jw.begin();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void end() {
        this.end(true);
    }

    protected void end(boolean cr) {
        try {
            this.jw.end(cr);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void comment() {
        this.gencr("//");
    }

    protected void gencrNoI18N(String s) {
        this.gen(s);
        this.noI18N();
    }

    protected void gencrNoI18N(String s, String s2) {
        this.gen(s);
        this.gen(s2);
        this.noI18N();
    }

    protected void beginNoI18N() {
        this.gencr("// BEGIN_NOI18N");
    }

    protected void endNoI18N() {
        this.gencr("// END_NOI18N");
    }

    protected void noI18N() {
        try {
            this.jw.noI18N();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void comment(String s) {
        try {
            this.jw.comment(s);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void comment(String s, String s2) {
        this.comment(s + s2);
    }

    protected void eol() {
        try {
            this.jw.eol();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void eol(boolean cr) {
        this.gen(";");
        if (cr) {
            this.cr();
        }
    }

    protected void eolNoI18N() {
        try {
            this.jw.eolNoI18N();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void sp() {
        this.gen(" ");
    }

    protected void genforprop() {
        this.gencr("for (int i=0; i<this.prop.length; i++)");
    }

    protected void gengetprop() {
        this.gencr("BeanProp p = this.beanProp();");
        this.gencr("if (p != null)");
    }

    protected void gengetpropbyname() {
        this.gencr("BeanProp p = this.beanProp(n);");
        this.gencr("if (p != null)");
    }

    protected void gensig1(String s) {
        this.gen("(", s, " l)");
        this.cr();
    }

    protected void gensig2(String s) {
        this.gen("(String n, ", s, " l)");
        this.cr();
    }

    protected void tabIn() {
        this.jw.indentOneLevel();
    }

    protected void gentab(int n) {
        int i = 0;
        while (i < n) {
            this.tabIn();
            ++i;
        }
    }

    protected void genSetValue(boolean isScalar, String classType) {
        this.gen(JavaUtil.toObject("value", classType));
        this.gen(")");
    }

    protected void genSetValP(boolean b, String s1, String s2) {
        if (b) {
            this.gen(s1);
        } else {
            this.gen(s2);
        }
        this.gen(" value");
    }

    public Property addProperty(String name, String dtdName, GraphNode node, GraphLink l, String classType, int nestedLevel, int eltInstance, int groupInstance, int type, boolean ored, AttrProp[] propAttributes, String constName, String defaultValue, boolean directChild, List extraData) {
        if (this.config.getTraceGen()) {
            System.out.println("AbstractCodeGen.addProperty: name=" + name + " dtdName=" + dtdName + " classType=" + classType + " type=" + type);
        }
        Property attr = new Property(name, dtdName, node, l, classType, eltInstance, groupInstance, nestedLevel, type, ored, propAttributes, constName, defaultValue, directChild, extraData);
        this.attrList.add(attr);
        return attr;
    }

    public void generate(String filename, MetaDD mdd) throws IOException {
        this.mdd = mdd;
        this.config = this.config;
        if (this.className == null) {
            throw new NullPointerException();
        }
        this.metaElement = this.getMetaElementBeanName(this.className);
        if (this.metaElement != null && this.metaElement.isSkipGeneration()) {
            this.config.messageOut.println("Skipping generation of class " + filename + " (as specified in the mdd file)");
            return;
        }
        this.config.messageOut.println("Generating class " + filename);
        FileOutputStream out = new FileOutputStream(filename);
        this.generate(out, mdd);
        ((OutputStream)out).close();
    }

    public abstract void generate(OutputStream var1, MetaDD var2) throws IOException;

    private MetaElement getMetaElement(String dtdName) {
        MetaElement ret = null;
        if (this.mdd != null) {
            int size = this.mdd.sizeMetaElement();
            int i = 0;
            while (i < size) {
                MetaElement e = this.mdd.getMetaElement(i);
                if (e != null && dtdName.equals(e.getDtdName())) {
                    ret = e;
                    break;
                }
                ++i;
            }
        }
        return ret;
    }

    protected MetaElement getMetaElementBeanName(String beanName) {
        MetaElement ret = null;
        if (this.mdd != null) {
            int size = this.mdd.sizeMetaElement();
            int i = 0;
            while (i < size) {
                MetaElement e = this.mdd.getMetaElement(i);
                if (e != null) {
                    String name = e.getBeanName();
                    if (name == null) {
                        name = Common.convertName(e.getDtdName());
                    }
                    if (beanName.equals(name)) {
                        ret = e;
                        break;
                    }
                }
                ++i;
            }
        }
        return ret;
    }

    protected MetaProperty getMetaProperty(String name) {
        MetaProperty ret = null;
        if (this.metaElement != null) {
            MetaProperty[] mp = this.metaElement.getMetaProperty();
            int i = 0;
            while (i < mp.length) {
                if (mp[i] != null && mp[i].getBeanName().equals(name)) {
                    ret = mp[i];
                    break;
                }
                ++i;
            }
        }
        return ret;
    }

    protected void printSchema() throws IOException {
        if (this.config.filename == null) {
            return;
        }
        File f = new File(this.config.filename);
        if (f.length() < 32000L) {
            FileInputStream fi = new FileInputStream(f);
            byte[] r = new byte[(int)f.length()];
            fi.read(r);
            this.cr();
            this.gencr("/*");
            this.gentab(2);
            this.gencr("The following schema file has been used for generation:");
            this.cr();
            this.gen(new String(r));
            fi.close();
            this.cr();
            this.gencr("*/");
        }
    }

    protected void printComment(String indent) throws IOException {
        if (this.beanElement.node.getExtendedProperty("comment") == null) {
            return;
        }
        this.gen(indent);
        this.gencr("===============================================================");
        this.gen(indent);
        String comment = (String)this.beanElement.node.getExtendedProperty("comment");
        int i = 0;
        while (i < comment.length()) {
            char c = comment.charAt(i);
            if (c == '\n') {
                this.cr();
                this.gen(indent);
            } else if (c == '*' && i + 1 < comment.length() && comment.charAt(i + 1) == '/') {
                this.jw.write("* /");
                ++i;
            } else {
                this.jw.write(c);
            }
            ++i;
        }
        this.cr();
        this.gen(indent);
        this.gencr("===============================================================");
    }

    public void dumpBeanTree(Writer out, String indent, String indentBy) throws IOException {
        out.write(indent);
        out.write(this.beanElement.node.getName());
        out.write(" : ");
        out.write(this.className);
        out.write("\n");
        StringBuffer str = new StringBuffer();
        this.dumpAttributes(this.beanElement.getGraphNode(), str, indent + indentBy);
        this.beanTree(this.beanElement.getGraphNode().getGraphLink(), str, indent + indentBy, indentBy);
        out.write(str.toString());
    }

    protected void dumpAttributes(GraphNode elt, StringBuffer str, String indent) {
        AttrProp[] attrList = elt.getAttributes();
        int i = 0;
        while (i < attrList.length) {
            str.append(indent + "[attr: " + attrList[i] + "]\n");
            ++i;
        }
    }

    protected void beanTree(GraphLink l, StringBuffer str, String indent, String indentBy) {
        while (l != null) {
            block11: {
                String groupInstance;
                block10: {
                    String nextIndent = indent + indentBy;
                    if (l.element == null) break block10;
                    BeanBuilder.BeanElement be = (BeanBuilder.BeanElement)l.element.getObject();
                    if (be == null) break block11;
                    String type = be.getClassType();
                    if ("#PCDATA".equals(l.name) && "String".equals(type)) break block11;
                    str.append(indent);
                    str.append(l.name);
                    str.append(" : ");
                    str.append(type);
                    str.append(TreeBuilder.instanceToString(l.getElementInstance(), true));
                    if (l.element.getMarked()) {
                        str.append("...");
                    }
                    if (!l.extraData.isEmpty()) {
                        str.append(" \t");
                        str.append(l.extraData.toString());
                    }
                    str.append("\n");
                    this.dumpAttributes(l.element, str, nextIndent);
                    if (l.element.getGraphLink() != null && !l.element.getMarked()) {
                        l.element.setMarked(true);
                        this.beanTree(l.element.getGraphLink(), str, nextIndent + TreeBuilder.instanceToString(l.getGroupInstance(), true) + (l.isSequenceOr() ? "| " : ""), indentBy);
                        l.element.setMarked(false);
                    }
                }
                if (!"".equals(groupInstance = TreeBuilder.instanceToString(l.getGroupInstance(), true))) {
                    str.append(indent);
                    str.append("(\n");
                }
                if (l.child != null) {
                    this.beanTree(l.child, str, indent + ("".equals(groupInstance) ? "" : "  ") + (l.isSequenceOr() ? "| " : ""), indentBy);
                }
                if (!"".equals(groupInstance)) {
                    str.append(indent);
                    str.append(")");
                    str.append(groupInstance);
                    str.append("\n");
                }
            }
            l = l.sibling;
        }
    }

    public String toString() {
        if (this.packageName == null) {
            return "Class " + this.className;
        }
        return "Class " + this.packageName + "." + this.className;
    }

    protected void gen(Signature sig) throws IOException {
        sig.writeMethod(this.jw);
    }

    protected Signatures getSignatures(Property a) {
        String firstInterface;
        MetaElement me;
        Signatures result = new Signatures();
        boolean indexed = a.isIndexed();
        boolean isScalar = a.isScalar();
        String type = this.getBeanFullClassName(a, a.getType());
        String typeVariable = "value";
        if (a.isBean && this.config.isUseInterfaces() && (me = this.getMetaElementBeanName(a.getType())) != null && (firstInterface = AbstractCodeGeneratorClass.firstInCommaSeparatedList(me.getImplements())) != null && !firstInterface.equals(this.config.getGenerateCommonInterface()) && !firstInterface.equals(this.packageName + "." + this.config.getGenerateCommonInterface())) {
            type = firstInterface;
            typeVariable = "valueInterface";
            a.setPropertyInterface(firstInterface);
        }
        String baseType = type;
        if (indexed) {
            type = baseType + "[]";
        }
        Signature sig = new Signature("void", "set" + a.name, SETTER);
        sig.addParameter(type, typeVariable);
        if (this.config.vetoable) {
            sig.addThrows("java.beans.PropertyVetoException");
        }
        result.add(sig);
        if (indexed) {
            sig = new Signature("void", "set" + a.name, SETTERINDEXED);
            sig.addParameter("int", "index");
            sig.addParameter(baseType, typeVariable);
            if (this.config.vetoable) {
                sig.addThrows("java.beans.PropertyVetoException");
            }
            result.add(sig);
        }
        String getterName = a.getReadMethod(false);
        result.add(new Signature(type, getterName, GETTER));
        if (indexed) {
            result.add(new Signature("java.util.List", "fetch" + a.name + "List", GETTERLIST));
            sig = new Signature(baseType, a.getReadMethod(true), GETTERINDEXED);
            sig.addParameter("int", "index");
            result.add(sig);
            result.add(new Signature("int", "size" + a.name, SIZE));
            sig = new Signature("int", "add" + a.name, ADD);
            sig.addParameter(baseType, typeVariable);
            if (this.config.vetoable) {
                sig.addThrows("java.beans.PropertyVetoException");
            }
            result.add(sig);
            sig = new Signature("int", "remove" + a.name, REMOVE);
            sig.addParameter(baseType, typeVariable);
            if (this.config.vetoable) {
                sig.addThrows("java.beans.PropertyVetoException");
            }
            result.add(sig);
        }
        return result;
    }

    protected abstract Signatures getSystemSignatures();

    public void generateDelegator(OutputStream out, MetaDD mdd, String delegatorClassName) throws IOException {
        Collection generatedMethods = this.jw.getStoredMethods();
        this.resetGenBuffers();
        this.select(this.HEADER_SECTION);
        if (this.packageName != null) {
            this.gen(5, this.packageName);
            this.eol();
            this.cr();
        }
        this.gen(0, 3, delegatorClassName);
        if (this.metaElement.getDelegatorExtends() != null) {
            this.jw.write(" extends ");
            this.jw.write(this.metaElement.getDelegatorExtends());
        }
        if (this.config.getGenerateCommonInterface() != null) {
            this.jw.write(" implements ");
            this.jw.write(this.config.getGenerateCommonInterface());
        }
        this.sp();
        this.begin();
        this.select(this.DECL_SECTION);
        String delegator = "_" + this.className;
        this.gen(1, this.fullClassName, delegator);
        this.eol();
        this.cr();
        this.generateDelegatorConstructors(delegatorClassName);
        LinkedList sortedMethods = new LinkedList(generatedMethods);
        Collections.sort(sortedMethods);
        Iterator it = sortedMethods.iterator();
        while (it.hasNext()) {
            JavaWriter.Method method = (JavaWriter.Method)it.next();
            if (!method.isPublic()) continue;
            this.generateDelegator(method, delegatorClassName);
        }
        this.select(this.TRAILER_SECTION);
        this.end();
        this.printGenBuffers(out);
    }

    protected void generateDelegatorConstructors(String delegatorClassName) throws IOException {
        this.select(this.CONSTRUCTOR_SECTION);
        String delegator = "_" + this.className;
        this.gen(0, delegatorClassName);
        this.PO();
        this.gen(this.fullClassName);
        this.gen(" delegator");
        this.PC();
        this.sp();
        this.begin();
        this.geneol(delegator + " = delegator");
        this.end();
        this.cr();
    }

    protected void generateDelegator(JavaWriter.Method method, String delegatorClassName) throws IOException {
        if ("".equals(method.getReturnType())) {
            if (method.getParameters().indexOf(44) < 0 && (method.getParameters().startsWith(this.className + " ") || method.getParameters().startsWith(this.fullClassName + " "))) {
                return;
            }
            this.select(this.CONSTRUCTOR_SECTION);
            String delegator = "_" + this.className;
            this.jw.write("public ");
            this.jw.write(delegatorClassName);
            this.jw.write("(");
            this.jw.write(method.getParameters());
            this.jw.write(") ");
            if (method.getExceptions() != null) {
                this.jw.write("throws ", method.getExceptions(), " ");
            }
            this.jw.begin();
            this.jw.write(delegator, " = new ", this.fullClassName);
            this.jw.write("(");
            method.writeParametersNoTypes(this.jw);
            this.jw.writeEol(")");
            this.jw.end();
            this.jw.cr();
            return;
        }
        this.select(this.BODY_SECTION);
        boolean returnsDelegation = false;
        if (this.className.equals(method.getReturnType()) || this.fullClassName.equals(method.getReturnType())) {
            returnsDelegation = true;
        }
        this.jw.beginMethod(method.getName(), method.getParameters(), method.getExceptions(), returnsDelegation ? delegatorClassName : method.getReturnType(), method.getOptions());
        if (!"void".equals(method.getReturnType())) {
            this.gen("return ");
        }
        if (returnsDelegation) {
            this.jw.write("new ", delegatorClassName, "(");
        }
        if (!method.isStatic()) {
            this.jw.write("_", this.className);
        } else {
            this.jw.write(this.fullClassName);
        }
        this.jw.write(".");
        method.writeCall(this.jw);
        if (returnsDelegation) {
            this.jw.write(")");
        }
        this.jw.eol();
        this.jw.end();
        this.jw.cr();
    }

    protected void genWhiteSpaceRestriction(SchemaRep.WhiteSpace ws, String var) throws IOException {
        if (ws.isPreserve()) {
            return;
        }
        if (ws.isReplace()) {
            this.jw.beginIf(var + " != null");
            this.jw.comment("Whitespace Replace due to whitespace restriction.");
            this.jw.writeEol(var + " = " + var + ".replace('\\n', ' ').replace('\\t', ' ')");
            this.jw.end();
        } else if (ws.isCollapse()) {
            this.jw.beginIf(var + " != null");
            this.jw.comment("Whitespace Collapse due to whitespace restriction.");
            this.jw.writeEol(var + " = " + var + ".replace('\\n', ' ').replace('\\t', ' ').trim()");
            this.jw.beginFor("int pos = " + var + ".indexOf(\"  \")", "pos >= 0", "pos = " + var + ".indexOf(\"  \", pos)");
            this.jw.writeEol(var + " = " + var + ".substring(0, pos) + " + var + ".substring(pos+1, " + var + ".length())");
            this.jw.end();
            this.jw.end();
        }
    }

    protected void genRethrowExceptions(List exceps) {
        Iterator it = exceps.iterator();
        while (it.hasNext()) {
            this.gen("catch (");
            this.gen((String)it.next());
            this.gen(" e) ");
            this.begin();
            this.geneol("throw new java.lang.RuntimeException(e)");
            this.end();
        }
    }

    protected void genValidateProperties() throws IOException {
        this.jw.writeEol("boolean restrictionFailure = false");
        int oredCount = 0;
        int size = this.attrList.size();
        int i = 0;
        while (i < size) {
            Property a = (Property)this.attrList.get(i);
            boolean indexed = a.isIndexed();
            String attr = a.getReadMethod(false) + "()";
            String type = a.getType().intern();
            boolean mightBeNull = false;
            boolean isPrimitiveType = JavaUtil.isPrimitiveType(type);
            String propertyName = a.beanIntrospectorName();
            boolean hasDataEnumRestriction = false;
            String enumArray = "enumRestriction" + a.name;
            this.jw.comment("Validating property " + propertyName);
            if (a.ored) {
                if (!isPrimitiveType) {
                    mightBeNull = true;
                }
            } else {
                switch (a.elementInstance & 0xF0) {
                    case 32: {
                        if (isPrimitiveType) break;
                        this.genValidateIf(attr + " == null", propertyName);
                        break;
                    }
                    case 16: {
                        if (isPrimitiveType) break;
                        mightBeNull = true;
                        break;
                    }
                    case 48: {
                        break;
                    }
                    case 64: {
                        this.genValidateIf("size" + a.name + "() == 0", propertyName);
                    }
                }
            }
            if (!indexed || !a.isAttribute()) {
                Object extraData;
                Iterator it;
                if (indexed) {
                    it = a.extraDataIterator();
                    while (it.hasNext()) {
                        extraData = it.next();
                        if (!(extraData instanceof DataListRestriction)) continue;
                        DataListRestriction dlr = (DataListRestriction)extraData;
                        dlr.genRestriction(this.jw, "size" + a.name + "()", a.getReadMethod(false), type, "restrictionFailure");
                        this.jw.beginIf("restrictionFailure");
                        this.genValidateFail(JavaUtil.instanceFrom("java.lang.String", attr + " " + dlr.toString()), propertyName, false);
                        this.jw.end();
                    }
                    this.jw.beginFor("int _index = 0", "_index < size" + a.name + "()", "++_index");
                    this.jw.write(this.getBeanFullClassName(a, type));
                    this.jw.write(" element = ");
                    if (a.getPropertyInterface() != null) {
                        this.jw.write("(", this.getBeanFullClassName(a, type), ") ");
                    }
                    this.jw.writeEol(a.getReadMethod(true) + "(_index)");
                    attr = "element";
                    boolean bl = mightBeNull = !isPrimitiveType;
                }
                if (mightBeNull) {
                    this.jw.beginIf(attr + " != null");
                }
                if (a.isBean) {
                    if (a.getPropertyInterface() == null) {
                        this.jw.writeEol(attr, ".validate()");
                    } else {
                        this.jw.writeEol("((" + type + ")", attr, ").validate()");
                    }
                }
                it = a.extraDataIterator();
                while (it.hasNext()) {
                    extraData = it.next();
                    if (!(extraData instanceof DataTypeRestriction)) continue;
                    DataTypeRestriction dtr = (DataTypeRestriction)extraData;
                    dtr.genRestriction(this.jw, attr, type, "restrictionFailure");
                    this.jw.beginIf("restrictionFailure");
                    this.genValidateFail(JavaUtil.instanceFrom("java.lang.String", attr + " " + dtr.toString()), propertyName, false);
                    this.jw.end();
                }
                Iterator it2 = a.extraDataIterator();
                while (it2.hasNext()) {
                    Object extraData2 = it2.next();
                    if (!(extraData2 instanceof DataEnumRestriction)) continue;
                    DataEnumRestriction der = (DataEnumRestriction)extraData2;
                    if (!hasDataEnumRestriction) {
                        hasDataEnumRestriction = true;
                        this.jw.write("final " + type + "[] " + enumArray + " = {");
                    } else {
                        this.jw.write(", ");
                    }
                    der.genRestriction(this.jw, type);
                }
                if (hasDataEnumRestriction) {
                    this.jw.writeEol("}");
                    this.jw.writeEol("restrictionFailure = true");
                    this.jw.beginFor("int _index2 = 0", "_index2 < " + enumArray + ".length", "++_index2");
                    this.jw.beginIf(JavaUtil.genEquals(type, enumArray + "[_index2]", attr));
                    this.jw.writeEol("restrictionFailure = false");
                    this.jw.writeEol("break");
                    this.jw.end();
                    this.jw.end();
                    this.jw.beginIf("restrictionFailure");
                    this.genValidateFail(JavaUtil.instanceFrom("java.lang.String", attr + " enumeration test"), propertyName, false);
                    this.jw.end();
                }
                if (mightBeNull) {
                    this.jw.end();
                }
                if (indexed) {
                    this.jw.end();
                }
                if (a.ored && !isPrimitiveType) {
                    if (++oredCount == 1) {
                        this.jw.writeEol("int orCount = 0");
                    }
                    if (indexed) {
                        this.jw.beginIf("size" + a.name + "() > 0");
                        this.jw.writeEol("++orCount");
                    } else if (mightBeNull) {
                        this.jw.beginIf(attr + " != null");
                        this.jw.writeEol("++orCount");
                    }
                    if (indexed || mightBeNull) {
                        this.jw.end();
                    }
                }
            }
            ++i;
        }
        if (oredCount > 1) {
            this.jw.beginIf("orCount != 1");
            this.genValidateFail("\"orCount (\"+orCount+\") != 1\"", "mutually exclusive properties", false);
            this.jw.end();
        }
    }

    protected void genValidateIf(String test, String name) throws IOException {
        this.jw.beginIf(test);
        this.genValidateFail(test, name, true);
        this.jw.end();
    }

    protected abstract void genValidateFail(String var1, String var2, boolean var3) throws IOException;

    public Collection getGeneratedMethods() {
        return this.jw.getStoredMethods();
    }

    protected void genDefaultsAccessable(Property a) throws IOException {
        String type = a.getType();
        if (this.config.isDefaultsAccessable() && !a.isIndexed() && (a.isScalar() || a.getDefaultValue() != null || !a.ored && a.elementInstance == 32)) {
            this.jw.beginMethod("fetchDefault" + a.name, "", null, type, 0);
            List exceps = JavaUtil.exceptionsFromParsingText(type, false);
            if (!exceps.isEmpty()) {
                this.jw.beginTry();
            }
            this.jw.write("return ");
            if (a.getDefaultValue() != null) {
                this.jw.write(JavaUtil.instanceFrom(type, a.getDefaultValue()));
            } else {
                this.jw.write(JavaUtil.genNewDefault(type));
            }
            this.jw.eol();
            if (!exceps.isEmpty()) {
                this.end();
                this.genRethrowExceptions(exceps);
            }
            this.jw.end();
            this.jw.cr();
        }
    }

    protected String commonBeanType() {
        String cb = "java.lang.Object";
        if (this.config.getGenerateCommonInterface() != null) {
            cb = this.packageName == null ? this.config.getGenerateCommonInterface() : this.packageName + "." + this.config.getGenerateCommonInterface();
        }
        return cb;
    }

    protected static String firstInCommaSeparatedList(String lst) {
        if (lst == null) {
            return null;
        }
        int pos = lst.indexOf(44);
        if (pos < 0) {
            return lst;
        }
        return lst.substring(0, pos);
    }

    protected static class Signatures {
        Map signatureTable = new HashMap();
        List others = new LinkedList();

        public void add(Signature sig) {
            if (sig.getMethodType() == OTHER) {
                this.others.add(sig);
            } else {
                this.signatureTable.put(sig.getMethodType(), sig);
            }
        }

        public Signature findSignature(Signature.TypeOfMethod methodType) {
            Signature sig = null;
            if (methodType == OTHER) {
                Iterator it = this.others.iterator();
                if (it.hasNext()) {
                    sig = (Signature)it.next();
                }
            } else {
                sig = (Signature)this.signatureTable.get(methodType);
            }
            if (sig == null) {
                throw new IllegalStateException("Unable to find " + methodType);
            }
            return sig;
        }

        public Iterator iterator() {
            return new SignaturesIterator();
        }

        public class SignaturesIterator
        implements Iterator {
            Iterator tableIterator;
            Iterator othersIterator;

            public SignaturesIterator() {
                this.tableIterator = Signatures.this.signatureTable.values().iterator();
                this.othersIterator = Signatures.this.others.iterator();
            }

            public boolean hasNext() {
                if (this.tableIterator.hasNext()) {
                    return true;
                }
                return this.othersIterator.hasNext();
            }

            public Object next() {
                if (this.tableIterator.hasNext()) {
                    return this.tableIterator.next();
                }
                return this.othersIterator.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected static class Signature {
        private String returnType;
        private String methodName;
        private TypeOfMethod methodType;
        private List parameterTypes;
        private List parameterNames;
        private List throwTypes;
        private boolean _isStatic;

        public Signature(String returnType, String methodName, TypeOfMethod methodType) {
            this.returnType = returnType;
            this.methodName = methodName;
            this.methodType = methodType;
            this.parameterTypes = new LinkedList();
            this.parameterNames = new LinkedList();
            this.throwTypes = new LinkedList();
            this._isStatic = false;
        }

        public Signature(String returnType, String methodName) {
            this.returnType = returnType;
            this.methodName = methodName;
            this.methodType = OTHER;
            this.parameterTypes = new LinkedList();
            this.parameterNames = new LinkedList();
            this.throwTypes = new LinkedList();
            this._isStatic = false;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public TypeOfMethod getMethodType() {
            return this.methodType;
        }

        public boolean isStatic() {
            return this._isStatic;
        }

        public void setStatic() {
            this._isStatic = true;
        }

        public boolean isVoidReturnType() {
            return "void".equals(this.returnType);
        }

        public void addParameter(String type, String name) {
            this.parameterTypes.add(type);
            this.parameterNames.add(name);
        }

        public void addThrows(String type) {
            this.throwTypes.add(type);
        }

        public void writeMethod(JavaWriter jw) throws IOException {
            StringBuffer parameters = new StringBuffer();
            Iterator itTypes = this.parameterTypes.iterator();
            Iterator itNames = this.parameterNames.iterator();
            boolean first = true;
            while (itTypes.hasNext() && itNames.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    parameters.append(", ");
                }
                parameters.append((String)itTypes.next());
                parameters.append(" ");
                parameters.append((String)itNames.next());
            }
            String exceptions = null;
            Iterator itThrows = this.throwTypes.iterator();
            if (itThrows.hasNext()) {
                exceptions = "";
                first = true;
                do {
                    if (first) {
                        first = false;
                    } else {
                        exceptions = exceptions + ", ";
                    }
                    exceptions = exceptions + (String)itThrows.next();
                } while (itThrows.hasNext());
            }
            int options = 0 | 0x100;
            if (this._isStatic) {
                options |= 0x10;
            }
            jw.writeMethod(this.methodName, parameters.toString(), exceptions, this.returnType, options);
        }

        public String toString() {
            StringBuffer str = new StringBuffer();
            if (this._isStatic) {
                str.append("static ");
            }
            str.append(this.returnType);
            str.append(" ");
            str.append(this.methodName);
            str.append("(");
            Iterator itTypes = this.parameterTypes.iterator();
            Iterator itNames = this.parameterNames.iterator();
            boolean first = true;
            while (itTypes.hasNext() && itNames.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    str.append(", ");
                }
                str.append((String)itTypes.next());
                str.append(" ");
                str.append((String)itNames.next());
            }
            str.append(")");
            Iterator itThrows = this.throwTypes.iterator();
            if (itThrows.hasNext()) {
                str.append(" throws ");
                first = true;
                do {
                    if (first) {
                        first = false;
                    } else {
                        str.append(", ");
                    }
                    str.append((String)itThrows.next());
                } while (itThrows.hasNext());
            }
            return str.toString();
        }

        public String callMethod() {
            StringBuffer str = new StringBuffer();
            str.append(this.methodName);
            str.append("(");
            Iterator itTypes = this.parameterTypes.iterator();
            Iterator itNames = this.parameterNames.iterator();
            boolean first = true;
            while (itTypes.hasNext() && itNames.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    str.append(", ");
                }
                str.append((String)itNames.next());
            }
            str.append(")");
            return str.toString();
        }

        public static class TypeOfMethod {
            private final String name;
            public static final TypeOfMethod SETTER = new TypeOfMethod("setter");
            public static final TypeOfMethod SETTERINDEXED = new TypeOfMethod("setterindexed");
            public static final TypeOfMethod GETTER = new TypeOfMethod("getter");
            public static final TypeOfMethod GETTERLIST = new TypeOfMethod("getterlist");
            public static final TypeOfMethod GETTERINDEXED = new TypeOfMethod("getterindexed");
            public static final TypeOfMethod SIZE = new TypeOfMethod("size");
            public static final TypeOfMethod ADD = new TypeOfMethod("add");
            public static final TypeOfMethod REMOVE = new TypeOfMethod("remove");
            public static final TypeOfMethod OTHER = new TypeOfMethod("other");

            private TypeOfMethod(String name) {
                this.name = name;
            }

            public String toString() {
                return "TypeOfMethod " + this.name;
            }
        }
    }

    static class Property {
        String dtdName;
        String name;
        String classType;
        int type;
        int elementInstance;
        int groupInstance;
        int level;
        boolean isBean;
        boolean ored;
        String constName;
        private boolean _isAttribute;
        private AttrProp attrProp;
        private String defaultValue;
        private boolean directChild;
        private GraphNode graphNode;
        private GraphLink graphLink;
        private List extraData;
        private boolean canBeEmpty = false;
        private String propertyInterface = null;
        AttrProp[] attributes;

        Property(String propName, String dtdName, GraphNode graphNode, GraphLink graphLink, String classType, int eInst, int gInst, int level, int type, boolean ored, AttrProp[] attrs, String constName, String defaultValue, boolean directChild, List extraData) {
            if (gInst == 48) {
                eInst = gInst;
            } else if (gInst == 64) {
                eInst = eInst == 16 ? 48 : 64;
            }
            this.name = propName;
            this.dtdName = dtdName;
            this.graphNode = graphNode;
            this.graphLink = graphLink;
            this.classType = classType;
            this.type = type;
            this.elementInstance = eInst;
            this.groupInstance = gInst;
            this.level = level;
            this.attributes = attrs;
            this.ored = ored;
            this.constName = constName;
            this.isBean = Common.isBean(type);
            if (this.isScalar()) {
                this.classType = Common.wrapperClass(type);
            }
            this.defaultValue = defaultValue;
            this.directChild = directChild;
            this.extraData = extraData;
        }

        public boolean isIndexed() {
            if (this.elementInstance == 64) {
                return true;
            }
            return this.elementInstance == 48;
        }

        public void setIndexed(boolean value) {
            if (this.isIndexed() == value) {
                return;
            }
            this.elementInstance = value ? 48 : 16;
        }

        public boolean isScalar() {
            return Common.isScalar(this.type);
        }

        public String getScalarType() {
            if (!this.isScalar()) {
                return null;
            }
            return Common.scalarType(this.type);
        }

        public String getType() {
            if (this.isScalar()) {
                return this.getScalarType();
            }
            return this.classType;
        }

        public void setAttribute(boolean value) {
            this._isAttribute = value;
        }

        public boolean isAttribute() {
            return this._isAttribute;
        }

        public void setAttrProp(AttrProp ap) {
            this.attrProp = ap;
            this.setAttribute(ap != null);
        }

        public AttrProp getAttrProp() {
            return this.attrProp;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isDirectChild() {
            return this.directChild;
        }

        public void setCanBeEmpty(boolean value) {
            this.canBeEmpty = value;
        }

        public boolean getCanBeEmpty() {
            return this.canBeEmpty;
        }

        public GraphNode getGraphNode() {
            return this.graphNode;
        }

        public GraphLink getGraphLink() {
            return this.graphLink;
        }

        public void setPropertyInterface(String iface) {
            this.propertyInterface = iface;
        }

        public String getPropertyInterface() {
            return this.propertyInterface;
        }

        public String instanceOf() {
            return Introspector.decapitalize(this.name);
        }

        public String beanIntrospectorName() {
            return Introspector.decapitalize(this.name);
        }

        public String getReadMethod(boolean withIndexParameter) {
            if (!withIndexParameter && this.isIndexed()) {
                return "get" + this.name;
            }
            if (this.isScalar() && Common.isBoolean(this.type)) {
                return "is" + this.name;
            }
            return "get" + this.name;
        }

        public String getWriteMethod() {
            return "set" + this.name;
        }

        public Object searchExtraData(Class type) {
            Iterator it = this.extraData.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!type.isAssignableFrom(o.getClass())) continue;
                return o;
            }
            return null;
        }

        public Iterator extraDataIterator() {
            return this.extraData.iterator();
        }
    }
}

