/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.io;

import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.io.FileListerRelative;
import com.sun.enterprise.util.io.IOLogger;
import com.sun.enterprise.util.io.NativeIOException;
import com.sun.enterprise.util.io.NativeResults;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileUtils {
    static Logger _logger = IOLogger.getLogger();
    static Logger _utillogger = LogDomains.getLogger((String)"javax.enterprise.system.util");
    private static final int BUFFER_SIZE = 65536;
    private static final char[] ILLEGAL_FILENAME_CHARS = new char[]{'/', '\\', ':', '*', '?', '\"', '<', '>', '|'};
    private static final String ILLEGAL_FILENAME_STRING = "\\/:*?\"<>|";
    private static final char REPLACEMENT_CHAR = '_';
    private static final char BLANK = ' ';
    private static final char DOT = '.';
    private static String TMPFILENAME = "scratch";
    private static final int FILE_OPERATION_MAX_RETRIES = Integer.getInteger("com.sun.appserv.winFileLockRetryLimit", 4);
    private static final int FILE_OPERATION_SLEEP_DELAY_MS = Integer.getInteger("com.sun.appserv.winFileLockRetryDelay", 100);
    private static final Level FILE_OPERATION_LOG_LEVEL = Level.INFO;

    public static native int recursiveChownNative(String var0, String var1);

    public static native int recursiveChownNative(String var0);

    public static native int recursiveChmodNative(String var0, String var1);

    private FileUtils() {
    }

    public static boolean safeIsDirectory(File f) {
        return f != null && f.exists() && f.isDirectory();
    }

    public static boolean safeIsRealDirectory(String s) {
        return FileUtils.safeIsRealDirectory(new File(s));
    }

    public static boolean safeIsRealDirectory(File f) {
        String absolute;
        if (!FileUtils.safeIsDirectory(f)) {
            return false;
        }
        String canonical = FileUtils.safeGetCanonicalPath(f);
        if (canonical.equals(absolute = f.getAbsolutePath())) {
            return true;
        }
        return OS.isWindows() && canonical.equalsIgnoreCase(absolute);
    }

    public static boolean safeIsDirectory(String s) {
        return FileUtils.safeIsDirectory(new File(s));
    }

    public static String safeGetCanonicalPath(File f) {
        if (f == null) {
            return null;
        }
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            return f.getAbsolutePath();
        }
    }

    public static File safeGetCanonicalFile(File f) {
        if (f == null) {
            return null;
        }
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return f.getAbsoluteFile();
        }
    }

    public static boolean isEar(String filename) {
        return FileUtils.hasExtension(filename, ".ear");
    }

    public static boolean isJar(String filename) {
        return FileUtils.hasExtension(filename, ".jar");
    }

    public static boolean isZip(String filename) {
        return FileUtils.hasExtensionIgnoreCase(filename, ".zip");
    }

    public static boolean isArchive(String filename) {
        return FileUtils.isWar(filename) || FileUtils.isRar(filename) || FileUtils.isJar(filename) || FileUtils.isZip(filename) || FileUtils.isEar(filename);
    }

    public static boolean isArchive(File f) {
        return FileUtils.isWar(f) || FileUtils.isRar(f) || FileUtils.isJar(f) || FileUtils.isZip(f) || FileUtils.isEar(f);
    }

    public static boolean isWar(String filename) {
        return FileUtils.hasExtension(filename, ".war");
    }

    public static boolean isRar(String filename) {
        return FileUtils.hasExtension(filename, ".rar");
    }

    public static boolean isEar(File f) {
        return FileUtils.hasExtension(f, ".ear");
    }

    public static boolean isJar(File f) {
        return FileUtils.hasExtension(f, ".jar");
    }

    public static boolean isZip(File f) {
        return FileUtils.hasExtensionIgnoreCase(f, ".zip");
    }

    public static boolean isWar(File f) {
        return FileUtils.hasExtension(f, ".war");
    }

    public static boolean isRar(File f) {
        return FileUtils.hasExtension(f, ".rar");
    }

    public static boolean hasExtension(String filename, String ext) {
        if (filename == null || filename.length() <= 0) {
            return false;
        }
        return filename.endsWith(ext);
    }

    public static boolean hasExtension(File f, String ext) {
        if (f == null || !f.exists()) {
            return false;
        }
        return f.getName().endsWith(ext);
    }

    public static boolean hasExtensionIgnoreCase(String filename, String ext) {
        if (filename == null || filename.length() <= 0) {
            return false;
        }
        return filename.toLowerCase().endsWith(ext.toLowerCase());
    }

    public static boolean hasExtensionIgnoreCase(File f, String ext) {
        if (f == null || !f.exists()) {
            return false;
        }
        return f.getName().toLowerCase().endsWith(ext.toLowerCase());
    }

    public static boolean isLegalFilename(String filename) {
        if (!FileUtils.isValidString(filename)) {
            return false;
        }
        for (int i = 0; i < ILLEGAL_FILENAME_CHARS.length; ++i) {
            if (filename.indexOf(ILLEGAL_FILENAME_CHARS[i]) < 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isFriendlyFilename(String filename) {
        if (!FileUtils.isValidString(filename)) {
            return false;
        }
        if (filename.indexOf(32) >= 0 || filename.indexOf(46) >= 0) {
            return false;
        }
        return FileUtils.isLegalFilename(filename);
    }

    public static String makeLegalFilename(String filename) {
        if (FileUtils.isLegalFilename(filename)) {
            return filename;
        }
        for (int i = 0; i < ILLEGAL_FILENAME_CHARS.length; ++i) {
            filename = filename.replace(ILLEGAL_FILENAME_CHARS[i], '_');
        }
        return filename;
    }

    public static String makeFriendlyFileName(String filename) {
        return FileUtils.makeFriendlyFilename(filename);
    }

    public static String makeFriendlyFilename(String filename) {
        if (FileUtils.isFriendlyFilename(filename)) {
            return filename;
        }
        String ret = FileUtils.makeLegalFilename(filename).replace(' ', '_');
        ret = ret.replace('.', '_');
        return ret;
    }

    public static String makeFriendlyFilenameNoExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (index > 0) {
            filename = filename.substring(0, index);
        }
        return FileUtils.makeFriendlyFilename(filename);
    }

    public static String makeFriendlyFileNameNoExtension(String filename) {
        return FileUtils.makeFriendlyFilenameNoExtension(filename);
    }

    public static void liquidate(File parent) {
        FileUtils.whack(parent);
    }

    public static boolean whack(File parent) {
        if (FileUtils.safeIsRealDirectory(parent)) {
            File[] kids = parent.listFiles();
            for (int i = 0; i < kids.length; ++i) {
                File f = kids[i];
                if (f.isDirectory()) {
                    FileUtils.whack(f);
                }
                FileUtils.deleteFile(f);
            }
        }
        return FileUtils.deleteFile(parent);
    }

    public static boolean deleteFile(File f) {
        boolean deleteOK;
        boolean bl = deleteOK = !f.exists();
        if (!deleteOK) {
            deleteOK = f.delete();
            if (!deleteOK) {
                boolean log = _utillogger.isLoggable(FILE_OPERATION_LOG_LEVEL);
                String filePath = null;
                if (log) {
                    filePath = f.getAbsolutePath();
                    _utillogger.log(FILE_OPERATION_LOG_LEVEL, "enterprise_util.error_deleting_file", filePath);
                }
                if (OS.isWindows()) {
                    if (log && FILE_OPERATION_MAX_RETRIES > 0) {
                        _utillogger.log(FILE_OPERATION_LOG_LEVEL, "enterprise_util.perform_gc");
                    }
                    int retries = 0;
                    for (retries = 0; retries < FILE_OPERATION_MAX_RETRIES && !deleteOK; ++retries) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(FILE_OPERATION_SLEEP_DELAY_MS);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        System.gc();
                        deleteOK = f.delete();
                    }
                    if (log) {
                        if (deleteOK) {
                            _utillogger.log(FILE_OPERATION_LOG_LEVEL, "enterprise_util.retry_delete_success", new Object[]{filePath, new Integer(retries)});
                        } else {
                            _utillogger.log(FILE_OPERATION_LOG_LEVEL, "enterprise_util.retry_delete_failure", new Object[]{filePath, new Integer(retries)});
                        }
                    }
                }
                if (!deleteOK) {
                    f.deleteOnExit();
                    _utillogger.log(FILE_OPERATION_LOG_LEVEL, "enterprise_util.delete_failed_now_deleteonexit", f.getAbsolutePath());
                }
            } else {
                _utillogger.log(Level.FINE, "Successfully deleted {0}", f.getAbsolutePath());
            }
        }
        return deleteOK;
    }

    public static File getDirectory(File f) {
        String filename = f.getAbsolutePath();
        return new File(new File(filename).getParent());
    }

    public static File createTempFile(File directory) {
        File f = null;
        try {
            f = File.createTempFile(TMPFILENAME, "jar", directory);
        }
        catch (IOException ioe) {
            _logger.log(Level.SEVERE, "iplanet_util.io_exception", ioe);
        }
        f.deleteOnExit();
        return f;
    }

    public static File[] listAllFiles(File dirName, String ext) {
        File[] target = null;
        List list = FileUtils.searchDir(dirName, ext);
        if (list != null && list.size() > 0) {
            target = new File[list.size()];
            target = list.toArray(target);
        }
        return target;
    }

    public static List searchDir(File dirName, String ext) {
        ArrayList<File> targetList = null;
        if (dirName.isDirectory()) {
            targetList = new ArrayList<File>();
            File[] list = dirName.listFiles();
            for (int i = 0; i < list.length; ++i) {
                if (list[i].isDirectory()) {
                    targetList.addAll(FileUtils.searchDir(list[i], ext));
                    continue;
                }
                String name = list[i].toString();
                if (!FileUtils.hasExtension(name, ext)) continue;
                targetList.add(list[i]);
            }
        }
        return targetList;
    }

    public static void copy(String from, String to) throws IOException {
        if (from == null || to == null) {
            throw new IllegalArgumentException("null or empty filename argument");
        }
        File fin = new File(from);
        File fout = new File(to);
        FileUtils.copy(fin, fout);
    }

    public static void copy(File fin, File fout) throws IOException {
        if (FileUtils.safeIsDirectory(fin)) {
            FileUtils.copyTree(fin, fout);
            return;
        }
        if (!fin.exists()) {
            throw new IllegalArgumentException("File source doesn't exist");
        }
        if (!FileUtils.safeIsDirectory(fout.getParentFile())) {
            fout.getParentFile().mkdirs();
        }
        FileUtils.copy(new FileInputStream(fin), new FileOutputStream(fout));
    }

    public static void copyTree(File din, File dout) throws IOException {
        if (!FileUtils.safeIsDirectory(din)) {
            throw new IllegalArgumentException("Source isn't a directory");
        }
        dout.mkdirs();
        if (!FileUtils.safeIsDirectory(dout)) {
            throw new IllegalArgumentException("Can't create destination directory");
        }
        FileListerRelative flr = new FileListerRelative(din);
        String[] files = flr.getFiles();
        for (int i = 0; i < files.length; ++i) {
            File fin = new File(din, files[i]);
            File fout = new File(dout, files[i]);
            FileUtils.copy(fin, fout);
            _logger.log(Level.FINE, ".");
        }
    }

    public static void copy(InputStream inStream, OutputStream outStream) throws IOException {
        FileUtils.copyWithoutClose(inStream, outStream);
        inStream.close();
        outStream.close();
    }

    public static void copyWithoutClose(InputStream inStream, OutputStream outStream) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(inStream, 65536);
        BufferedOutputStream bos = new BufferedOutputStream(outStream, 65536);
        byte[] buf = new byte[65536];
        int len = 0;
        while (len != -1) {
            try {
                len = bis.read(buf, 0, buf.length);
            }
            catch (EOFException eof) {
                break;
            }
            if (len == -1) continue;
            bos.write(buf, 0, len);
        }
        bos.flush();
    }

    public static String makeForwardSlashes(String inputStr) {
        if (inputStr == null) {
            throw new IllegalArgumentException("null String FileUtils.makeForwardSlashes");
        }
        return inputStr.replace('\\', '/');
    }

    public static String getIllegalFilenameCharacters() {
        return ILLEGAL_FILENAME_STRING;
    }

    public static String recursiveChown(File dirOrFile) throws NativeIOException {
        return FileUtils.recursiveChown(dirOrFile, null);
    }

    public static String recursiveChown(File dirOrFile, String user) throws NativeIOException {
        if (dirOrFile == null || !dirOrFile.exists()) {
            throw new NativeIOException("File doesn't exist: " + dirOrFile);
        }
        String fname = dirOrFile.getAbsolutePath();
        int ret = 0;
        ret = !FileUtils.isValidString(user) ? FileUtils.recursiveChownNative(fname) : FileUtils.recursiveChownNative(fname, user);
        NativeResults nr = new NativeResults(ret);
        NativeIOException ne = nr.getResultException();
        if (ne == null) {
            return nr.getResultString();
        }
        throw ne;
    }

    public static String recursiveChmod(File dirOrFile, String permissions) throws NativeIOException {
        if (dirOrFile == null || !dirOrFile.exists()) {
            throw new NativeIOException("File doesn't exist: " + dirOrFile);
        }
        if (permissions == null) {
            throw new NativeIOException("null permissions string.");
        }
        permissions = permissions.toLowerCase();
        FileUtils.verifyPermissions(permissions);
        int ret = FileUtils.recursiveChmodNative(dirOrFile.getAbsolutePath(), permissions);
        NativeResults nr = new NativeResults(ret);
        NativeIOException ne = nr.getResultException();
        if (ne == null) {
            return nr.getResultString();
        }
        throw ne;
    }

    static boolean isValidString(String s) {
        return s != null && s.length() != 0;
    }

    public static File smartRename(File original) throws IOException {
        if (original == null) {
            throw new IllegalArgumentException("null argument");
        }
        String originalName = original.getAbsolutePath();
        if (!FileUtils.safeIsDirectory(original)) {
            throw new IOException("Directory doesn't exist: " + originalName);
        }
        String renamedName = originalName + "_old";
        File renamed = new File(renamedName);
        if (renamed.exists()) {
            FileUtils.whack(renamed);
            if (renamed.exists()) {
                for (int i = 0; i < 1000; ++i) {
                    String name = renamedName + i;
                    renamed = new File(name);
                    try {
                        FileUtils.whack(renamed);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    if (renamed.exists()) continue;
                    renamedName = name;
                    break;
                }
                if (renamed.exists()) {
                    throw new IOException("Tried 1000 possible rename directory names.  None worked!");
                }
            }
        }
        if (original.renameTo(renamed)) {
            return renamed;
        }
        FileUtils.copyTree(original, renamed);
        FileUtils.whack(original);
        return renamed;
    }

    public static boolean renameFile(File fromFile, File toFile) {
        boolean result = fromFile.renameTo(toFile);
        boolean log = _utillogger.isLoggable(FILE_OPERATION_LOG_LEVEL);
        if (!result) {
            String fromFilePath = null;
            String toFilePath = null;
            if (log) {
                fromFilePath = fromFile.getAbsolutePath();
                toFilePath = toFile.getAbsolutePath();
                _utillogger.log(FILE_OPERATION_LOG_LEVEL, "enterprise_util.error_renaming_file", new Object[]{fromFilePath, toFilePath});
            }
            if (OS.isWindows()) {
                if (log && FILE_OPERATION_MAX_RETRIES > 0) {
                    _utillogger.log(FILE_OPERATION_LOG_LEVEL, "enterprise_util.perform_gc");
                }
                int retries = 0;
                for (retries = 0; retries < FILE_OPERATION_MAX_RETRIES && !result; ++retries) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(FILE_OPERATION_SLEEP_DELAY_MS);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    System.gc();
                    result = fromFile.renameTo(toFile);
                }
                if (log) {
                    if (result) {
                        _utillogger.log(FILE_OPERATION_LOG_LEVEL, "enterprise_util.retry_rename_success", new Object[]{fromFilePath, toFilePath, new Integer(retries)});
                    } else {
                        _utillogger.log(FILE_OPERATION_LOG_LEVEL, "enterprise_util.retry_rename_failure", new Object[]{fromFilePath, toFilePath, new Integer(retries)});
                    }
                }
            }
        } else if (_utillogger.isLoggable(Level.FINE)) {
            _utillogger.log(Level.FINE, "enterprise_util.rename_initial_success", new Object[]{fromFile.getAbsolutePath(), toFile.getAbsolutePath()});
        }
        return result;
    }

    private static void verifyPermissions(String per) throws NativeIOException {
        if (per == null) {
            throw new NativeIOException("null permissions string.");
        }
        if (per.length() != 9) {
            throw new NativeIOException("permissions string must be exactly 9 characters long.  It is " + per.length() + " characters long.");
        }
        String err1 = "permissions string has a bad character ('";
        String err2 = "') at position #";
        String err3 = ".  Expected '-' or '";
        String err4 = "'";
        for (int i = 0; i < 9; ++i) {
            char c = per.charAt(i);
            int pos = i % 3;
            if (pos == 0) {
                if (c == 'r' || c == '-') continue;
                throw new NativeIOException(err1 + c + err2 + (i + 1) + err3 + 'r' + err4);
            }
            if (pos == 1) {
                if (c == 'w' || c == '-') continue;
                throw new NativeIOException(err1 + c + err2 + (i + 1) + err3 + 'w' + err4);
            }
            if (pos != 2 || c == 'x' || c == '-') continue;
            throw new NativeIOException(err1 + c + err2 + (i + 1) + err3 + 'x' + err4);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void appendText(String fileName, String line) throws RuntimeException {
        RandomAccessFile file = null;
        try {
            try {
                String MODE = "rw";
                file = new RandomAccessFile(fileName, "rw");
                file.seek(file.getFilePointer() + file.length());
                file.writeBytes(line);
            }
            catch (Exception e) {
                throw new RuntimeException("FileUtils.appendText()", e);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (file == null) throw throwable;
                file.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (file == null) return;
        file.close();
        return;
    }

    public static void appendText(String fileName, StringBuffer buffer) throws IOException, FileNotFoundException {
        FileUtils.appendText(fileName, buffer.toString());
    }

    public static void main(String[] args) {
        try {
            System.out.println(FileUtils.smartRename(new File("C:/temp/test")));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        FileUtils.appendText("empty.txt", "text line");
    }
}

