/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.util.jmx.AttributeNameMangler;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class ParamNameMapper
implements AttributeNameMangler {
    final Map mMappings = new HashMap();
    final String mWordDelim;
    public static final String DEFAULT_WORD_DELIM = "_";

    public ParamNameMapper(Map overrides) {
        this(overrides, DEFAULT_WORD_DELIM);
    }

    public ParamNameMapper(Map overrides, String wordDelim) {
        if (overrides != null) {
            this.mMappings.putAll(overrides);
        }
        this.mWordDelim = wordDelim;
    }

    public ParamNameMapper(String wordDelim) {
        this(null, wordDelim);
    }

    public ParamNameMapper() {
        this(null, DEFAULT_WORD_DELIM);
    }

    private String getUpperCaseSequence(CharacterIterator iter) {
        char c;
        StringBuffer buf = new StringBuffer();
        while ((c = iter.current()) != '\uffff' && !Character.isLowerCase(c)) {
            iter.next();
            buf.append(c);
        }
        return buf.toString();
    }

    private String getLowerCaseSequence(StringCharacterIterator iter) {
        char c;
        StringBuffer buf = new StringBuffer();
        while ((c = iter.current()) != '\uffff' && !Character.isUpperCase(c)) {
            iter.next();
            buf.append(c);
        }
        return buf.toString();
    }

    private String newToOld(String newName) {
        StringCharacterIterator iter = new StringCharacterIterator(newName);
        StringBuffer buf = new StringBuffer();
        while (iter.current() != '\uffff') {
            String uppercase = this.getUpperCaseSequence(iter);
            if (uppercase.length() <= 1 || iter.current() == '\uffff') {
                buf.append(uppercase.toLowerCase());
            } else {
                int acronymLength = uppercase.length() - 1;
                String acronym = uppercase.substring(0, acronymLength);
                char firstOfNext = uppercase.charAt(acronymLength);
                buf.append(acronym.toLowerCase());
                buf.append(this.mWordDelim);
                buf.append(Character.toLowerCase(firstOfNext));
            }
            buf.append(this.getLowerCaseSequence(iter));
            if (iter.current() == '\uffff') continue;
            buf.append(this.mWordDelim);
        }
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator iter = this.mMappings.keySet().iterator();
        while (iter.hasNext()) {
            String newName = (String)iter.next();
            buf.append(newName + "=" + this.mMappings.get(newName) + "\n");
        }
        return buf.toString();
    }

    public String mangleAttributeName(String newName) {
        String result = (String)this.mMappings.get(newName);
        if (result == null) {
            result = this.newToOld(newName);
            this.mMappings.put(newName, result);
        }
        return result;
    }
}

