/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.util.misc.CircularList;
import com.sun.appserv.management.util.misc.OverflowHandler;
import java.util.HashMap;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationFilter;

final class NotificationBuffer {
    private final CircularList mNotifications;
    private final NotificationFilter mFilter;
    private final int mBufferSize;
    long mNextSequenceNumber;
    private OverflowHandler mOverflowHandler;
    private final Notification[] EMPTY_NOTIFS = new Notification[0];
    private final Long LONG_ZERO = new Long(0L);
    public static final String NEXT_SEQUENCE_NUMBER_KEY = "NextSequenceNumber";
    public static final String NOTIFICATIONS_KEY = "Notifications";
    static final /* synthetic */ boolean $assertionsDisabled;

    protected synchronized long nextSequenceNumber() {
        return this.mNextSequenceNumber++;
    }

    protected synchronized long getNextSequenceNumber() {
        return this.mNextSequenceNumber;
    }

    public NotificationBuffer(int bufferSize, NotificationFilter filter, OverflowHandler handler) {
        this.mFilter = filter;
        this.mBufferSize = bufferSize;
        this.mNotifications = new CircularList(bufferSize);
        this.mNextSequenceNumber = 1L;
        this.mOverflowHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bufferNotification(Notification notif) {
        if (this.mFilter == null || this.mFilter.isNotificationEnabled(notif)) {
            CircularList circularList = this.mNotifications;
            synchronized (circularList) {
                this.mNotifications.add(notif);
                this.nextSequenceNumber();
            }
        }
    }

    public int getBufferSize() {
        return this.mBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CircularList circularList = this.mNotifications;
        synchronized (circularList) {
            this.mNotifications.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getNotifications(long sequenceNumberIn) {
        if (sequenceNumberIn < 0L) {
            throw new IllegalArgumentException("" + sequenceNumberIn);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(NEXT_SEQUENCE_NUMBER_KEY, this.LONG_ZERO);
        result.put(NOTIFICATIONS_KEY, this.EMPTY_NOTIFS);
        CircularList circularList = this.mNotifications;
        synchronized (circularList) {
            int numNotifsAvailable = this.mNotifications.size();
            long nextAvailSequenceNumber = this.getNextSequenceNumber();
            result.put(NEXT_SEQUENCE_NUMBER_KEY, new Long(nextAvailSequenceNumber));
            if (numNotifsAvailable != 0) {
                long requestedSequenceNumber;
                long lastAvailSequenceNumber = nextAvailSequenceNumber - 1L;
                long firstAvailSequenceNumber = 1L + (lastAvailSequenceNumber - (long)numNotifsAvailable);
                if (!$assertionsDisabled && firstAvailSequenceNumber < 1L) {
                    throw new AssertionError();
                }
                long l = requestedSequenceNumber = sequenceNumberIn == 0L ? firstAvailSequenceNumber : sequenceNumberIn;
                if (requestedSequenceNumber >= firstAvailSequenceNumber && requestedSequenceNumber <= lastAvailSequenceNumber) {
                    int numMatches = 1 + (int)(lastAvailSequenceNumber - requestedSequenceNumber);
                    Notification[] notifs = new Notification[numMatches];
                    int startIndex = (int)(requestedSequenceNumber - firstAvailSequenceNumber);
                    for (int i = 0; i < numMatches; ++i) {
                        notifs[i] = (Notification)this.mNotifications.get(startIndex + i);
                    }
                    result.put(NOTIFICATIONS_KEY, notifs);
                }
            }
        }
        if (!$assertionsDisabled && !(result.get(NOTIFICATIONS_KEY) instanceof Notification[])) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(result.get(NEXT_SEQUENCE_NUMBER_KEY) instanceof Long)) {
            throw new AssertionError();
        }
        return result;
    }

    static {
        $assertionsDisabled = !NotificationBuffer.class.desiredAssertionStatus();
    }
}

