/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;

final class MBeanInfoConverter {
    private final Map mConvertedInfos = Collections.synchronizedMap(new HashMap());
    private static MBeanInfoConverter INSTANCE;
    private static final String OBJECT_NAME_SUFFIX = "ObjectName";
    private static final String SET_SUFFIX = "Set";
    private static final String MAP_SUFFIX = "Map";
    private static final String OBJECT_NAME_MAP_SUFFIX = "ObjectNameMap";
    private static final String OBJECT_NAME_SET_SUFFIX = "ObjectNameSet";
    static final /* synthetic */ boolean $assertionsDisabled;

    private MBeanInfoConverter() {
    }

    public static synchronized MBeanInfoConverter getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MBeanInfoConverter();
        }
        return INSTANCE;
    }

    protected static Class toClass(String className) {
        try {
            return ClassUtil.getClassFromName(className);
        }
        catch (ClassNotFoundException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            throw new RuntimeException(e);
        }
    }

    protected void trace(Object o) {
    }

    private final MBeanAttributeInfo convert(MBeanAttributeInfo info) {
        MBeanAttributeInfo result = info;
        String name = info.getName();
        Class type = MBeanInfoConverter.toClass(info.getType());
        String newName = null;
        Class newType = type;
        if (AMX.class.isAssignableFrom(type)) {
            newName = name + OBJECT_NAME_SUFFIX;
            newType = ObjectName.class;
        } else if (name.endsWith(SET_SUFFIX)) {
            newName = MBeanInfoConverter.convertMethodName(name, SET_SUFFIX, OBJECT_NAME_SET_SUFFIX);
        } else if (name.endsWith(MAP_SUFFIX)) {
            newName = MBeanInfoConverter.convertMethodName(name, MAP_SUFFIX, OBJECT_NAME_MAP_SUFFIX);
        }
        if (newName != null) {
            this.trace(ClassUtil.stripPackageName(type.getName()) + " " + name + " => " + ClassUtil.stripPackageName(newType.getName()) + " " + newName);
            result = new MBeanAttributeInfo(newName, newType.getName(), info.getDescription(), info.isReadable(), info.isWritable(), info.isIs());
        }
        return result;
    }

    protected static String convertMethodName(String srcName, String srcSuffix, String resultSuffix) {
        return StringUtil.replaceSuffix(srcName, srcSuffix, resultSuffix);
    }

    private final MBeanOperationInfo convert(MBeanOperationInfo info) {
        MBeanOperationInfo result = info;
        String name = info.getName();
        Class returnClass = MBeanInfoConverter.toClass(info.getReturnType());
        String newName = null;
        Class newReturnClass = returnClass;
        if (AMX.class.isAssignableFrom(returnClass)) {
            Class clazz = newReturnClass = ObjectName.class;
            newName = name.startsWith("create") ? name : name + OBJECT_NAME_SUFFIX;
        } else if (Map.class.isAssignableFrom(returnClass) && name.endsWith(MAP_SUFFIX)) {
            newName = MBeanInfoConverter.convertMethodName(name, MAP_SUFFIX, OBJECT_NAME_MAP_SUFFIX);
        } else if (Set.class.isAssignableFrom(returnClass) && name.endsWith(SET_SUFFIX)) {
            newName = MBeanInfoConverter.convertMethodName(name, SET_SUFFIX, OBJECT_NAME_SET_SUFFIX);
        }
        if (newName != null) {
            this.trace(ClassUtil.stripPackageName(returnClass.getName()) + " " + name + "(...)" + " => " + ClassUtil.stripPackageName(newReturnClass.getName()) + " " + newName + "(...)");
            result = new MBeanOperationInfo(newName, info.getDescription(), info.getSignature(), newReturnClass.getName(), info.getImpact());
        }
        return result;
    }

    private final MBeanAttributeInfo[] convertAttributes(MBeanAttributeInfo[] origInfos) {
        MBeanAttributeInfo[] infos = new MBeanAttributeInfo[origInfos.length];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = this.convert(origInfos[i]);
        }
        return infos;
    }

    private final MBeanOperationInfo[] convertOperations(MBeanOperationInfo[] origInfos) {
        MBeanOperationInfo[] infos = new MBeanOperationInfo[origInfos.length];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = this.convert(origInfos[i]);
        }
        return infos;
    }

    private final MBeanInfo find(Class theInterface) {
        return (MBeanInfo)this.mConvertedInfos.get(theInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MBeanInfo convert(Class theInterface, MBeanAttributeInfo[] extraAttributeInfos) {
        MBeanInfo result = null;
        Class clazz = theInterface;
        synchronized (clazz) {
            result = this.find(theInterface);
            if (result == null) {
                MBeanInfo origInfo = JMXUtil.interfaceToMBeanInfo(theInterface);
                MBeanAttributeInfo[] origAttrInfos = origInfo.getAttributes();
                MBeanAttributeInfo[] attrInfos = extraAttributeInfos == null ? origAttrInfos : JMXUtil.mergeAttributeInfos(origAttrInfos, extraAttributeInfos);
                result = new MBeanInfo(origInfo.getClassName(), origInfo.getDescription(), this.convertAttributes(attrInfos), origInfo.getConstructors(), this.convertOperations(origInfo.getOperations()), origInfo.getNotifications());
                this.mConvertedInfos.put(theInterface, result);
            }
        }
        return result;
    }

    static {
        $assertionsDisabled = !MBeanInfoConverter.class.desiredAssertionStatus();
        INSTANCE = null;
    }
}

