/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.SystemInfo;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import com.sun.enterprise.management.support.Loader;
import com.sun.enterprise.management.support.LoaderOfOld;
import com.sun.enterprise.management.support.OldConfigTypes;
import com.sun.enterprise.management.support.OldTypeToJ2EETypeMapper;
import com.sun.enterprise.management.support.oldconfig.OldConfigProxies;
import com.sun.enterprise.management.support.oldconfig.OldProps;
import com.sun.enterprise.management.support.oldconfig.OldServersMBean;
import java.util.Collections;
import java.util.Set;
import javax.management.ObjectName;

class LoaderOfOldConfig
extends LoaderOfOld {
    private final boolean mSupportsClusters;
    private static final Set IGNORE_TYPES = Collections.unmodifiableSet(SetUtil.newSet(new String[]{"applications", "configs", "resources", "clusters", "servers", "thread-pools", "node-agents", "synchronization", "transactions-recovery", "ejb-timer-management", "transaction-service-manager", "olbadmin", "lb-configs", "lb-config", "lb-server-ref", "lb-cluster-ref", "lb-server-ref-health-checker", "lb-cluster-ref-health-checker"}));
    private static final Set NEEDS_SUPPORT = Collections.unmodifiableSet(SetUtil.newSet(new String[0]));
    private static final String OLD_SERVER_TYPE = "server";
    static /* synthetic */ Class class$com$sun$enterprise$management$support$LoaderOfOldConfig;

    LoaderOfOldConfig(Loader loader) {
        super(loader);
        SystemInfo systemInfo = this.getDomainRoot().getSystemInfo();
        this.mSupportsClusters = systemInfo.supportsFeature("SupportsClusters");
        if (NEEDS_SUPPORT.size() != 0) {
            this.getLogger().fine("Support for the following old config mbean types is not yet implemented: {" + SmartStringifier.toString(NEEDS_SUPPORT) + "}");
        }
    }

    private Set getOldServerConfigObjectNames() {
        ObjectName pattern = Util.newObjectNamePattern("com.sun.appserv", "type=server");
        Set<ObjectName> objectNames = this.getMBeanServer().queryNames(pattern, null);
        if (objectNames.size() == 0) {
            pattern = Util.newObjectNamePattern("ias", "type=server");
            objectNames = this.getMBeanServer().queryNames(pattern, null);
        }
        return objectNames;
    }

    protected Set findAllOldCandidates() {
        ObjectName pattern = null;
        Set<ObjectName> oldNames = null;
        pattern = Util.newObjectNamePattern("com.sun.appserv", "category=config");
        oldNames = this.getMBeanServer().queryNames(pattern, null);
        oldNames.addAll(this.getOldServerConfigObjectNames());
        return oldNames;
    }

    protected Set getNeedsSupport() {
        return NEEDS_SUPPORT;
    }

    protected Set getIgnoreTypes() {
        return IGNORE_TYPES;
    }

    private boolean isOldConfigMBean(ObjectName objectName) {
        boolean isOldConfigMBean = false;
        if (objectName.getDomain().equals("com.sun.appserv") && "config".equals(objectName.getKeyProperty("category"))) {
            String type = objectName.getKeyProperty("type");
            isOldConfigMBean = !this.getIgnoreTypes().contains(type);
        }
        return isOldConfigMBean;
    }

    protected boolean isOldMBean(ObjectName objectName) {
        return this.isOldConfigMBean(objectName);
    }

    protected ObjectName oldToNewObjectName(ObjectName oldObjectName) {
        this.trace("oldToNewObjectName: " + oldObjectName);
        MyOldTypes mapper = new MyOldTypes();
        OldProps oldProps = new OldProps(oldObjectName, mapper);
        String domainName = this.mLoader.getAMXJMXDomainName();
        String props = oldProps.getNewProps();
        ObjectName newObjectName = Util.newObjectName(domainName, props);
        return newObjectName;
    }

    private final class MyOldTypes
    implements OldTypeToJ2EETypeMapper {
        private final OldConfigTypes mOldTypes = OldConfigTypes.getInstance();
        private final OldServersMBean mOldServers;
        static final /* synthetic */ boolean $assertionsDisabled;

        public MyOldTypes() {
            this.mOldServers = OldConfigProxies.getInstance(LoaderOfOldConfig.this.getMBeanServer()).getOldServersMBean();
        }

        public String j2eeTypeToOldType(String j2eeType) {
            return this.mOldTypes.j2eeTypeToOldType(j2eeType);
        }

        private boolean isStandaloneServer(String name) {
            boolean isStandalone = true;
            if (LoaderOfOldConfig.this.mSupportsClusters) {
                ObjectName[] standaloneServerObjectNames = this.mOldServers.listUnclusteredServerInstances(false);
                isStandalone = false;
                for (int i = 0; i < standaloneServerObjectNames.length; ++i) {
                    if (!name.equals(Util.getName(standaloneServerObjectNames[i]))) continue;
                    isStandalone = true;
                    break;
                }
            }
            return isStandalone;
        }

        private String getServerJ2EEType(String name) {
            if (!$assertionsDisabled && name == null) {
                throw new AssertionError();
            }
            String j2eeType = this.isStandaloneServer(name) ? "X-StandaloneServerConfig" : "X-ClusteredServerConfig";
            return j2eeType;
        }

        public String oldTypeToJ2EEType(String oldType, ObjectName objectName) {
            String j2eeType = null;
            if (oldType.equals(objectName.getKeyProperty("type"))) {
                j2eeType = this.oldObjectNameToJ2EEType(objectName);
            } else if (oldType.equals(LoaderOfOldConfig.OLD_SERVER_TYPE)) {
                String name = objectName.getKeyProperty(LoaderOfOldConfig.OLD_SERVER_TYPE);
                if (!$assertionsDisabled && name == null) {
                    throw new AssertionError((Object)("no name in: " + objectName));
                }
                j2eeType = this.getServerJ2EEType(name);
            } else {
                j2eeType = this.mOldTypes.oldTypeToJ2EEType(oldType, objectName);
            }
            return j2eeType;
        }

        public String oldObjectNameToJ2EEType(ObjectName objectName) {
            String j2eeType = null;
            String oldType = objectName.getKeyProperty("type");
            if (oldType.equals(LoaderOfOldConfig.OLD_SERVER_TYPE)) {
                String name = objectName.getKeyProperty("name");
                j2eeType = this.getServerJ2EEType(name);
            } else {
                j2eeType = this.mOldTypes.oldTypeToJ2EEType(oldType);
            }
            if (j2eeType == null) {
                LoaderOfOldConfig.this.getLogger().fine("can't find j2eeType for: " + objectName);
            }
            return j2eeType;
        }

        static {
            $assertionsDisabled = !(class$com$sun$enterprise$management$support$LoaderOfOldConfig == null ? (class$com$sun$enterprise$management$support$LoaderOfOldConfig = LoaderOfOldConfig.class$("com.sun.enterprise.management.support.LoaderOfOldConfig")) : class$com$sun$enterprise$management$support$LoaderOfOldConfig).desiredAssertionStatus();
        }
    }
}

