/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.ListUtil;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.DelegateToMBeanDelegate;
import com.sun.enterprise.management.support.Loader;
import com.sun.enterprise.management.support.TypeInfo;
import com.sun.enterprise.management.support.TypeInfos;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

abstract class LoaderOfOld {
    protected final Loader mLoader;
    private static final Class[] EMPTY_SIG;
    private static final Class[] DELEGATE_SIG;
    static final /* synthetic */ boolean $assertionsDisabled;

    LoaderOfOld(Loader loader) {
        this.mLoader = loader;
    }

    protected abstract Set findAllOldCandidates();

    protected DomainRoot getDomainRoot() {
        return this.mLoader.getDomainRoot();
    }

    protected abstract Set getNeedsSupport();

    protected abstract Set getIgnoreTypes();

    protected abstract boolean isOldMBean(ObjectName var1);

    public final boolean shouldSync(ObjectName o) {
        boolean shouldSync = this.isOldMBean(o);
        if (shouldSync) {
            String type = o.getKeyProperty("type");
            if (this.getNeedsSupport().contains(type)) {
                shouldSync = false;
                this.getLogger().fine("Old MBean not yet supported (needs to be implemented),  type = " + type);
            }
        }
        return shouldSync;
    }

    public final List findAllOld() {
        Set all = this.findAllOldCandidates();
        HashSet<ObjectName> results = new HashSet<ObjectName>();
        Iterator iter = all.iterator();
        while (iter.hasNext()) {
            ObjectName objectName = (ObjectName)iter.next();
            if (!this.shouldSync(objectName)) continue;
            results.add(objectName);
        }
        return ListUtil.newListFromCollection(results);
    }

    protected abstract ObjectName oldToNewObjectName(ObjectName var1);

    protected final Map candidatesToMap(Set candidates, String key) {
        Iterator iter = candidates.iterator();
        HashMap<String, HashSet<ObjectName>> setMap = new HashMap<String, HashSet<ObjectName>>();
        while (iter.hasNext()) {
            ObjectName candidate = (ObjectName)iter.next();
            String keyValue = candidate.getKeyProperty(key);
            HashSet<ObjectName> typeSet = (HashSet<ObjectName>)setMap.get(keyValue);
            if (typeSet == null) {
                typeSet = new HashSet<ObjectName>();
                setMap.put(keyValue, typeSet);
            }
            typeSet.add(candidate);
        }
        return setMap;
    }

    protected final ObjectName registerNew(Object impl, ObjectName implObjectName, ObjectName oldObjectName) throws MBeanRegistrationException, InstanceAlreadyExistsException, NotCompliantMBeanException {
        if (impl == null) {
            throw new IllegalArgumentException("unable to create new impl for old: " + oldObjectName);
        }
        return this.mLoader.registerNew(impl, implObjectName, oldObjectName);
    }

    protected final void trace(Object o) {
        if (this.getLogger() != null) {
            this.getLogger().finer(o.toString());
        } else {
            System.out.println(o.toString());
        }
    }

    protected String toString(Object o) {
        return SmartStringifier.toString(o);
    }

    protected Logger getLogger() {
        return this.mLoader.getMBeanLogger();
    }

    public String getAMXJMXDomainName() {
        return this.mLoader.getAMXJMXDomainName();
    }

    public MBeanServer getMBeanServer() {
        return this.mLoader.getMBeanServer();
    }

    private Constructor findConstructor(Constructor[] constructors, Class[] sig) {
        Constructor constructor = null;
        for (int i = 0; i < constructors.length; ++i) {
            Class<?>[] csig = constructors[i].getParameterTypes();
            if (csig.length != sig.length) continue;
            constructor = constructors[i];
            for (int c = 0; c < sig.length; ++c) {
                if (csig[i].isAssignableFrom(sig[i])) continue;
                constructor = null;
                break;
            }
            if (constructor != null) break;
        }
        return constructor;
    }

    private Constructor getDelegateConstructor(Constructor[] constructors) {
        return this.findConstructor(constructors, DELEGATE_SIG);
    }

    private Constructor getEmptyConstructor(Constructor[] constructors) {
        return this.findConstructor(constructors, EMPTY_SIG);
    }

    protected Class getImplClass(ObjectName newObjectName, ObjectName oldObjectName) {
        String newType = Util.getJ2EEType(newObjectName);
        TypeInfo info = TypeInfos.getInstance().getInfo(newType);
        if (!$assertionsDisabled && info == null) {
            throw new AssertionError();
        }
        Class implClass = info.getImplClass();
        return implClass;
    }

    protected Object newImpl(ObjectName newObjectName, ObjectName oldObjectName) throws Exception {
        Object impl = null;
        Class implClass = this.getImplClass(newObjectName, oldObjectName);
        try {
            Constructor[] constructors = implClass.getConstructors();
            Constructor constructor = null;
            constructor = this.getDelegateConstructor(constructors);
            if (constructor != null) {
                DelegateToMBeanDelegate delegate = new DelegateToMBeanDelegate(this.mLoader.getMBeanServer(), oldObjectName);
                if (!$assertionsDisabled && delegate == null) {
                    throw new AssertionError();
                }
                impl = constructor.newInstance(delegate);
            } else if (this.getEmptyConstructor(constructors) != null) {
                impl = implClass.newInstance();
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        catch (Exception e) {
            System.err.println("Loader.newImpl: exception creating new impl:\n");
            ExceptionUtil.getRootCause(e).printStackTrace();
            System.out.println(ExceptionUtil.getRootCause(e).toString());
            System.out.println(ExceptionUtil.getRootCause(e).getMessage());
            throw e;
        }
        return impl;
    }

    protected ObjectName findExisting(Set newObjectNames, ObjectName oldObjectName) {
        ObjectName resultName = null;
        if (newObjectNames.size() == 1) {
            resultName = (ObjectName)SetUtil.getSingleton(newObjectNames);
        }
        return resultName;
    }

    private final synchronized ObjectName ensureNew(ObjectName newObjectName, ObjectName oldObjectName) throws MBeanRegistrationException, InstanceAlreadyExistsException, NotCompliantMBeanException, Exception {
        ObjectName pattern = Util.newObjectNamePattern(newObjectName);
        Set<ObjectName> objectNames = this.getMBeanServer().queryNames(pattern, null);
        ObjectName existingObjectName = this.findExisting(objectNames, oldObjectName);
        ObjectName resultName = null;
        if (existingObjectName == null) {
            Object impl = this.newImpl(newObjectName, oldObjectName);
            resultName = this.registerNew(impl, newObjectName, oldObjectName);
        } else {
            resultName = existingObjectName;
        }
        if (!$assertionsDisabled && resultName == null) {
            throw new AssertionError();
        }
        return resultName;
    }

    protected ObjectName syncWithOld(ObjectName oldObjectName) throws MBeanRegistrationException, InstanceAlreadyExistsException, NotCompliantMBeanException, Exception {
        ObjectName newObjectName = this.oldToNewObjectName(oldObjectName);
        this.trace("\nsyncWithOld: " + oldObjectName + " => " + newObjectName);
        ObjectName resultName = this.ensureNew(newObjectName, oldObjectName);
        return resultName;
    }

    static {
        $assertionsDisabled = !LoaderOfOld.class.desiredAssertionStatus();
        EMPTY_SIG = new Class[0];
        DELEGATE_SIG = new Class[]{Delegate.class};
    }
}

