/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.ArrayConversion;
import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.DelegateOwner;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public abstract class DelegateBase
implements Delegate {
    private Set mAttributeNames = null;
    private DelegateOwner mOwner;

    protected static void unimplementedOperation(String operation) {
        throw new UnsupportedOperationException(operation);
    }

    public DelegateBase() {
        this(null);
    }

    public DelegateBase(DelegateOwner owner) {
        this.mOwner = owner;
    }

    public void setOwner(DelegateOwner owner) {
        this.mOwner = owner;
    }

    public DelegateOwner getOwner() {
        return this.mOwner;
    }

    public AttributeList getAttributes(String[] attrNames) {
        AttributeList attrs = new AttributeList();
        for (int i = 0; i < attrNames.length; ++i) {
            try {
                String attrName = attrNames[i];
                Attribute attr = new Attribute(attrName, this.getAttribute(attrName));
                attrs.add(attr);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return attrs;
    }

    public AttributeList setAttributes(AttributeList attrs) {
        int numAttrs = attrs.size();
        AttributeList successList = new AttributeList();
        for (int i = 0; i < numAttrs; ++i) {
            Attribute attr = (Attribute)attrs.get(i);
            try {
                this.setAttribute(attr);
                successList.add(attr);
                continue;
            }
            catch (AttributeNotFoundException e) {
                continue;
            }
            catch (InvalidAttributeValueException e) {
                // empty catch block
            }
        }
        return successList;
    }

    private boolean typesMatch(String[] types, MBeanParameterInfo[] paramInfos) {
        boolean matches = false;
        if (types.length == paramInfos.length) {
            matches = true;
            for (int i = 0; i < types.length; ++i) {
                if (types[i].equals(paramInfos[i].getType())) continue;
                matches = false;
                break;
            }
        }
        return matches;
    }

    public synchronized boolean supportsAttribute(String attrName) {
        if (this.mAttributeNames == null) {
            Object[] attrNames = JMXUtil.getAttributeNames(this.getMBeanInfo().getAttributes());
            this.mAttributeNames = ArrayConversion.arrayToSet(attrNames);
        }
        return this.mAttributeNames.contains(attrName);
    }

    public boolean supportsOperation(String operationName, Object[] args, String[] types) {
        boolean supports = false;
        MBeanOperationInfo[] opInfos = this.getMBeanInfo().getOperations();
        for (int i = 0; i < opInfos.length; ++i) {
            MBeanOperationInfo info = opInfos[i];
            if (!info.getName().equals(operationName) || !this.typesMatch(types, info.getSignature())) continue;
            supports = true;
            break;
        }
        return supports;
    }
}

