/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.AllTypesMapper;
import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.Extra;
import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.base.Singleton;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.base.Utility;
import com.sun.appserv.management.client.ConnectionSource;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.NamedConfigElement;
import com.sun.appserv.management.util.jmx.Acronyms;
import com.sun.appserv.management.util.jmx.AttributeChangeNotificationBuilder;
import com.sun.appserv.management.util.jmx.AttributeNameMangler;
import com.sun.appserv.management.util.jmx.AttributeNameManglerImpl;
import com.sun.appserv.management.util.jmx.AttributeNameMapper;
import com.sun.appserv.management.util.jmx.AttributeNameMapperImpl;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.jmx.MBeanServerConnectionSource;
import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.util.misc.ThrowableMapper;
import com.sun.appserv.management.util.stringifier.ArrayStringifier;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import com.sun.enterprise.management.support.AMXMBeanLogger;
import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.DelegateInvocationHandler;
import com.sun.enterprise.management.support.DelegateOwner;
import com.sun.enterprise.management.support.Loader;
import com.sun.enterprise.management.support.LoaderMBean;
import com.sun.enterprise.management.support.MBeanImplBase;
import com.sun.enterprise.management.support.MBeanInfoConverter;
import com.sun.enterprise.management.support.MappedDelegate;
import com.sun.enterprise.management.support.ObjectNames;
import com.sun.enterprise.management.support.QueryMgrImpl;
import com.sun.enterprise.management.support.TypeInfo;
import com.sun.enterprise.management.support.TypeInfos;
import com.sun.enterprise.management.support.oldconfig.OldConfigProxies;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.management.ReflectionException;

public class AMXImplBase
extends MBeanImplBase
implements DynamicMBean,
MBeanRegistration,
AMX,
NotificationEmitter,
DelegateOwner {
    protected static final String GET = "get";
    protected static final String SET = "set";
    private Class mInterface;
    private MBeanInfo mMBeanInterfaceMBeanInfo;
    private ObjectName mCachedContainerObjectName;
    private boolean mEmitAttributeChangeNotifications;
    private QueryMgr mQueryMgr;
    private AMX mSelfProxy;
    private ConnectionSource mConnectionSource;
    private Delegate mSuppliedDelegate;
    private Delegate mDelegate;
    private AttributeNameMapper mAttributeNameMapper = null;
    private Map mAttributeInfos;
    private String mFullType;
    private final String mJ2EEType;
    private static MBeanAttributeInfo[] EXTRA_ATTRIBUTE_INFOS;
    private static final String[] EXTRA_REMOVALS;
    private static final MBeanNotificationInfo[] EMPTY_NOTIFICATIONS;
    private static final Class[] GETTER_SIG;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected static Class getInterface(String j2eeType) {
        return AllTypesMapper.getInstance().getInterfaceForType(j2eeType);
    }

    private String deduceJ2EEType(Class c) {
        String j2eeType = (String)ClassUtil.getFieldValue(c, "J2EE_TYPE");
        if (j2eeType == null) {
            String strippedName = StringUtil.stripSuffix(ClassUtil.stripPackageName(c.getName()), "Impl");
            j2eeType = c.getPackage().getName().endsWith(".j2ee") ? strippedName : "X-" + strippedName;
        }
        return j2eeType;
    }

    protected AMXImplBase(String j2eeType, Delegate delegate) {
        this(j2eeType, null, delegate);
    }

    protected AMXImplBase() {
        this(null, null, null);
    }

    protected AMXImplBase(Delegate delegate) {
        this(null, null, delegate);
    }

    private AMXImplBase(String j2eeTypeIn, Class theInterface, Delegate delegate) {
        if (delegate != null) {
            delegate.setOwner(this);
        }
        this.mJ2EEType = j2eeTypeIn == null ? this.deduceJ2EEType(this.getClass()) : j2eeTypeIn;
        Class clazz = this.mInterface = theInterface == null ? AMXImplBase.getInterface(this.mJ2EEType) : theInterface;
        if (!$assertionsDisabled && this.mInterface == null) {
            throw new AssertionError();
        }
        this.mCachedContainerObjectName = null;
        this.mEmitAttributeChangeNotifications = true;
        this.mQueryMgr = null;
        this.mSelfProxy = null;
        this.mSuppliedDelegate = delegate;
        this.mDelegate = null;
        this.mAttributeNameMapper = null;
        this.mAttributeInfos = null;
        this.mFullType = null;
        this.mMBeanInterfaceMBeanInfo = MBeanInfoConverter.getInstance().convert(this.mInterface, AMXImplBase.getExtraAttributeInfos());
    }

    public void delegateFailed(Throwable t) {
    }

    private static synchronized MBeanAttributeInfo[] getExtraAttributeInfos() {
        if (EXTRA_ATTRIBUTE_INFOS == null) {
            MBeanAttributeInfo[] extraInfos = JMXUtil.interfaceToMBeanInfo(Extra.class).getAttributes();
            Map m = JMXUtil.attributeInfosToMap(extraInfos);
            for (int i = 0; i < EXTRA_REMOVALS.length; ++i) {
                m.remove(EXTRA_REMOVALS[i]);
            }
            EXTRA_ATTRIBUTE_INFOS = new MBeanAttributeInfo[m.values().size()];
            m.values().toArray(EXTRA_ATTRIBUTE_INFOS);
        }
        return EXTRA_ATTRIBUTE_INFOS;
    }

    protected Logger createLogger() {
        return AMXMBeanLogger.createNew(this.getObjectNamePattern());
    }

    protected MBeanInfo getMBeanInfoFromInterface() {
        return this.mMBeanInterfaceMBeanInfo;
    }

    public boolean getMBeanInfoIsInvariant() {
        return true;
    }

    protected MBeanInfo removeUnsupported(MBeanInfo info) {
        return info;
    }

    public MBeanInfo getMBeanInfo() {
        MBeanInfo mbeanInfo = null;
        try {
            mbeanInfo = this.getMBeanInfoFromInterface();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        mbeanInfo = this.removeUnsupported(mbeanInfo);
        return mbeanInfo;
    }

    protected boolean shouldEmitNotifications() {
        return this.mEmitAttributeChangeNotifications && this.getNumListeners() != 0;
    }

    protected synchronized Delegate getDelegate() {
        return this.mDelegate;
    }

    protected void setDelegate(Delegate delegate) {
        this.mDelegate = delegate;
    }

    protected boolean haveDelegate() {
        return this.getDelegate() != null;
    }

    protected Object getDelegateProxy(Class theInterface) {
        return DelegateInvocationHandler.newProxyInstance(this.getDelegate(), theInterface);
    }

    public OldConfigProxies getOldConfigProxies() {
        return OldConfigProxies.getInstance(this.getMBeanServer());
    }

    protected AttributeNameMapper getAttributeNameMapper() {
        return this.mAttributeNameMapper;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return EMPTY_NOTIFICATIONS;
    }

    public MBeanNotificationInfo[] mergeNotificationInfos(MBeanNotificationInfo[] infos1, MBeanNotificationInfo[] infos2) {
        MBeanNotificationInfo[] infos = new MBeanNotificationInfo[infos1.length + infos2.length];
        System.arraycopy(infos1, 0, infos, 0, infos1.length);
        System.arraycopy(infos2, 0, infos, infos1.length, infos2.length);
        return infos;
    }

    protected String getKeyProperty(String key) {
        return this.getObjectName().getKeyProperty(key);
    }

    public ProxyFactory getProxyFactory() {
        if (!$assertionsDisabled && this.mConnectionSource == null) {
            throw new AssertionError();
        }
        return ProxyFactory.getInstance(this.mConnectionSource, true);
    }

    protected AMX getNamedChildProxy(String name) {
        ObjectName objectName = this.getNamedChildObjectName(name);
        AMX proxy = this.getProxyFactory().getProxy(objectName);
        return proxy;
    }

    protected static boolean isSingletonMBean(Class mbeanInterface) {
        return Singleton.class.isAssignableFrom(mbeanInterface);
    }

    protected static boolean isUtilityMBean(Class mbeanInterface) {
        return Utility.class.isAssignableFrom(mbeanInterface);
    }

    protected static boolean hasElementName(Class mbeanInterface) {
        return NamedConfigElement.class.isAssignableFrom(mbeanInterface);
    }

    public Container getFactoryContainer() {
        return (Container)this.getSelf();
    }

    public final ObjectName getContainerObjectName() {
        return this.getContainerObjectName(this.getObjectName());
    }

    public final Container getContainer() {
        ObjectName objectName = this.getContainerObjectName(this.getObjectName());
        return (Container)this.getProxyFactory().getProxy(objectName);
    }

    protected final synchronized ObjectName getContainerObjectName(ObjectName selfObjectName) {
        if (this.mCachedContainerObjectName == null && !this.getSelfJ2EEType().equals("X-DomainRoot")) {
            ObjectNames objectNames = ObjectNames.getInstance(this.getJMXDomain());
            try {
                this.mCachedContainerObjectName = objectNames.getContainerObjectName(this.getMBeanServer(), selfObjectName);
            }
            catch (InstanceNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.mCachedContainerObjectName;
    }

    public final ObjectName getObjectNamePattern() {
        ObjectName selfObjectName = this.getObjectName();
        Set requiredKeys = Util.getPatternKeys(this.getFullType());
        String requiredProps = JMXUtil.getProps(selfObjectName, requiredKeys, true);
        ObjectName pat = Util.newObjectNamePattern(selfObjectName.getDomain(), requiredProps);
        return pat;
    }

    public final Class getInterface() {
        return this.mInterface;
    }

    public final String getInterfaceName() {
        return this.getInterface().getName();
    }

    public final String[] getAttributeNames() {
        return SetUtil.toStringArray(this.getAttributeInfos().keySet());
    }

    protected final void unimplementedOperation(String operation) {
        this.logInfo("UNIMPLEMENTED OPERATION: " + operation + " in " + this.getObjectName());
        throw new UnsupportedOperationException(operation);
    }

    protected final Object unimplementedAttribute(String attrName) {
        this.logInfo("UNIMPLEMENTED ATTRIBUTE: " + attrName + " in " + this.getObjectName());
        return null;
    }

    protected final void impossible(Throwable t) {
        this.logSevere("AMXImplBase.impossible: " + t.getMessage());
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new RuntimeException(t);
    }

    private Object convertToClass(Object value, Class theClass) throws Exception {
        Object result = value;
        if (value instanceof String) {
            this.logFinest("convertToClass: converting" + value + " to " + " class " + result.getClass().getName());
            result = ClassUtil.InstantiateFromString(theClass, (String)value);
            this.logFinest("convertToClass: converted " + value + " to " + result + " of class " + result.getClass().getName());
        } else {
            this.getMBeanLogger().info("convertToClass: don't know how to convert: " + value.getClass().getName());
        }
        return result;
    }

    private Class getAttributeClass(String attributeName) throws ClassNotFoundException {
        MBeanAttributeInfo[] infos = this.getMBeanInfo().getAttributes();
        Class theClass = null;
        for (int i = 0; i < infos.length; ++i) {
            if (!infos[i].getName().equals(attributeName)) continue;
            theClass = ClassUtil.getClassFromName(infos[i].getType());
            break;
        }
        return theClass;
    }

    protected Object delegateGetAttribute(String name) throws Exception {
        Object value;
        Object result = value = this.getDelegate().getAttribute(name);
        if (value != null) {
            Class attrClass = this.getAttributeClass(name);
            if (attrClass != null) {
                if (ClassUtil.IsPrimitiveClass(attrClass)) {
                    attrClass = ClassUtil.PrimitiveClassToObjectClass(attrClass);
                }
                if (!attrClass.isAssignableFrom(value.getClass())) {
                    result = this.convertToClass(value, attrClass);
                }
            } else {
                this.getMBeanLogger().warning("AMXImplBase.delegateGetAttribute: Can't find class for attribute: " + name + "=" + value + " in object " + this.getObjectName());
            }
        }
        return result;
    }

    protected Object delegateGetAttributeNoThrow(String name) {
        try {
            Object value = this.delegateGetAttribute(name);
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void delegateSetAttribute(String name, Object value) throws AttributeNotFoundException, InvalidAttributeValueException {
        this.getDelegate().setAttribute(new Attribute(name, value));
    }

    protected void delegateSetAttributeNoThrow(String name, Object value) {
        try {
            this.delegateSetAttribute(name, value);
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
    }

    protected Object getAttributeNoThrow(String name) {
        Object result = null;
        try {
            result = this.getAttribute(name);
        }
        catch (Exception e) {
            throw new RuntimeException(new ThrowableMapper(e).map());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Map getAttributeInfos() {
        if (this.mAttributeInfos == null || !this.getMBeanInfoIsInvariant()) {
            AMXImplBase aMXImplBase = this;
            synchronized (aMXImplBase) {
                this.mAttributeInfos = JMXUtil.attributeInfosToMap(this.getMBeanInfo().getAttributes());
            }
        }
        return this.mAttributeInfos;
    }

    protected void clearAttributeInfos() {
        this.mAttributeInfos = null;
    }

    protected boolean isLegalAttribute(String name) {
        return this.getAttributeInfos().keySet().contains(name);
    }

    protected MBeanAttributeInfo getAttributeInfo(String name) {
        return (MBeanAttributeInfo)this.getAttributeInfos().get(name);
    }

    protected boolean isReadOnlyAttribute(String name) {
        return !this.getAttributeInfo(name).isWritable();
    }

    public Logger getLogger() {
        return this.getMBeanLogger();
    }

    public Object getAttribute(String name) throws AttributeNotFoundException {
        Object result = null;
        if (!this.isLegalAttribute(name)) {
            this.getMBeanLogger().fine("getAttribute: unknown Attribute " + name + ", legal Attributes are: " + AMXImplBase.toString(this.getAttributeInfos().keySet()));
            throw new AttributeNotFoundException(name);
        }
        try {
            result = this.getAttributeInternal(name);
        }
        catch (AttributeNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AttributeNotFoundException(name);
        }
        return result;
    }

    protected Object getAttributeInternal(String name) throws AttributeNotFoundException, ReflectionException, MBeanException {
        this.trace("getAttributeInternal: " + name);
        Object result = null;
        boolean handleManually = false;
        Method m = this.findGetter(name);
        if (m != null) {
            result = this.getAttributeByMethod(name, m);
            this.trace("getAttribute: " + name + " CALLED GETTER: " + m + " = " + result);
            handleManually = false;
        } else if (this.haveDelegate()) {
            this.trace("getAttribute: " + name + " HAVE DELEGATE ");
            if (this.getDelegate().supportsAttribute(name)) {
                this.trace("getAttribute: " + name + " CALLING DELEGATE ");
                try {
                    result = this.delegateGetAttribute(name);
                }
                catch (Exception e) {
                    this.trace("getAttribute: DELEGATE claims support, but fails: " + name);
                    handleManually = true;
                }
            } else {
                this.trace("getAttribute: " + name + " DELEGATE DOES NOT SUPPORT ");
                handleManually = true;
            }
        } else {
            handleManually = true;
        }
        if (handleManually) {
            this.trace("getAttribute: handle manually: " + name);
            try {
                result = this.getAttributeManually(name);
            }
            catch (AttributeNotFoundException e) {
                this.trace("getAttribute: " + name + " NOT FOUND ");
                throw e;
            }
        }
        return result;
    }

    public AttributeList getAttributes(String[] names) {
        this.trace("AMXImplBase.getAttributes: " + SmartStringifier.toString(names));
        AttributeList attrs = new AttributeList();
        for (int i = 0; i < names.length; ++i) {
            try {
                this.trace("%%% calling getAttribute: " + names[i] + " on " + this.getObjectName());
                Object value = this.getAttribute(names[i]);
                attrs.add(new Attribute(names[i], value));
                continue;
            }
            catch (Exception e) {
                this.trace("### AttributeNotFoundException: " + names[i]);
            }
        }
        return attrs;
    }

    private final void rethrowAttributeNotFound(Throwable t, String msg) throws AttributeNotFoundException {
        Throwable rootCause = ExceptionUtil.getRootCause(t);
        if (rootCause instanceof AttributeNotFoundException) {
            throw (AttributeNotFoundException)rootCause;
        }
        throw new AttributeNotFoundException(msg);
    }

    protected Object getAttributeByMethod(String attrName, Method m) throws AttributeNotFoundException {
        Object result = null;
        try {
            result = m.invoke((Object)this, null);
        }
        catch (InvocationTargetException e) {
            this.trace("InvocationTargetException: " + attrName + " by " + m);
            this.rethrowAttributeNotFound(e, attrName);
        }
        catch (IllegalAccessException e) {
            this.trace("ILLEGAL ACCESS TO: " + attrName + " by " + m);
            this.rethrowAttributeNotFound(e, attrName);
        }
        catch (Exception e) {
            this.trace("Exception: " + attrName + " by " + m);
            this.rethrowAttributeNotFound(e, attrName);
        }
        return result;
    }

    protected void setAttributeByMethod(Attribute attr, Method m) throws AttributeNotFoundException, InvalidAttributeValueException {
        try {
            m.invoke((Object)this, attr.getValue());
        }
        catch (InvocationTargetException e) {
            this.trace("setAttributeByMethod: InvocationTargetException: " + e);
            Throwable t = ExceptionUtil.getRootCause(e);
            if (t instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)t;
            }
            this.rethrowAttributeNotFound(e, attr.getName());
        }
        catch (IllegalAccessException e) {
            this.trace("setAttributeByMethod: IllegalAccessException: " + e);
            this.rethrowAttributeNotFound(e, attr.getName());
        }
        catch (Exception e) {
            this.trace("setAttributeByMethod: Exception: " + e);
            this.rethrowAttributeNotFound(e, attr.getName());
        }
    }

    protected Object getAttributeManually(String name) throws AttributeNotFoundException {
        throw new AttributeNotFoundException(name);
    }

    protected void setAttributeManually(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException {
        throw new AttributeNotFoundException(attr.getName());
    }

    public void setAttribute(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException {
        if (this.isReadOnlyAttribute(attr.getName())) {
            throw new IllegalArgumentException("Attribute is read-only: " + attr.getName());
        }
        try {
            this.setAttributeInternal(attr);
        }
        catch (AttributeNotFoundException e) {
            throw e;
        }
        catch (InvalidAttributeValueException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void setAttributeInternal(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException, ReflectionException, MBeanException {
        Object oldValue;
        this.trace("setAttribute: " + attr.getName() + " = " + attr.getValue());
        boolean handleManually = false;
        Method m = this.findSetter(attr);
        boolean shouldEmitNotifications = this.shouldEmitNotifications();
        Object object = oldValue = shouldEmitNotifications ? this.getAttribute(attr.getName()) : null;
        if (m != null) {
            this.setAttributeByMethod(attr, m);
        } else if (this.haveDelegate()) {
            if (this.getDelegate().supportsAttribute(attr.getName())) {
                try {
                    this.getDelegate().setAttribute(attr);
                }
                catch (JMException e) {
                    handleManually = true;
                }
            } else {
                handleManually = true;
            }
        } else {
            handleManually = true;
        }
        if (handleManually) {
            this.setAttributeManually(attr);
        }
        if (shouldEmitNotifications) {
            String attrType = this.getAttributeType(attr.getName());
            this.sendAttributeChangeNotification("", attrType, oldValue, attr);
        }
    }

    protected String getAttributeType(String attrName) {
        MBeanAttributeInfo info = JMXUtil.getMBeanAttributeInfo(this.getMBeanInfo(), attrName);
        return info.getType();
    }

    protected synchronized void sendAttributeChangeNotification(String msg, String attrType, Object oldValue, Attribute newAttr) {
        AttributeChangeNotificationBuilder builder = (AttributeChangeNotificationBuilder)this.getNotificationBuilder("jmx.attribute.change");
        AttributeChangeNotification n = builder.buildAttributeChange(msg, newAttr.getName(), attrType, oldValue, newAttr.getValue());
        this.sendNotification(n);
    }

    public AttributeList setAttributes(AttributeList attrs) {
        this.trace("AMXImplBase.setAttributes = " + SmartStringifier.toString(attrs));
        int numAttrs = attrs.size();
        AttributeList successList = new AttributeList();
        for (int i = 0; i < numAttrs; ++i) {
            Attribute attr = (Attribute)attrs.get(i);
            this.trace("setAttributes: " + attr.getName());
            try {
                this.setAttribute(attr);
                successList.add(attr);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return successList;
    }

    protected final Method findMethod(String methodName, Class[] sig) {
        return ClassUtil.findMethod(this.getClass(), methodName, sig);
    }

    protected final Method findGetter(String name) {
        String methodName = GET + name;
        Method m = this.findMethod(methodName, GETTER_SIG);
        if (m == null) {
            m = this.findMethod("is" + name, GETTER_SIG);
        }
        return m;
    }

    protected final Method findSetter(Attribute attr) {
        Object value = attr.getValue();
        Class<?> valueClass = value.getClass();
        String methodName = SET + attr.getName();
        Class[] sig = new Class[]{valueClass};
        Method setter = this.findMethod(methodName, sig);
        Class primitiveClass = ClassUtil.ObjectClassToPrimitiveClass(valueClass);
        if (setter == null && primitiveClass != valueClass) {
            sig[0] = primitiveClass;
            setter = this.findMethod(methodName, sig);
        }
        return setter;
    }

    protected Object invokeManually(String operationName, Object[] args, String[] types) throws MBeanException, ReflectionException, NoSuchMethodException {
        throw new NoSuchMethodException("no operation " + operationName + AMXImplBase.toString(types) + " in " + this.getObjectName());
    }

    protected void handleException(Exception e) throws MBeanException, ReflectionException {
        ThrowableMapper mapper = new ThrowableMapper(e);
        Throwable mapped = mapper.map();
        if (mapped instanceof ReflectionException) {
            throw (ReflectionException)mapped;
        }
        if (mapped instanceof MBeanException) {
            throw (MBeanException)mapped;
        }
        if (!(mapped instanceof Exception)) {
            Exception wrapper = new Exception(mapped);
            throw new MBeanException(wrapper);
        }
        throw new MBeanException((Exception)mapped);
    }

    protected void handleGetAttributeException(Exception e) throws MBeanException, ReflectionException, AttributeNotFoundException {
        if (e instanceof AttributeNotFoundException) {
            throw (AttributeNotFoundException)e;
        }
        this.handleException(e);
    }

    protected void handleInvokeThrowable(Exception e) throws MBeanException, ReflectionException {
        this.handleException(e);
    }

    public final Object invoke(String operationName, Object[] args, String[] types) throws MBeanException, ReflectionException {
        Object result = null;
        boolean unimplemented = false;
        this.trace("# AMXImplBase.invoke: " + operationName + SmartStringifier.toString(types) + " on " + this.getObjectName());
        try {
            Class[] signature = ClassUtil.signatureFromClassnames(types);
            Method m = this.findMethod(operationName, signature);
            if (m != null) {
                this.trace("invoking: " + m);
                result = m.invoke((Object)this, args);
            } else if (this.haveDelegate() && this.getDelegate().supportsOperation(operationName, args, types)) {
                this.trace("AMXImplBase.invoke: calling delegate for " + operationName);
                result = this.getDelegate().invoke(operationName, args, types);
            } else {
                result = this.invokeManually(operationName, args, types);
            }
        }
        catch (Exception e) {
            this.handleInvokeThrowable(e);
        }
        return result;
    }

    protected TypeInfo getTypeInfo(String j2eeType) {
        return TypeInfos.getInstance().getInfo(j2eeType);
    }

    protected String getSelfJ2EEType() {
        return this.mJ2EEType;
    }

    protected String getSelfName() {
        return Util.getName(this.getObjectName());
    }

    protected TypeInfo getSelfTypeInfo() {
        return this.getTypeInfo(this.getSelfJ2EEType());
    }

    private boolean isContainer() {
        return Container.class.isAssignableFrom(this.getInterface());
    }

    protected Set getChildJ2EETypes() {
        return this.getSelfTypeInfo().getChildJ2EETypes();
    }

    protected Set getFauxChildTypes() {
        return Collections.EMPTY_SET;
    }

    public Set getContaineeJ2EETypes() {
        if (!this.isContainer()) {
            AttributeNotFoundException e = new AttributeNotFoundException("ContaineeJ2EETypes");
            throw new RuntimeException(e);
        }
        Set fauxTypes = this.getFauxChildTypes();
        Set officialTypes = this.getSelfTypeInfo().getContaineeJ2EETypes();
        return fauxTypes.size() == 0 ? officialTypes : SetUtil.newSet(fauxTypes, officialTypes);
    }

    protected String getChildJ2EEType() {
        Set types = this.getChildJ2EETypes();
        if (types.size() != 1) {
            this.trace("getChildJ2EEType failing on: " + this.getObjectName() + ", got this many children: " + types.size());
            throw new IllegalArgumentException(SmartStringifier.toString(types));
        }
        return (String)SetUtil.getSingleton(types);
    }

    protected ObjectName getProgenyObjectName(String j2eeType, String name) {
        Container container = this.getContainer();
        AMX containee = container.getContainee(j2eeType, name);
        if (containee == null) {
            throw new IllegalArgumentException("Not containee found: " + j2eeType + "=" + name);
        }
        return Util.getObjectName(containee);
    }

    protected void registerSelfMgrChild(TypeInfo childInfo) throws Exception {
        String childJ2EEType = childInfo.getJ2EEType();
        Class implClass = childInfo.getImplClass();
        ObjectNames objectNames = ObjectNames.getInstance(this.getJMXDomain());
        ObjectName childObjectName = objectNames.buildContaineeObjectName(this.getObjectName(), this.getFullType(), childJ2EEType);
        Object impl = implClass.newInstance();
        this.registerMBean(impl, childObjectName);
    }

    protected void unregisterSelfMgrChildren() {
        TypeInfo selfInfo = this.getSelfTypeInfo();
        Set childTypesSet = selfInfo.getContaineeJ2EETypes();
        String[] childTypes = SetUtil.toStringArray(childTypesSet);
        MBeanServer mbeanServer = this.getMBeanServer();
        for (int i = 0; i < childTypes.length; ++i) {
            String childType = childTypes[i];
            this.trace("unregisterSelfMgrChildren: processing type: " + childType);
            TypeInfo childInfo = this.getTypeInfo(childType);
            Class childInterface = childInfo.getInterface();
            if (AMXImplBase.isSingletonMBean(childInterface) || AMXImplBase.isUtilityMBean(childInterface)) {
                ObjectName containeeObjectName = this.getContaineeObjectName(childType);
                try {
                    mbeanServer.unregisterMBean(containeeObjectName);
                    this.trace("unregisterSelfMgrChildren: " + containeeObjectName + " is unregistered");
                }
                catch (InstanceNotFoundException infe) {
                    this.logWarning("unregisterSelfMgrChildren: " + infe.getMessage());
                }
                catch (Exception e) {
                    this.logSevere("unregisterSelfMgrChildren: " + ExceptionUtil.getRootCause(e).getMessage());
                }
                continue;
            }
            this.trace("unregisterSelfMgrChildren: skipping: " + childInterface.getName());
        }
    }

    protected void registerSelfMgrChildren() {
        TypeInfo selfInfo = this.getSelfTypeInfo();
        Set childTypesSet = selfInfo.getContaineeJ2EETypes();
        this.trace("registerSelfMgrChildren for " + this.getSelfJ2EEType() + ": " + AMXImplBase.toString(childTypesSet));
        if (childTypesSet.size() != 0) {
            this.trace("registerSelfMgrChildren: child types = " + AMXImplBase.toString(childTypesSet));
        } else {
            this.trace("no child types for: " + AMXImplBase.quote(this.getObjectName()));
        }
        String[] childTypes = SetUtil.toStringArray(childTypesSet);
        for (int i = 0; i < childTypes.length; ++i) {
            String childType = childTypes[i];
            this.trace("registerSelfMgrChildren: processing type: " + childType);
            TypeInfo childInfo = this.getTypeInfo(childType);
            Class childInterface = childInfo.getInterface();
            if (AMXImplBase.isSingletonMBean(childInterface) || AMXImplBase.isUtilityMBean(childInterface)) {
                try {
                    this.registerSelfMgrChild(childInfo);
                }
                catch (InstantiationException e) {
                    this.trace("InstantiationException for child of type: " + childInfo.getJ2EEType() + " = " + e.getMessage());
                    e.printStackTrace();
                    Throwable t = ExceptionUtil.getRootCause(e);
                    if (t != e && t != null) {
                        this.trace("InstantiationException: root cause msg =" + t.getMessage());
                        this.trace(ExceptionUtil.getStackTrace(t));
                        continue;
                    }
                    this.trace(ExceptionUtil.getStackTrace(ExceptionUtil.getRootCause(e)));
                }
                catch (Exception e) {
                    this.trace("Can't create child, info = " + childInfo + "\n" + e + "\n\n");
                    e.printStackTrace();
                }
                continue;
            }
            this.trace("registerSelfMgrChildren: skipping: " + childInterface.getName());
        }
    }

    protected final void registerChildren() {
        this.registerSelfMgrChildren();
    }

    public String getGroup() {
        return "other";
    }

    public String getName() {
        return Util.getName(this.getObjectName());
    }

    public String getJ2EEType() {
        return Util.getJ2EEType(this.getObjectName());
    }

    protected static String getFullType(ObjectName partialSelfObjectName) {
        String selfJ2EEType = Util.getJ2EEType(partialSelfObjectName);
        TypeInfos typeInfos = TypeInfos.getInstance();
        TypeInfo info = typeInfos.getInfo(selfJ2EEType);
        Object[] chain = typeInfos.getJ2EETypeChain(partialSelfObjectName);
        String fullType = ArrayStringifier.stringify(chain, ".");
        return fullType;
    }

    public final String getFullType() {
        if (!$assertionsDisabled && this.mFullType == null) {
            throw new AssertionError((Object)"******************************************************");
        }
        return this.mFullType;
    }

    protected ObjectName preRegisterModifyName(MBeanServer server, ObjectName nameIn) {
        this.mFullType = AMXImplBase.getFullType(nameIn);
        String ancestorProps = "";
        String[] fullTypeArray = Util.getTypeArray(this.mFullType);
        for (int i = 0; i < fullTypeArray.length - 1; ++i) {
            String key = fullTypeArray[i];
            if (nameIn.getKeyProperty(key) != null) continue;
            String name = ObjectNames.getSingletonName(key);
            String prop = Util.makeProp(key, name);
            ancestorProps = Util.concatenateProps(ancestorProps, prop);
        }
        String props = ancestorProps;
        String newName = Util.concatenateProps(nameIn.toString(), props);
        ObjectName nameOut = Util.newObjectName(newName);
        return nameOut;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName nameIn) throws Exception {
        ObjectName nameFromSuper = super.preRegister(server, nameIn);
        this.mConnectionSource = new MBeanServerConnectionSource(server);
        this.mSelfObjectName = this.preRegisterModifyName(server, nameFromSuper);
        return this.mSelfObjectName;
    }

    protected final AttributeNameMangler createAttributeNameMangler() {
        return new AttributeNameManglerImpl(true, Acronyms.getMap());
    }

    protected final AttributeNameMapper createAttributeNameMapper() {
        AttributeNameMangler mangler = this.createAttributeNameMangler();
        return new AttributeNameMapperImpl(mangler);
    }

    protected void addCustomMappings(AttributeNameMapper mapper) {
    }

    protected final Delegate wrapSuppliedDelegate(Delegate delegate) {
        this.mAttributeNameMapper = this.createAttributeNameMapper();
        this.addCustomMappings(this.mAttributeNameMapper);
        MappedDelegate result = new MappedDelegate(this.mSuppliedDelegate, this.mAttributeNameMapper);
        return result;
    }

    private final void implCheck() {
        boolean isContainer = this.isContainer();
        String j2eeType = this.getSelfJ2EEType();
        TypeInfo selfInfo = TypeInfos.getInstance().getInfo(j2eeType);
        Set nonChildren = selfInfo.getNonChildJ2EETypes();
        Set children = selfInfo.getChildJ2EETypes();
        if (isContainer) {
            if (!$assertionsDisabled && nonChildren.size() == 0 && children.size() == 0) {
                throw new AssertionError((Object)("ERROR: is Container but contains no children or containees " + j2eeType));
            }
        } else {
            if (!$assertionsDisabled && nonChildren.size() != 0) {
                throw new AssertionError((Object)("ERROR: not a Container: " + j2eeType + " but contains types: " + AMXImplBase.toString(nonChildren)));
            }
            if (!$assertionsDisabled && children.size() != 0) {
                throw new AssertionError((Object)("ERROR: not a Container: " + j2eeType + " but contains children: " + AMXImplBase.toString(children)));
            }
        }
    }

    public void postRegister(Boolean registrationSucceeded) {
        super.postRegister(registrationSucceeded);
        if (registrationSucceeded.booleanValue()) {
            if (this.mSuppliedDelegate != null) {
                this.mDelegate = this.wrapSuppliedDelegate(this.mSuppliedDelegate);
            }
            this.registerChildren();
            this.implCheck();
        }
    }

    public void preDeregister() throws Exception {
        this.unregisterSelfMgrChildren();
    }

    public final ObjectName getDomainRootObjectName() {
        return Util.getObjectName(this.getDomainRoot());
    }

    public synchronized ObjectName getQueryMgrObjectName() {
        ObjectName objectName = null;
        if (this.mQueryMgr != null) {
            objectName = Util.getObjectName(this.mQueryMgr);
        } else {
            MBeanServer server = this.getMBeanServer();
            String domainName = this.getObjectName().getDomain();
            objectName = QueryMgrImpl.querySingletonJ2EETypeObjectName(server, domainName, "X-QueryMgr");
        }
        if (!$assertionsDisabled && objectName == null) {
            throw new AssertionError((Object)"getQueryMgrObjectName failed");
        }
        return objectName;
    }

    protected ConnectionSource getMBeanServerConnectionSource() {
        return this.mConnectionSource;
    }

    public final LoaderMBean getLoader() {
        return Loader.getLoader(this.getMBeanServer());
    }

    protected final synchronized AMX getSelf() {
        if (this.mSelfProxy == null) {
            ObjectName selfObjectName = this.getObjectName();
            if (!$assertionsDisabled && selfObjectName == null) {
                throw new AssertionError();
            }
            this.mSelfProxy = this.getProxyFactory().getProxy(selfObjectName);
            if (!$assertionsDisabled && this.mSelfProxy == null) {
                throw new AssertionError();
            }
        }
        return this.mSelfProxy;
    }

    public final DomainRoot getDomainRoot() {
        return this.getProxyFactory().getDomainRoot();
    }

    protected final synchronized QueryMgr getQueryMgr() {
        if (this.mQueryMgr == null) {
            ObjectName objectName = this.getQueryMgrObjectName();
            ProxyFactory factory = this.getProxyFactory();
            AMX temp = factory.getProxy(objectName);
            this.mQueryMgr = (QueryMgr)temp;
        }
        return this.mQueryMgr;
    }

    protected final String[] getNamePropertyValues(Set objectNameSet) {
        return JMXUtil.getKeyProperty("name", objectNameSet);
    }

    protected final String[] getChildNames() {
        return this.getContaineeNamesOfType(this.getChildJ2EEType());
    }

    protected final String[] getContaineeNamesOfType(String j2eeType) {
        Set objectNames = this.getContaineeObjectNameSet(j2eeType);
        return this.getNamePropertyValues(objectNames);
    }

    public final Set getContaineeObjectNameSet() {
        String selfType = this.getSelfJ2EEType();
        HashSet allChildren = new HashSet();
        Set containedTypes = SetUtil.newSet(this.getChildJ2EETypes(), this.getContaineeJ2EETypes());
        Iterator iter = containedTypes.iterator();
        while (iter.hasNext()) {
            String childJ2eeType = (String)iter.next();
            Set childrenOfType = this.getContaineeObjectNameSet(childJ2eeType);
            allChildren.addAll(childrenOfType);
        }
        return allChildren;
    }

    protected ObjectName getOnlyChildObjectName() {
        return this.getContaineeObjectName(this.getChildJ2EEType());
    }

    private static String makeType(String parentType, String subType) {
        String result = null;
        result = parentType == null || parentType.length() == 0 ? subType : parentType + "." + subType;
        return result;
    }

    protected Set getFauxContaineeObjectNameSet(String childJ2EEType, String nullProps) {
        if (!$assertionsDisabled && !this.getFauxChildTypes().contains(childJ2EEType)) {
            throw new AssertionError();
        }
        String selfProp = Util.makeProp(this.getJ2EEType(), this.getSelfName());
        String childJ2EETypeProp = Util.makeJ2EETypeProp(childJ2EEType);
        String props = Util.concatenateProps(selfProp, nullProps, childJ2EETypeProp);
        Set candidates = this.getQueryMgr().queryPropsSet(props);
        Set objectNames = Util.toObjectNames(candidates);
        return objectNames;
    }

    public Set getContaineeObjectNameSet(String childJ2EEType) {
        TypeInfos infos = TypeInfos.getInstance();
        TypeInfo info = infos.getInfo(childJ2EEType);
        String props = Util.makeJ2EETypeProp(childJ2EEType);
        QueryExp expr = null;
        if (info.isSubType()) {
            String selfFullType = this.getFullType();
            String childFullType = AMXImplBase.makeType(selfFullType, childJ2EEType);
            String selfProps = Util.getFullTypeProps(this.getObjectName(), this.getFullType());
            props = Util.concatenateProps(props, selfProps);
            expr = Query.eq(Query.attr("FullType"), Query.value(childFullType));
        } else {
            expr = null;
        }
        ObjectName pattern = JMXUtil.newObjectNamePattern(this.getObjectName().getDomain(), props);
        Set<ObjectName> candidates = this.getMBeanServer().queryNames(pattern, expr);
        return candidates;
    }

    public final Set getContaineeObjectNameSet(Set j2eeTypes) {
        HashSet all = new HashSet();
        Iterator iter = j2eeTypes.iterator();
        while (iter.hasNext()) {
            String j2eeType = (String)iter.next();
            Set objectNames = this.getContaineeObjectNameSet(j2eeType);
            all.addAll(objectNames);
        }
        return all;
    }

    public final ObjectName getContaineeObjectName(String j2eeType) {
        Set children = this.getContaineeObjectNameSet(j2eeType);
        ObjectName result = null;
        if (children.size() == 1) {
            result = (ObjectName)SetUtil.getSingleton(children);
        } else if (children.size() == 0) {
            this.trace("AMXImplBase.getContaineeObjectName: no children of type " + j2eeType);
            result = null;
        } else {
            this.trace("AMXImplBase.getContaineeObjectName: " + j2eeType + " impossible");
            this.impossible(new UnsupportedOperationException("getContaineeObjectName"));
        }
        return result;
    }

    protected final ObjectName getNamedChildObjectName(String name) {
        this.trace("\nAMXImplBase.getNamedContaineeObjectName: Looking for " + name + " in " + AMXImplBase.quote(this.getObjectName()));
        return this.getContaineeObjectName(this.getChildJ2EEType(), name);
    }

    public final ObjectName getContaineeObjectName(String j2eeType, String name) {
        Set candidates = this.getContaineeObjectNameSet(j2eeType);
        Set matching = JMXUtil.findByProperty(candidates, "name", name);
        ObjectName result = matching.size() == 0 ? null : (ObjectName)SetUtil.getSingleton(matching);
        return result;
    }

    public Map getMultiContaineeObjectNameMap(Set j2eeTypesIn) {
        Set j2eeTypes = j2eeTypesIn == null ? this.getContaineeJ2EETypes() : j2eeTypesIn;
        Iterator j2eeTypesIter = j2eeTypes.iterator();
        HashMap<String, Map> m = new HashMap<String, Map>();
        while (j2eeTypesIter.hasNext()) {
            String j2eeType = (String)j2eeTypesIter.next();
            Map nameMap = this.getContaineeObjectNameMap(j2eeType);
            if (nameMap.keySet().size() == 0) continue;
            m.put(j2eeType, nameMap);
        }
        return m;
    }

    public final Map getContaineeObjectNameMap(String j2eeType) {
        if (!this.getContaineeJ2EETypes().contains(j2eeType)) {
            throw new IllegalArgumentException(this.getObjectName() + "does not contain j2eeType: " + j2eeType);
        }
        Set objectNames = this.getContaineeObjectNameSet(j2eeType);
        Map result = Collections.EMPTY_MAP;
        if (objectNames.size() != 0) {
            result = Util.createObjectNameMap(objectNames);
        }
        if (!$assertionsDisabled && result.keySet().size() != objectNames.size()) {
            throw new AssertionError();
        }
        return result;
    }

    public Set getByNameContaineeObjectNameSet(Set j2eeTypes, String name) {
        Iterator iter = this.getContaineeObjectNameSet(j2eeTypes).iterator();
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        while (iter.hasNext()) {
            ObjectName objectName = (ObjectName)iter.next();
            if (!Util.getName(objectName).equals(name)) continue;
            result.add(objectName);
        }
        return result;
    }

    protected Object getAttribute(ObjectName objectName, String name) throws AttributeNotFoundException, InstanceNotFoundException, ReflectionException, MBeanException {
        return this.getMBeanServer().getAttribute(objectName, name);
    }

    protected AttributeList getAttributes(ObjectName objectName, String[] names) throws AttributeNotFoundException, InstanceNotFoundException, ReflectionException, MBeanException {
        return this.getMBeanServer().getAttributes(objectName, names);
    }

    protected void setAttribute(ObjectName objectName, Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException, InstanceNotFoundException, ReflectionException, MBeanException {
        this.getMBeanServer().setAttribute(objectName, attr);
    }

    protected AttributeList setAttributes(ObjectName objectName, AttributeList attrs) throws AttributeNotFoundException, InvalidAttributeValueException, InstanceNotFoundException, ReflectionException, MBeanException {
        return this.getMBeanServer().setAttributes(objectName, attrs);
    }

    protected ObjectName registerMBean(Object mbean, ObjectName name) throws MalformedObjectNameException, InstanceAlreadyExistsException, NotCompliantMBeanException, MBeanRegistrationException {
        return this.getMBeanServer().registerMBean(mbean, name).getObjectName();
    }

    protected String stringify(Object o) {
        return SmartStringifier.toString(o);
    }

    public String getConfigName() {
        return this.getKeyProperty("X-ConfigConfig");
    }

    public void sendConfigCreatedNotification(ObjectName configObjectName) {
        this.sendNotification("com.sun.appserv.management.config.ConfigCreated", "ConfigObjectName", configObjectName);
    }

    public void sendConfigRemovedNotification(ObjectName configObjectName) {
        this.sendNotification("com.sun.appserv.management.config.ConfigRemoved", "ConfigObjectName", configObjectName);
    }

    static {
        $assertionsDisabled = !AMXImplBase.class.desiredAssertionStatus();
        EXTRA_ATTRIBUTE_INFOS = null;
        EXTRA_REMOVALS = new String[]{"ProxyFactory", "ConnectionSource", "MBeanInfo", "AllAttributes"};
        EMPTY_NOTIFICATIONS = new MBeanNotificationInfo[0];
        GETTER_SIG = new Class[0];
    }
}

