/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.j2ee;

import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.enterprise.ManagementObjectManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.mbeans.DomainStatusHelper;
import com.sun.enterprise.admin.mbeans.DomainStatusMBean;
import com.sun.enterprise.management.j2ee.J2EEServerImpl;
import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.DelegateToMBeanDelegate;
import com.sun.enterprise.management.support.DummyDelegate;
import com.sun.enterprise.management.support.QueryMgrImpl;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class DASJ2EEServerImpl
extends J2EEServerImpl
implements NotificationListener {
    private Delegate delegate = DummyDelegate.INSTANCE;
    private static final Class[] DOMAIN_STATUS_INTERFACES;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DASJ2EEServerImpl() {
        super("J2EEServer", DummyDelegate.INSTANCE);
    }

    protected DomainStatusMBean getDomainStatus() {
        DomainStatusMBean domainStatus = null;
        try {
            MBeanServer mbeanServer = this.getMBeanServer();
            Set candidates = QueryMgrImpl.queryPatternObjectNameSet(mbeanServer, JMXUtil.newObjectNamePattern("*", "name=domain-status"));
            ObjectName on = (ObjectName)SetUtil.getSingleton(candidates);
            domainStatus = (DomainStatusMBean)MBeanServerInvocationHandler.newProxyInstance(mbeanServer, on, DomainStatusMBean.class, false);
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtil.getRootCause(e);
            this.getMBeanLogger().warning(rootCause.toString() + "\n" + ExceptionUtil.getStackTrace(rootCause));
        }
        return domainStatus;
    }

    private boolean remoteServerIsRunning() {
        return 1 == this.getstate();
    }

    private boolean remoteServerIsStartable() {
        int cState = this.getstate();
        return 3 == cState || 4 == cState;
    }

    private boolean remoteServerIsStoppable() {
        int cState = this.getstate();
        return 0 == cState || 1 == cState || 4 == cState;
    }

    public void handleNotification(Notification notif, Object obj) {
        Map map;
        String serverName;
        String notifType = notif.getType();
        if (notifType.equals("com.sun.appserv.management.status.ServerStatusChanged") && (serverName = (String)(map = (Map)notif.getUserData()).get("ServerName")).equals(this.getServerName())) {
            this.setDelegate();
        }
    }

    private void setDelegate() {
        if (this.remoteServerIsRunning()) {
            try {
                ManagementObjectManager mgmtObjManager = Switch.getSwitch().getManagementObjectManager();
                String strON = mgmtObjManager.getServerBaseON(false, this.getServerName());
                MBeanServerConnection remoteConn = this.getDomainStatus().getServerMBeanServerConnection(this.getServerName());
                ObjectName onPattern = new ObjectName(strON + ",*");
                Set<ObjectName> names = remoteConn.queryNames(onPattern, null);
                if (!$assertionsDisabled && names.size() != 1) {
                    throw new AssertionError();
                }
                ObjectName serverON = (ObjectName)SetUtil.getSingleton(names);
                DelegateToMBeanDelegate delegate = new DelegateToMBeanDelegate(remoteConn, serverON);
                this.setDelegate(delegate);
                this.setstartTime(System.currentTimeMillis());
            }
            catch (Exception e) {
                Throwable rootCause = ExceptionUtil.getRootCause(e);
                this.getMBeanLogger().warning(rootCause.toString() + "\n" + ExceptionUtil.getStackTrace(rootCause));
            }
        } else {
            this.setDelegate(DummyDelegate.INSTANCE);
            this.setstartTime(0L);
        }
    }

    public void postRegister(Boolean registrationDone) {
        super.postRegister(registrationDone);
        if (registrationDone.booleanValue()) {
            this.setstartTime(0L);
            this.setDelegate();
        }
    }

    protected String getServerName() {
        return this.getSelfName();
    }

    public boolean isstateManageable() {
        return true;
    }

    public int getstate() {
        try {
            return this.getDomainStatus().getstate(this.getServerName());
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtil.getRootCause(e);
            this.getMBeanLogger().warning(rootCause.toString() + "\n" + ExceptionUtil.getStackTrace(rootCause));
            return 4;
        }
    }

    public void start() {
        if (!this.remoteServerIsStartable()) {
            throw new RuntimeException("server is not in a startable state");
        }
        this.startRemoteServer();
    }

    public void startRecursive() {
        this.start();
    }

    public void stop() {
        if (!this.remoteServerIsStoppable()) {
            throw new RuntimeException("server is not in a stoppable state");
        }
        this.stopRemoteServer();
    }

    public MBeanInfo getMBeanInfo() {
        MBeanInfo superMBeanInfo = super.getMBeanInfo();
        if (this.delegate != null) {
            try {
                DummyDelegate dd = (DummyDelegate)this.delegate;
                MBeanInfo mbeanInfo = new MBeanInfo(superMBeanInfo.getClassName(), superMBeanInfo.getDescription(), this.mergeAttributeInfos(superMBeanInfo.getAttributes(), this.getMBeanAttributeInfo()), superMBeanInfo.getConstructors(), this.mergeOperationInfos(superMBeanInfo.getOperations(), this.getMBeanOperationInfo()), superMBeanInfo.getNotifications());
                return mbeanInfo;
            }
            catch (ClassCastException cce) {
                return superMBeanInfo;
            }
        }
        return superMBeanInfo;
    }

    private MBeanAttributeInfo[] mergeAttributeInfos(MBeanAttributeInfo[] infos1, MBeanAttributeInfo[] infos2) {
        MBeanAttributeInfo[] infos = new MBeanAttributeInfo[infos1.length + infos2.length];
        System.arraycopy(infos1, 0, infos, 0, infos1.length);
        System.arraycopy(infos2, 0, infos, infos1.length, infos2.length);
        return infos;
    }

    private MBeanAttributeInfo[] getMBeanAttributeInfo() {
        MBeanAttributeInfo[] dAttributes = new MBeanAttributeInfo[]{new MBeanAttributeInfo("state", "java.lang.Integer", "server state", true, false, false)};
        return dAttributes;
    }

    private MBeanOperationInfo[] mergeOperationInfos(MBeanOperationInfo[] infos1, MBeanOperationInfo[] infos2) {
        MBeanOperationInfo[] infos = new MBeanOperationInfo[infos1.length + infos2.length];
        System.arraycopy(infos1, 0, infos, 0, infos1.length);
        System.arraycopy(infos2, 0, infos, infos1.length, infos2.length);
        return infos;
    }

    private MBeanOperationInfo[] getMBeanOperationInfo() {
        MBeanOperationInfo[] dOperations = new MBeanOperationInfo[]{new MBeanOperationInfo("start", "start server instance", null, "void", 1), new MBeanOperationInfo("stop", "stop server instance", null, "void", 1), new MBeanOperationInfo("startRecursive", "start server instance", null, "void", 1)};
        return dOperations;
    }

    private void startRemoteServer() {
        try {
            ObjectName on = DomainStatusHelper.getServersConfigObjectName();
            MBeanServer server = this.getMBeanServer();
            Object[] params = new Object[]{this.getServerName()};
            String[] signature = new String[]{"java.lang.String"};
            server.invoke(on, "startServerInstance", params, signature);
        }
        catch (MalformedObjectNameException mfone) {
            Throwable rootCause = ExceptionUtil.getRootCause(mfone);
            this.getMBeanLogger().warning(rootCause.toString() + "\n" + ExceptionUtil.getStackTrace(rootCause));
            throw new RuntimeException(mfone);
        }
        catch (InstanceNotFoundException infe) {
            Throwable rootCause = ExceptionUtil.getRootCause(infe);
            this.getMBeanLogger().warning(rootCause.toString() + "\n" + ExceptionUtil.getStackTrace(rootCause));
            throw new RuntimeException(infe);
        }
        catch (MBeanException mbe) {
            Throwable rootCause = ExceptionUtil.getRootCause(mbe);
            this.getMBeanLogger().warning(rootCause.toString() + "\n" + ExceptionUtil.getStackTrace(rootCause));
            throw new RuntimeException(mbe);
        }
        catch (ReflectionException rfe) {
            Throwable rootCause = ExceptionUtil.getRootCause(rfe);
            this.getMBeanLogger().warning(rootCause.toString() + "\n" + ExceptionUtil.getStackTrace(rootCause));
            throw new RuntimeException(rfe);
        }
    }

    private void stopRemoteServer() {
        try {
            ObjectName on = DomainStatusHelper.getServersConfigObjectName();
            MBeanServer server = this.getMBeanServer();
            Object[] params = new Object[]{this.getServerName()};
            String[] signature = new String[]{"java.lang.String"};
            server.invoke(on, "stopServerInstance", params, signature);
        }
        catch (MalformedObjectNameException mfone) {
            Throwable rootCause = ExceptionUtil.getRootCause(mfone);
            this.getMBeanLogger().warning(rootCause.toString() + "\n" + ExceptionUtil.getStackTrace(rootCause));
            throw new RuntimeException(mfone);
        }
        catch (InstanceNotFoundException infe) {
            Throwable rootCause = ExceptionUtil.getRootCause(infe);
            this.getMBeanLogger().fine(rootCause.toString() + "\n" + ExceptionUtil.getStackTrace(rootCause));
            throw new RuntimeException(infe);
        }
        catch (MBeanException mbe) {
            Throwable rootCause = ExceptionUtil.getRootCause(mbe);
            this.getMBeanLogger().warning(rootCause.toString() + "\n" + ExceptionUtil.getStackTrace(rootCause));
            throw new RuntimeException(mbe);
        }
        catch (ReflectionException rfe) {
            Throwable rootCause = ExceptionUtil.getRootCause(rfe);
            this.getMBeanLogger().warning(rootCause.toString() + "\n" + ExceptionUtil.getStackTrace(rootCause));
            throw new RuntimeException(rfe);
        }
    }

    static {
        $assertionsDisabled = !DASJ2EEServerImpl.class.desiredAssertionStatus();
        DOMAIN_STATUS_INTERFACES = new Class[]{DomainStatusMBean.class};
    }
}

