/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.oldconfig.OldAdminServiceMBean;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

public final class JMXConnectorConfigFactory
extends ConfigFactory {
    private final OldAdminServiceMBean mOldAdminServiceMBean;
    private final Set LEGAL_OPTIONAL_KEYS = SetUtil.newUnmodifiableSet(new String[]{"AcceptAll", "SecurityEnabled"});
    private static final String ADDRESS_KEY = "Address";
    private static final String PORT_KEY = "Port";
    private static final String AUTH_REALM_NAME_KEY = "AuthRealmName";

    public JMXConnectorConfigFactory(ConfigFactoryCallback callbacks, OldAdminServiceMBean old) {
        super(callbacks);
        this.mOldAdminServiceMBean = old;
    }

    protected Set getLegalOptionalCreateKeys() {
        return this.LEGAL_OPTIONAL_KEYS;
    }

    public ObjectName create(String name, String address, int port, String authRealmName, Map optional) {
        Object[] requiredParams = new Object[]{ADDRESS_KEY, address, PORT_KEY, new Integer(port), AUTH_REALM_NAME_KEY, authRealmName};
        Map params = this.initParams(name, requiredParams, optional);
        ObjectName amxObjectName = this.createNamedChild(name, params);
        return amxObjectName;
    }

    protected void removeByName(String name) {
        this.mOldAdminServiceMBean.removeJmxConnectorByName(name);
    }

    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        return this.mOldAdminServiceMBean.createJmxConnector(translatedAttrs);
    }
}

