/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.deploy.DeploymentStatus;
import com.sun.appserv.management.deploy.DeploymentSupport;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.oldconfig.OldApplicationsConfigMBean;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeployedItemRefConfigFactory
extends ConfigFactory {
    private final OldApplicationsConfigMBean mOldApplicationsConfigMBean = this.getOldConfigProxies().getOldApplicationsConfigMBean();
    static final /* synthetic */ boolean $assertionsDisabled;

    public DeployedItemRefConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    protected Map getParamNameOverrides() {
        return MapUtil.newMap("Name", "ref");
    }

    public ObjectName create(String referencedApplicationName, Map optional) {
        this.trace("DeployedItemRefConfigFactory.create: creating using: ");
        Map params = this.initParams(referencedApplicationName, null, optional);
        this.trace("params as processed: " + this.stringify(params));
        ObjectName amxName = this.createNamedChild(referencedApplicationName, params);
        return amxName;
    }

    public ObjectName create(String referencedApplicationName, boolean enabled, String virtualServers, boolean lbEnabled, int disableTimeoutInMinutes) {
        HashMap optionalParams = new HashMap();
        DeployedItemRefConfigFactory.putNonNull(optionalParams, "Enabled", Boolean.toString(enabled));
        DeployedItemRefConfigFactory.putNonNull(optionalParams, "VirtualServers", virtualServers);
        DeployedItemRefConfigFactory.putNonNull(optionalParams, "LBEnabled", Boolean.toString(lbEnabled));
        DeployedItemRefConfigFactory.putNonNull(optionalParams, "DisableTimeoutInMinutes", Integer.toString(disableTimeoutInMinutes));
        ObjectName amxName = this.create(referencedApplicationName, optionalParams);
        return amxName;
    }

    public ObjectName create(String referencedApplicationName) {
        return this.create(referencedApplicationName, null);
    }

    public void internalRemove(ObjectName objectName) {
        String containerName = this.getFactoryContainer().getName();
        this.mOldApplicationsConfigMBean.deleteApplicationReferenceAndReturnStatusAsMap(containerName, Util.getName(objectName), null);
    }

    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        String appRef;
        Map attributeMap;
        block4: {
            this.trace("createOldChildConfig: attrs: " + this.stringify(translatedAttrs));
            String REF_KEY = "ref";
            attributeMap = JMXUtil.attributeListToValueMap(translatedAttrs);
            appRef = null;
            try {
                appRef = (String)attributeMap.remove("ref");
            }
            catch (UnsupportedOperationException uoe) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        if (!$assertionsDisabled && appRef == null) {
            throw new AssertionError();
        }
        String target = this.getFactoryContainer().getName();
        if (!$assertionsDisabled && target == null) {
            throw new AssertionError();
        }
        ObjectName on = this.createApplicationRef(appRef, target, attributeMap);
        return on;
    }

    private ObjectName createApplicationRef(String ref, String target, Map optional) {
        Map m = this.mOldApplicationsConfigMBean.createApplicationReferenceAndReturnStatusAsMap(target, ref, optional);
        this.checkDeploymentStatusForExceptions(m);
        String targetJ2EEType = this.getFactoryContainer().getJ2EEType();
        ObjectName on = null;
        if ("X-StandaloneServerConfig".equals(targetJ2EEType)) {
            on = this.getOldConfigProxies().getOldServerMBean(target).getApplicationRefByRef(ref);
        } else if ("X-ClusterConfig".equals(targetJ2EEType)) {
            on = this.getOldConfigProxies().getOldClusterMBean(target).getApplicationRefByRef(ref);
        } else {
            throw new RuntimeException("Application refs can be created only on clusters and standalone servers");
        }
        return on;
    }

    private void checkDeploymentStatusForExceptions(Map m) {
        DeploymentStatus status = DeploymentSupport.mapToDeploymentStatus(m);
        Throwable t = status.getStageThrowable();
        Iterator it = status.getSubStages();
        while (t == null && it.hasNext()) {
            Map m1 = (Map)it.next();
            status = DeploymentSupport.mapToDeploymentStatus(m1);
            t = status.getThrowable();
        }
        if (null != t) {
            throw new RuntimeException(status.getStageStatusMessage());
        }
    }

    static {
        $assertionsDisabled = !DeployedItemRefConfigFactory.class.desiredAssertionStatus();
    }
}

