/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.OldConfigTypes;
import com.sun.enterprise.management.support.OldTypeToJ2EETypeMapper;
import com.sun.enterprise.management.support.ParamNameMapper;
import com.sun.enterprise.management.support.oldconfig.OldConfigProxies;
import com.sun.enterprise.management.support.oldconfig.OldResourcesMBean;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

class ConfigFactory {
    private final ConfigFactoryCallback mCallbacks;
    private ParamNameMapper mParamNameMapper = null;
    protected static final String CONFIG_NAME_KEY = "Name";
    private static final Class[] ATTRS_ONLY_SIG;
    private static final Class[] ATTRS_AND_PROPS_SIG;
    protected static final Set NO_OPTIONAL_KEYS;
    private static final Class[] TYPE_AND_ATTRS_AND_PROPS_SIG;
    private static final Class[] TYPE_AND_ATTRS_SIG;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ConfigFactory(ConfigFactoryCallback callbacks) {
        this.mCallbacks = callbacks;
    }

    protected final ConfigFactoryCallback getCallbacks() {
        return this.mCallbacks;
    }

    protected static void putNonNull(Map m, String key, Object value) {
        if (value != null) {
            m.put(key, value);
        }
    }

    protected final String getConfigName() {
        return this.getCallbacks().getConfigName();
    }

    protected final Logger getLogger() {
        return this.getCallbacks().getLogger();
    }

    protected final DomainRoot getDomainRoot() {
        return this.getCallbacks().getDomainRoot();
    }

    protected final DomainConfig getDomainConfig() {
        return this.getDomainRoot().getDomainConfig();
    }

    protected final Container getFactoryContainer() {
        return this.getCallbacks().getFactoryContainer();
    }

    protected final OldConfigProxies getOldConfigProxies() {
        return this.getCallbacks().getOldConfigProxies();
    }

    public final void remove(ObjectName objectName) {
        if (objectName == null) {
            throw new IllegalArgumentException("" + null);
        }
        this.internalRemove(objectName);
        this.getCallbacks().sendConfigRemovedNotification(objectName);
    }

    protected void removeByName(String name) {
        throw new UnsupportedOperationException("removeByNameInternal");
    }

    protected void internalRemove(ObjectName objectName) {
        this.removeByName(Util.getName(objectName));
    }

    protected Map getParamNameOverrides() {
        return Collections.EMPTY_MAP;
    }

    protected synchronized ParamNameMapper getParamNameMapper() {
        if (this.mParamNameMapper == null) {
            this.mParamNameMapper = new ParamNameMapper(this.getParamNameOverrides());
        }
        return this.mParamNameMapper;
    }

    protected boolean getBooleanOption(Map m, String key) {
        boolean value = false;
        Object obj = m.get(key);
        if (obj != null) {
            if (obj instanceof Boolean) {
                value = (Boolean)obj;
            } else if (obj instanceof String) {
                value = Boolean.valueOf((String)obj);
            } else {
                throw new IllegalArgumentException("Illegal value for Boolean " + key);
            }
        }
        return value;
    }

    protected boolean requireValidReferences(Map options) {
        return !this.getBooleanOption(options, "IgnoreMissingReferences");
    }

    protected final Method findAnyMethod(String methodName, Class[] sig) {
        Method m = null;
        try {
            m = this.getClass().getDeclaredMethod(methodName, sig);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return m;
    }

    public final ObjectName createChild(Map params) {
        return this.createNamedChild(null, params);
    }

    public final ObjectName createNamedChild(String name, Map params) {
        AttributeList attrs = new AttributeList();
        Properties props = new Properties();
        this.translateParams(params, attrs, props);
        this.trace("createNamedChild: translated attrs:\n" + this.stringify(attrs));
        this.trace("createNamedChild: props:\n" + this.stringify(props));
        ObjectName oldObjectName = null;
        boolean propertiesHandled = false;
        if (this.findAnyMethod("createOldChildConfig", ATTRS_AND_PROPS_SIG) != null) {
            oldObjectName = this.createOldChildConfig(attrs, props);
            propertiesHandled = true;
        } else if (this.findAnyMethod("createOldChildConfig", ATTRS_ONLY_SIG) != null) {
            oldObjectName = this.createOldChildConfig(attrs);
        } else {
            throw new UnsupportedOperationException("createOldChildConfig");
        }
        if (!$assertionsDisabled && oldObjectName == null) {
            throw new AssertionError();
        }
        this.trace("createNamedChild: oldObjectName: " + StringUtil.quote(oldObjectName.toString()));
        ObjectName amxName = this.getCallbacks().getLoader().sync(oldObjectName);
        this.trace("createNamedChild: amx object name: " + StringUtil.quote(amxName.toString()));
        if (props.size() > 0 && !propertiesHandled) {
            this.setAllProperties(amxName, props);
        }
        this.getCallbacks().sendConfigCreatedNotification(amxName);
        return amxName;
    }

    protected Set getLegalOptionalCreateKeys() {
        return NO_OPTIONAL_KEYS;
    }

    protected void checkLegalOptions(Map options) {
        Set legalKeys;
        if (options != null && (legalKeys = this.getLegalOptionalCreateKeys()) != null) {
            HashMap remaining = new HashMap(options);
            remaining.keySet().removeAll(legalKeys);
            HashMap illegal = new HashMap();
            Iterator iter = remaining.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                if (key.startsWith("property.")) continue;
                illegal.put(key, remaining.get(key));
            }
            if (illegal.size() != 0) {
                throw new IllegalArgumentException("Illegal optional keys: " + MapUtil.toString(illegal, ","));
            }
        }
    }

    public final Map initParams(String name, Object[] required, Map optional) {
        this.checkLegalOptions(optional);
        Map m = this.initParams(required, optional);
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Illegal to have null or empty name");
        }
        m.put(CONFIG_NAME_KEY, name);
        return m;
    }

    protected final void validateParams(Map params) {
        Iterator iter = params.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Object value = params.get(name);
            this.validateParam(name, value);
        }
    }

    protected final void validateParam(String name, Object value) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("parameter name must be non-null and non-empty");
        }
        if (name.startsWith("property.") && !(value instanceof String)) {
            throw new IllegalArgumentException("Property value must be string: " + name + ", class =" + value.getClass().getName());
        }
    }

    protected final Map initParams(Object[] required, Map optional) {
        HashMap m = new HashMap();
        if (optional != null) {
            m.putAll(optional);
            m.remove("IgnoreMissingReferences");
        }
        if (required != null) {
            m.putAll(MapUtil.newMap(required));
        }
        this.validateParams(m);
        return m;
    }

    protected final Map initParams(Map optional) {
        return this.initParams(null, optional);
    }

    protected final void translateParams(Map paramsToTranslate, AttributeList attrsOut, Properties propsOut) {
        ParamNameMapper mapper = this.getParamNameMapper();
        Iterator iter = paramsToTranslate.keySet().iterator();
        String propertyPrefix = "property.";
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object value = paramsToTranslate.get(key);
            if (key.startsWith("property.")) {
                String name = key.substring("property.".length(), key.length());
                propsOut.put(name, value);
                continue;
            }
            String translatedName = mapper.mangleAttributeName(key);
            Attribute attr = new Attribute(translatedName, value);
            attrsOut.add(attr);
        }
    }

    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        throw new UnsupportedOperationException("createOldChildConfig( AttributeList )");
    }

    protected ObjectName createOldChildConfig(AttributeList translatedAttrs, Properties props) {
        throw new UnsupportedOperationException("createOldChildConfig( AttributeList, Properties)");
    }

    protected final void trace(Object o) {
    }

    protected String stringify(Object o) {
        return SmartStringifier.toString(o);
    }

    protected ObjectName createOldChildByType(String oldChildType, AttributeList translatedAttrs) {
        throw new UnsupportedOperationException("createOldChildByType( String, AttributeList )");
    }

    protected ObjectName createOldChildByType(String oldChildType, AttributeList translatedAttrs, Properties props) {
        throw new UnsupportedOperationException("createOldChildByType( String, AttributeList, Properties )");
    }

    public final ObjectName createChildByType(String childJ2EEType, Map params) {
        String oldType = this.getOldTypeToJ2EETypeMapper().j2eeTypeToOldType(childJ2EEType);
        if (!$assertionsDisabled && oldType == null) {
            throw new AssertionError();
        }
        Properties props = new Properties();
        AttributeList attrs = new AttributeList();
        this.translateParams(params, attrs, props);
        ObjectName oldObjectName = null;
        boolean propertiesHandled = false;
        if (this.findAnyMethod("createOldChildByType", TYPE_AND_ATTRS_AND_PROPS_SIG) != null) {
            oldObjectName = this.createOldChildByType(oldType, attrs, props);
            propertiesHandled = true;
        } else if (this.findAnyMethod("createOldChildByType", TYPE_AND_ATTRS_SIG) != null) {
            oldObjectName = this.createOldChildByType(oldType, attrs);
        } else if (this.findAnyMethod("createOldChildByType", ATTRS_ONLY_SIG) != null) {
            oldObjectName = this.createOldChildConfig(attrs);
        } else {
            throw new UnsupportedOperationException("createOldChildByType");
        }
        if (!$assertionsDisabled && oldObjectName == null) {
            throw new AssertionError();
        }
        this.trace("createChildByType: oldObjectName: " + StringUtil.quote(oldObjectName.toString()));
        ObjectName amxName = this.getCallbacks().getLoader().sync(oldObjectName);
        this.trace("createChildByType: amx object name: " + StringUtil.quote(amxName.toString()));
        if (props.size() > 0 && !propertiesHandled) {
            this.setAllProperties(amxName, props);
        }
        this.getCallbacks().sendConfigCreatedNotification(amxName);
        return amxName;
    }

    protected final void setAllProperties(ObjectName amxObjectName, Properties props) {
        AMX proxy = this.getCallbacks().getProxyFactory().getProxy(amxObjectName);
        if (!(proxy instanceof PropertiesAccess)) {
            throw new IllegalArgumentException(amxObjectName.toString());
        }
        this.setAllProperties((PropertiesAccess)((Object)proxy), props);
    }

    protected final void setAllProperties(PropertiesAccess target, Properties props) {
        Iterator<Object> iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            target.setPropertyValue(key, (String)props.get(key));
        }
    }

    protected OldTypeToJ2EETypeMapper getOldTypeToJ2EETypeMapper() {
        return OldConfigTypes.getInstance();
    }

    protected ObjectName syncNewAMXMBeanWithOld(ObjectName oldObjectName) {
        ObjectName amxName = this.getCallbacks().getLoader().sync(oldObjectName);
        this.getCallbacks().sendConfigCreatedNotification(amxName);
        return amxName;
    }

    final OldResourcesMBean getOldResourcesMBean() {
        return this.getOldConfigProxies().getOldResourcesMBean();
    }

    protected static String quote(Object o) {
        return StringUtil.quote(o.toString());
    }

    protected void checkNonEmptyString(String s, String name) {
        if (s == null || s.length() == 0) {
            throw new IllegalArgumentException("Parameter may not be null or empty: " + ConfigFactory.quote(name));
        }
    }

    static {
        $assertionsDisabled = !ConfigFactory.class.desiredAssertionStatus();
        ATTRS_ONLY_SIG = new Class[]{AttributeList.class};
        ATTRS_AND_PROPS_SIG = new Class[]{AttributeList.class, Properties.class};
        NO_OPTIONAL_KEYS = Collections.EMPTY_SET;
        TYPE_AND_ATTRS_AND_PROPS_SIG = new Class[]{String.class, AttributeList.class, Properties.class};
        TYPE_AND_ATTRS_SIG = new Class[]{String.class, AttributeList.class};
    }
}

