/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.oldconfig.OldServersMBean;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

public final class ClusteredServerConfigFactory
extends ConfigFactory {
    private final OldServersMBean mOldServersMBean;
    private final Set LEGAL_OPTIONAL_KEYS = SetUtil.newUnmodifiableSet(new String[]{"property.HTTP_LISTENER_PORT", "property.HTTP_SSL_LISTENER_PORT", "property.IIOP_LISTENER_PORT", "property.IIOP_SSL_LISTENER_PORT", "property.IIOP_SSL_MUTUALAUTH_PORT", "property.JMX_SYSTEM_CONNECTOR_PORT"});

    public ClusteredServerConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
        this.mOldServersMBean = this.getOldConfigProxies().getOldServersMBean();
    }

    protected Set getLegalOptionalCreateKeys() {
        return this.LEGAL_OPTIONAL_KEYS;
    }

    public ObjectName create(String name, String nodeAgentName, String clusterName, Map optional) {
        Map all = this.initParams(name, null, optional);
        Properties props = new Properties();
        AttributeList attrList = new AttributeList();
        this.translateParams(all, attrList, props);
        ObjectName oldServerObjectName = this.mOldServersMBean.createServerInstance(nodeAgentName, name, null, clusterName, props);
        return this.syncNewAMXMBeanWithOld(oldServerObjectName);
    }

    protected void removeByName(String name) {
        this.mOldServersMBean.deleteServerInstance(name);
    }
}

