/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.RequestProcessing;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import java.util.logging.Level;

public class RequestProcessingTest
extends GenericValidator {
    public RequestProcessingTest(ValidationDescriptor d) {
        super(d);
    }

    public Result validate(ConfigContextEvent cce) {
        Result r = super.validate(cce);
        try {
            if (cce.getChoice().equals("ADD")) {
                this.validateAdd(cce, r);
            } else if (cce.getChoice().equals("UPDATE")) {
                this.validateUpdate(cce, r);
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "domainxmlverifier", e);
        }
        return r;
    }

    private final void validateAdd(ConfigContextEvent cce, Result r) throws ConfigException {
        this.validateThreadValues(this.getRequestProcessing(cce).getInitialThreadCount(), this.getRequestProcessing(cce).getThreadCount(), r);
    }

    private final void validateUpdate(ConfigContextEvent cce, Result r) throws ConfigException {
        if (cce.getName().equals(ServerTags.INITIAL_THREAD_COUNT)) {
            this.validateThreadValues((String)cce.getObject(), this.getRequestProcessing(cce).getThreadCount(), r);
        } else if (cce.getName().equals(ServerTags.THREAD_COUNT)) {
            this.validateThreadValues(this.getRequestProcessing(cce).getInitialThreadCount(), (String)cce.getObject(), r);
        }
    }

    private final void validateThreadValues(String initial, String max, Result r) {
        try {
            int itc = Integer.parseInt(initial);
            int tc = Integer.parseInt(max);
            if (itc > tc) {
                r.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidThreadCount", "Error - expected initial thread count ({0}) to be no greater than thread count ({1})", new Object[]{new Integer(itc), new Integer(tc)}));
            }
        }
        catch (NumberFormatException nfe) {
            _logger.log(Level.FINE, "domainxmlverifier", nfe);
        }
    }

    private final RequestProcessing getRequestProcessing(ConfigContextEvent cce) throws ConfigException {
        return (RequestProcessing)cce.getValidationTarget();
    }
}

