/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.ThreadPool;
import com.sun.enterprise.config.serverbeans.ThreadPools;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import com.sun.enterprise.config.serverbeans.validation.tests.StaticTest;
import java.util.Vector;
import java.util.logging.Level;

public class OrbTest
extends GenericValidator {
    public OrbTest(ValidationDescriptor desc) {
        super(desc);
    }

    public Result validate(ConfigContextEvent cce) {
        Result result = super.validate(cce);
        if (cce.getChoice().equals("UPDATE")) {
            String name = cce.getName();
            String value = (String)cce.getObject();
            Config config = (Config)((ConfigBean)cce.getClassObject()).parent().parent();
            this.validateAttribute(name, value, config, result);
        }
        return result;
    }

    public void validateAttribute(String name, String value, Config config, Result result) {
        if (value == null || value.equals("")) {
            return;
        }
        if (name.equals(ServerTags.USE_THREAD_POOL_IDS)) {
            Vector ids = StaticTest.tokens(value);
            for (int i = 0; i < ids.size(); ++i) {
                if (this.isThreadPoolIdAvailable((String)ids.get(i), config)) continue;
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".threadpoolNotAvl", "Attribute (thread-pool-id={0}) : Thread pool id not available ", new Object[]{(String)ids.get(i)}));
            }
        }
    }

    public boolean isThreadPoolIdAvailable(String value, Config config) {
        boolean flag;
        block3: {
            flag = false;
            try {
                if (config == null) break block3;
                ThreadPools threadpools = config.getThreadPools();
                ThreadPool[] threadpool = threadpools.getThreadPool();
                for (int i = 0; i < threadpool.length; ++i) {
                    if (!threadpool[i].getThreadPoolId().equals(value)) continue;
                    flag = true;
                    break;
                }
            }
            catch (Exception ex) {
                _logger.log(Level.FINE, "domainxmlverifier.exception", ex);
            }
        }
        return flag;
    }
}

