/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import java.util.logging.Level;

public class JdbcConnectionPoolTest
extends GenericValidator {
    static boolean checked = false;
    int maxPoolSize = 0;

    public JdbcConnectionPoolTest(ValidationDescriptor desc) {
        super(desc);
    }

    public Result validate(ConfigContextEvent cce) {
        JdbcConnectionPool pool;
        Result result = super.validate(cce);
        String choice = cce.getChoice();
        if (cce.getChoice().equals("OFFLINE")) {
            pool = (JdbcConnectionPool)cce.getObject();
            if (pool.isIsConnectionValidationRequired() && pool.getConnectionValidationMethod().equals("table") && (pool.getValidationTableName() == null || pool.getValidationTableName().equals(""))) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".requiredTableName", "Required Table Name if Connection validation method is Table"));
            }
            try {
                this.maxPoolSize = Integer.parseInt(pool.getMaxPoolSize());
            }
            catch (NumberFormatException e) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxPoolSizeInvalid", "Maximum Pool Size : invalid number "));
            }
            this.validateAttribute(ServerTags.POOL_RESIZE_QUANTITY, pool.getPoolResizeQuantity(), result);
        }
        if (choice.equals("ADD")) {
            pool = (JdbcConnectionPool)cce.getObject();
            if (pool.isIsConnectionValidationRequired() && pool.getConnectionValidationMethod().equals("table") && (pool.getValidationTableName() == null || pool.getValidationTableName().equals(""))) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".requiredTableName", "Required Table Name if Connection validation method is Table"));
            }
            try {
                this.maxPoolSize = Integer.parseInt(pool.getMaxPoolSize());
            }
            catch (Exception e) {
                // empty catch block
            }
            this.validateAttribute(ServerTags.POOL_RESIZE_QUANTITY, pool.getPoolResizeQuantity(), result);
        }
        if (choice.equals("DELETE")) {
            pool = (JdbcConnectionPool)cce.getObject();
            String poolName = pool.getName();
            try {
                ConfigContext context = cce.getConfigContext();
                Domain domain = (Domain)context.getRootConfigBean();
                Resources resource = domain.getResources();
                JdbcResource[] jdbcResource = resource.getJdbcResource();
                for (int i = 0; i < jdbcResource.length; ++i) {
                    if (!jdbcResource[i].getPoolName().equals(poolName)) continue;
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".connpoolUsed", "Connection Pool Used by Existing data source, cannot delete pool"));
                    break;
                }
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "domainxml_verifier.error", e);
            }
        }
        if (choice.equals("UPDATE")) {
            this.validateAttribute(cce.getName(), (String)cce.getObject(), result);
        }
        return result;
    }

    public void validateAttribute(String name, String value, Result result) {
        if (value == null || value.equals("")) {
            return;
        }
        if (name.equals(ServerTags.MAX_POOL_SIZE)) {
            try {
                this.maxPoolSize = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (name.equals(ServerTags.POOL_RESIZE_QUANTITY)) {
            try {
                int poolResizeQty = Integer.parseInt(value);
                if (this.maxPoolSize > 0 && poolResizeQty > this.maxPoolSize) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidPoolResize", "Attribute(pool-resize-quantity={0}) : Invalid, it is greater than Max Pool Size {1}", new Object[]{value, String.valueOf(this.maxPoolSize)}));
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }
}

