/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import java.util.Set;
import java.util.logging.Level;

public class ClusterTest
extends GenericValidator {
    public ClusterTest(ValidationDescriptor desc) {
        super(desc);
    }

    void validateAdd(ConfigContextEvent cce, Result result) throws ConfigException {
        this.checkNameNotDomain(cce, result);
        this.checkConfigRefValidity(cce, result);
    }

    void validateUpdate(ConfigContextEvent cce, Result result) throws ConfigException {
        this.checkNameNotDomain(cce, result);
        this.preventInvalidConfigRef(cce, result);
    }

    void validateDelete(ConfigContextEvent cce, Result result) {
        try {
            if (this.isReferenced(cce)) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".cannotDeleteWhenReferenced", "Cluster {0} cannot be deleted because it is referenced by {1} ClusterRefs", new Object[]{this.getCluster(cce).getName(), new Integer(this.getReferers(cce).size())}));
            }
        }
        catch (ConfigException ce) {
            _logger.log(Level.WARNING, "domainxmlverifier.exception", ce);
        }
    }

    private boolean isReferenced(ConfigContextEvent cce) throws ConfigException {
        return ServerBeansFactory.isReferenced((Cluster)this.getCluster(cce), (ConfigContext)cce.getConfigContext());
    }

    private Set getReferers(ConfigContextEvent cce) throws ConfigException {
        return ServerBeansFactory.getReferers((Cluster)this.getCluster(cce), (ConfigContext)cce.getConfigContext());
    }

    void checkNameNotDomain(ConfigContextEvent cce, Result result) throws ConfigException {
        Cluster c = this.getCluster(cce);
        if ("domain".equals(c.getName())) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".illegalClusterName", "Illegal Cluster Name: {0}", new Object[]{c.getName()}));
        }
    }

    private Cluster getCluster(ConfigContextEvent cce) throws ConfigException {
        return (Cluster)cce.getValidationTarget();
    }

    public Result validate(ConfigContextEvent cce) {
        Result result = super.validate(cce);
        boolean flag = false;
        String choice = cce.getChoice();
        try {
            if (choice.equals("UPDATE")) {
                this.validateUpdate(cce, result);
            } else if (choice.equals("ADD")) {
                this.validateAdd(cce, result);
            } else if (choice.equals("DELETE")) {
                this.validateDelete(cce, result);
            }
        }
        catch (ConfigException ce) {
            _logger.log(Level.WARNING, "domainxmlverifier.exception", ce);
        }
        return result;
    }

    private final void preventInvalidConfigRef(ConfigContextEvent cce, Result result) throws ConfigException {
        if (cce.getName().equals(ServerTags.CONFIG_REF)) {
            this.checkConfigRefValidity((String)cce.getObject(), result);
        }
    }

    private final void checkConfigRefValidity(ConfigContextEvent cce, Result result) throws ConfigException {
        this.checkConfigRefValidity(this.getCluster(cce).getConfigRef(), result);
    }

    private void checkConfigRefValidity(String config_ref, Result result) {
        if (config_ref.equals("server-config")) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".cannotHaveDASasConfig", "The configuration of the Domain Administration Server (named {0}) cannot be referenced by a cluster", new Object[]{"server-config"}));
        } else if (config_ref.equals("default-config")) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".cannotHaveTemplateConfig", "The default configuration template (named {0}) cannot be referenced by a cluster", new Object[]{"default-config"}));
        }
    }
}

