/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.serverbeans.validation.DomainMgr;
import com.sun.enterprise.config.serverbeans.validation.Localiser;
import com.sun.enterprise.config.serverbeans.validation.RNGValidator;
import com.sun.enterprise.config.serverbeans.validation.Schematron;
import com.sun.enterprise.config.serverbeans.validation.StringManagerHelper;
import com.sun.enterprise.config.serverbeans.validation.VariableResolver;
import com.sun.enterprise.util.LocalStringManager;
import com.sun.logging.LogDomains;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DomainXmlVerifier {
    public ConfigContext configContext;
    public DomainMgr domainMgr;
    public String domainFile;
    public boolean error;
    public static boolean debug = false;
    public static int count = 0;
    static Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.tools.verifier");
    static LocalStringManager smh;
    private static final String dir = "";
    private static final String SCHEMATRON_STYLESHEET = "/domain.xsl";
    private static final String DOMAIN_RNG = "/domain.rng";
    private static final String DOMAIN_DTD = "/sun-domain_1_1.dtd";

    public DomainXmlVerifier(String file) throws Exception {
        this.domainFile = file;
        this.configContext = ConfigFactory.createConfigContext((String)file);
        this.configContext.refresh();
        this.domainMgr = new DomainMgr();
        this.error = false;
    }

    public DomainMgr getDomainMgr() {
        return this.domainMgr;
    }

    public ConfigContext getConfigContext() {
        return this.configContext;
    }

    public void setDebug(boolean flag) {
        debug = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean invokeConfigValidator() throws VerifierConfigurationException, SAXException, IOException, TransformerConfigurationException, TransformerException {
        StringWriter sw = new StringWriter();
        BufferedWriter out = new BufferedWriter(sw);
        try {
            try {
                this.typeCheck(this.domainFile, out);
                this.schematronCheck(this.domainFile, out, smh, _logger);
            }
            catch (Throwable t) {
                t.printStackTrace(new PrintWriter(out));
                Object var5_4 = null;
                ((Writer)out).flush();
                String error = sw.toString();
                if (null != error && error.length() > 0) {
                    _logger.log(Level.SEVERE, sw.toString());
                }
                return true;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((Writer)out).flush();
            String error = sw.toString();
            if (null != error && error.length() > 0) {
                _logger.log(Level.SEVERE, sw.toString());
            }
            return true;
        }
        ((Writer)out).flush();
        String error = sw.toString();
        if (null != error && error.length() > 0) {
            _logger.log(Level.SEVERE, sw.toString());
        }
        return true;
    }

    private void schematronCheck(String xml, Writer out, LocalStringManager lsm, Logger logger) throws TransformerConfigurationException, TransformerException, SAXException {
        Localiser l = new Localiser(lsm, out, logger, DomainXmlVerifier.class.getName());
        Schematron s = new Schematron(SCHEMATRON_STYLESHEET);
        VariableResolver vr = new VariableResolver();
        vr.setEntityResolver(new MyEntityResolver());
        s.analyze(new SAXSource(vr, new InputSource(xml)), new SAXResult(l));
    }

    private void typeCheck(String xml, Writer out) throws VerifierConfigurationException, SAXException, IOException {
        RNGValidator r = new RNGValidator();
        VariableResolver vr = new VariableResolver();
        vr.setEntityResolver(new MyEntityResolver());
        InputStream schema = this.getClass().getResourceAsStream(DOMAIN_RNG);
        if (null == schema) {
            throw new IOException("couldn't get resource: /domain.rng");
        }
        r.validate(new InputSource(schema), new InputSource(xml), (XMLReader)vr, out);
    }

    static {
        StringManagerHelper.setLocalStringsManager(DomainXmlVerifier.class);
        smh = StringManagerHelper.getLocalStringsManager();
    }

    private static class MyEntityResolver
    implements EntityResolver {
        private MyEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (null != publicId && publicId.equals("-//Sun Microsystems Inc.//DTD Application Server 8.0 Domain//EN")) {
                InputStream is = this.getClass().getResourceAsStream(DomainXmlVerifier.DOMAIN_DTD);
                return null != is ? new InputSource(is) : null;
            }
            return null;
        }
    }
}

