/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermodel.controllers;

import com.sun.enterprise.admin.common.EntityStatus;
import com.sun.enterprise.admin.common.exception.AFException;
import com.sun.enterprise.admin.common.exception.AFOtherException;
import com.sun.enterprise.admin.servermodel.beans.DeployedModuleComponentBean;
import com.sun.enterprise.admin.servermodel.beans.ServerComponent;
import com.sun.enterprise.admin.servermodel.context.ContextHolder;
import com.sun.enterprise.admin.servermodel.controllers.ComponentController;
import com.sun.enterprise.admin.servermodel.controllers.SOMRequestDispatcher;
import com.sun.enterprise.admin.util.Assert;
import com.sun.enterprise.admin.util.Debug;
import com.sun.enterprise.admin.util.ExceptionUtil;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class DeployedModuleComponentController
implements ComponentController {
    private static final String ENABLE_MODULE = "enable";
    private static final String DISABLE_MODULE = "disable";
    private static final String GET_STATUS = "getStatus";
    private static final String START = "start";
    private static final String STOP = "stop";
    private static final String GET_STATE = "getState";
    private DeployedModuleComponentBean deployedModule;

    public DeployedModuleComponentController(DeployedModuleComponentBean deployedModule) {
        this.deployedModule = deployedModule;
    }

    public boolean isEnabled() {
        boolean isEnabled = false;
        try {
            EntityStatus status = this.getEntityStatus();
            isEnabled = status.getStatusCode() == 4;
        }
        catch (AFException afe) {
            Debug.println("Warning : Suppressing the exception");
            Debug.printStackTrace(afe);
            ExceptionUtil.ignoreException(afe);
        }
        return isEnabled;
    }

    public boolean enable() {
        boolean isEnabled = false;
        try {
            this.invoke(ENABLE_MODULE, null, null);
            isEnabled = true;
        }
        catch (Exception e) {
            isEnabled = false;
            Debug.println("Warning : Suppressing the exception");
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return isEnabled;
    }

    public boolean disable() {
        boolean isDisbled = false;
        try {
            this.invoke(DISABLE_MODULE, null, null);
            isDisbled = true;
        }
        catch (Exception e) {
            isDisbled = false;
            Debug.println("Warning : Suppressing the exception");
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return isDisbled;
    }

    public boolean start() {
        boolean isStarted = false;
        try {
            this.invoke(START, null, null);
            isStarted = true;
        }
        catch (Exception e) {
            Debug.println("Warning : Suppressing the exception");
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return isStarted;
    }

    public boolean stop() {
        boolean isStopped = false;
        try {
            this.invoke(STOP, null, null);
            isStopped = true;
        }
        catch (Exception e) {
            Debug.println("Warning : Suppressing the exception");
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return isStopped;
    }

    public int getState() {
        int state = -1;
        try {
            Integer intObj = (Integer)this.invoke(GET_STATE, null, null);
            state = intObj;
        }
        catch (Exception e) {
            Debug.println("Warning : Suppressing the exception");
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return state;
    }

    public String getStatus() {
        String strStatus = null;
        try {
            EntityStatus status = this.getEntityStatus();
            strStatus = status.getStatusString();
        }
        catch (AFException afe) {
            Debug.printStackTrace(afe);
            Debug.println("Warning : Suppressing exception");
            ExceptionUtil.ignoreException(afe);
        }
        return strStatus;
    }

    public ServerComponent[] getSubComponents() {
        return null;
    }

    private EntityStatus getEntityStatus() throws AFException {
        EntityStatus status = (EntityStatus)this.invoke(GET_STATUS, null, null);
        Assert.assertit(status != null, "null value returned");
        return status;
    }

    private Object invoke(String operationName, Object[] params, String[] signature) throws AFException {
        ObjectName mbeanName = null;
        Object retValue = null;
        try {
            mbeanName = new ObjectName(this.deployedModule.getIdentifier());
            ContextHolder ctxHolder = this.deployedModule.getContextHolder();
            SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
            retValue = dispatcher.invoke(mbeanName, operationName, params, signature);
        }
        catch (MalformedObjectNameException mone) {
            throw new AFOtherException(mone);
        }
        return retValue;
    }
}

