/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.pe;

import [Ljava.lang.String;;
import com.sun.enterprise.admin.common.Status;
import com.sun.enterprise.admin.server.core.channel.RMIClient;
import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.admin.servermgmt.InstancesManager;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.admin.servermgmt.pe.InstanceTimer;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.admin.servermgmt.pe.TimerCallback;
import com.sun.enterprise.util.ProcessExecutor;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class PEInstancesManager
extends RepositoryManager
implements InstancesManager {
    private static final StringManager _strMgr = StringManager.getManager((Class)PEInstancesManager.class);
    private final RepositoryConfig _config;
    private RMIClient rmiClient = null;

    public PEInstancesManager(RepositoryConfig config) {
        this._config = config;
    }

    protected RepositoryConfig getConfig() {
        return this._config;
    }

    public void createInstance() throws InstanceException {
        throw new UnsupportedOperationException(_strMgr.getString("notSupported"));
    }

    public void deleteInstance() throws InstanceException {
        throw new UnsupportedOperationException(_strMgr.getString("notSupported"));
    }

    public Process startInstance() throws InstanceException {
        return this.startInstance(null, null);
    }

    public Process startInstance(String[] interativeOptions) throws InstanceException {
        String[] commandLineArgs = null;
        return this.startInstance(interativeOptions, commandLineArgs);
    }

    public Process startInstance(String[] interativeOptions, String[] commandLineArgs) throws InstanceException {
        this.preStart();
        Boolean v = (Boolean)this.getConfig().get("domain.verbose");
        boolean verbose = false;
        if (v != null) {
            verbose = v;
        }
        Boolean d = (Boolean)this.getConfig().get("domain.debug");
        boolean debug = false;
        if (d != null) {
            debug = d;
        }
        String[] command = null;
        File script = this.getFileLayout(this.getConfig()).getStartServ();
        String nativeLauncher = System.getProperty("com.sun.aas.nativeLauncher");
        Process process = null;
        ArrayList<String> alCmd = new ArrayList<String>();
        alCmd.add(script.getAbsolutePath());
        if (System.getProperty("com.sun.aas.processLauncher") == null && verbose) {
            try {
                System.setProperty("com.sun.aas.instanceRoot", this.getConfig().getRepositoryRoot() + File.separator + this.getConfig().getRepositoryName());
                ArrayList<String> args = new ArrayList<String>();
                args.add("s1as-server");
                args.add("-Dcom.sun.aas.instanceName=server");
                args.add("start");
                if (debug) {
                    args.add("debug");
                }
                if (verbose) {
                    args.add("verbose");
                }
                if (commandLineArgs != null) {
                    for (int ii = 0; ii < commandLineArgs.length; ++ii) {
                        args.add(commandLineArgs[ii]);
                    }
                }
                String[] argStrings = args.toArray(new String[args.size()]);
                Class<?> launcherClass = Class.forName("LauncherBootstrap");
                Class[] paramClasses = new Class[]{String;.class};
                Object[] argsArray = new Object[]{argStrings};
                Method mainMethod = launcherClass.getMethod("main", paramClasses);
                mainMethod.invoke(null, argsArray);
            }
            catch (Exception ex) {
                throw new InstanceException(this.getMessages().getInstanceStartupExceptionMessage(this.getConfig().getDisplayName()), ex);
            }
        } else if (System.getProperty("com.sun.aas.processLauncher") != null && verbose) {
            if (nativeLauncher != null && nativeLauncher.equals("true")) {
                alCmd.add("native");
            }
            if (debug) {
                alCmd.add("debug");
            }
            if (verbose) {
                alCmd.add("verbose");
            }
            if (commandLineArgs != null) {
                for (int ii = 0; ii < commandLineArgs.length; ++ii) {
                    alCmd.add(commandLineArgs[ii]);
                }
            }
            command = new String[alCmd.size()];
            command = alCmd.toArray(command);
            try {
                ProcessExecutor exec = new ProcessExecutor(command, interativeOptions);
                exec.setVerbose(verbose);
                exec.execute(false, false);
                process = exec.getSubProcess();
                int exitValue = process.waitFor();
                System.exit(exitValue);
            }
            catch (Exception e) {
                throw new InstanceException(_strMgr.getString("procExecError"), e);
            }
        } else {
            if (nativeLauncher != null && nativeLauncher.equals("true")) {
                alCmd.add("native");
            }
            if (debug) {
                alCmd.add("debug");
            }
            if (commandLineArgs != null) {
                for (int ii = 0; ii < commandLineArgs.length; ++ii) {
                    alCmd.add(commandLineArgs[ii]);
                }
            }
            command = new String[alCmd.size()];
            command = alCmd.toArray(command);
            ProcessExecutor processExec = this.startInstanceExecute(command, interativeOptions);
            process = processExec.getSubProcess();
            this.waitUntilStarting(processExec);
            this.waitUntilStarted();
            this.postStart();
        }
        return process;
    }

    protected ProcessExecutor startInstanceExecute(String[] command, String[] interativeOptions) throws InstanceException {
        return this.execute(command, interativeOptions);
    }

    public void stopInstance() throws InstanceException {
        this.preStop();
        this.execute(this.getFileLayout(this.getConfig()).getStopServ());
        this.waitUntilStopped();
        this.postStop();
    }

    public String[] listInstances() throws InstanceException {
        throw new UnsupportedOperationException(_strMgr.getString("notSupported"));
    }

    public boolean isInstanceStarting() throws InstanceException {
        return this.getInstanceStatus() == 1;
    }

    public boolean isInstanceRunning() throws InstanceException {
        return 0 == this.getInstanceStatus();
    }

    public boolean isInstanceFailed() throws InstanceException {
        return 8 == this.getInstanceStatus();
    }

    public boolean isInstanceNotRunning() throws InstanceException {
        return 3 == this.getInstanceStatus();
    }

    public boolean isRestartNeeded() throws InstanceException {
        boolean isRestartNeeded = false;
        try {
            isRestartNeeded = this.getRMIClient().isRestartNeeded();
        }
        catch (Exception e) {
            throw new InstanceException(e.getMessage(), e);
        }
        return isRestartNeeded;
    }

    protected void preStart() throws InstanceException {
        int state = this.getInstanceStatus();
        if (3 != state) {
            throw new InstanceException(this.getMessages().getCannotStartInstanceInvalidStateMessage(this.getConfig().getDisplayName(), Status.getStatusString(state)));
        }
    }

    void postStart() throws InstanceException {
        if (this.isInstanceFailed()) {
            int port = this.getConflictedPort();
            this.abortServer();
            throw new InstanceException(this.getMessages().getStartupFailedMessage(this.getConfig().getDisplayName(), port));
        }
        if (!this.isInstanceRunning() && !this.isInstanceNotRunning()) {
            try {
                this.stopInstance();
            }
            catch (Exception e) {
                throw new InstanceException(this.getMessages().getStartInstanceTimeOutMessage(this.getConfig().getDisplayName()), e);
            }
            throw new InstanceException(this.getMessages().getStartInstanceTimeOutMessage(this.getConfig().getDisplayName()));
        }
        if (this.isInstanceNotRunning()) {
            throw new InstanceException(this.getMessages().getStartupFailedMessage(this.getConfig().getDisplayName()));
        }
        this.setRMIClient(null);
    }

    void preStop() throws InstanceException {
        int state = this.getInstanceStatus();
        if (state != 0) {
            throw new InstanceException(this.getMessages().getCannotStopInstanceInvalidStateMessage(this.getConfig().getDisplayName(), Status.getStatusString(state)));
        }
    }

    void postStop() throws InstanceException {
        if (!this.isInstanceNotRunning()) {
            throw new InstanceException(this.getMessages().getCannotStopInstanceMessage(this.getConfig().getDisplayName()));
        }
        this.setRMIClient(null);
    }

    protected void waitUntilStarting(ProcessExecutor processExec) throws InstanceException {
        this.waitUntilStarting(processExec, 180);
    }

    protected void waitUntilStarting(ProcessExecutor processExec, int timeoutSeconds) throws InstanceException {
        InstanceTimer timer = new InstanceTimer(timeoutSeconds, 0, new TimerCallback(){

            public boolean check() throws Exception {
                return PEInstancesManager.this.isInstanceStarting() || PEInstancesManager.this.isInstanceRunning() || PEInstancesManager.this.isInstanceFailed();
            }
        });
        timer.run();
        if (this.getInstanceStatus() == 3) {
            throw new InstanceException(this.getMessages().getTimeoutStartingMessage(this.getConfig().getDisplayName()));
        }
    }

    protected void waitUntilStarted() throws InstanceException {
        this.waitUntilStarted(1200);
    }

    protected void waitUntilStarted(int timeoutSeconds) throws InstanceException {
        InstanceTimer timer = new InstanceTimer(timeoutSeconds, 0, new TimerCallback(){

            public boolean check() throws Exception {
                return PEInstancesManager.this.isInstanceRunning() || PEInstancesManager.this.isInstanceFailed() || PEInstancesManager.this.isInstanceNotRunning();
            }
        });
        timer.run();
    }

    void waitUntilStopped() throws InstanceException {
        int timeOutSeconds = 60;
        InstanceTimer timer = new InstanceTimer(60, 0, new TimerCallback(){

            public boolean check() throws Exception {
                return PEInstancesManager.this.isInstanceNotRunning();
            }
        });
        timer.run();
    }

    void execute(File script) throws InstanceException {
        try {
            ProcessExecutor exec = new ProcessExecutor(new String[]{script.getAbsolutePath()});
            exec.execute();
        }
        catch (Exception e) {
            throw new InstanceException(_strMgr.getString("procExecError"), e);
        }
    }

    ProcessExecutor execute(String[] command) throws InstanceException {
        return this.execute(command, null);
    }

    ProcessExecutor execute(String[] command, String[] interativeOptions) throws InstanceException {
        try {
            ProcessExecutor exec = new ProcessExecutor(command, interativeOptions);
            String nativeLauncher = System.getProperty("com.sun.aas.nativeLauncher");
            if (nativeLauncher != null && nativeLauncher.equals("true")) {
                exec.execute(false, false);
            } else {
                exec.execute();
            }
            return exec;
        }
        catch (Exception e) {
            throw new InstanceException(_strMgr.getString("procExecError"), e);
        }
    }

    protected PEFileLayout getFileLayout() {
        return super.getFileLayout(this.getConfig());
    }

    int getConflictedPort() {
        int port = 0;
        try {
            port = this.getRMIClient().getConflictedPort();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return port;
    }

    void abortServer() {
        try {
            this.getRMIClient().triggerServerExit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getInstanceStatus() throws InstanceException {
        int status = Integer.MIN_VALUE;
        try {
            status = this.getRMIClient().getInstanceStatusCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return status;
    }

    private RMIClient getRMIClient() {
        if (this.rmiClient == null) {
            String stubPath = this.getFileLayout().getStubFile().getAbsolutePath();
            String seedPath = this.getFileLayout().getSeedFile().getAbsolutePath();
            this.rmiClient = new RMIClient(false, stubPath, seedPath);
        }
        return this.rmiClient;
    }

    private void setRMIClient(RMIClient client) {
        this.rmiClient = client;
    }
}

