/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.pe;

import com.sun.enterprise.admin.common.Status;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.DomainXmlEventListener;
import com.sun.enterprise.admin.servermgmt.DomainsManager;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.admin.servermgmt.RepositoryNameValidator;
import com.sun.enterprise.admin.servermgmt.pe.PEAccXmlTokens;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainConfigValidator;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainXmlTokens;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.admin.servermgmt.pe.PEScriptsTokens;
import com.sun.enterprise.admin.servermgmt.util.DomainXmlSAXParser;
import com.sun.enterprise.admin.util.TokenValueSet;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;

public class PEDomainsManager
extends RepositoryManager
implements DomainsManager {
    private static final StringManager strMgr = StringManager.getManager((Class)PEDomainsManager.class);

    public BitSet getDomainFlags() {
        BitSet bs = new BitSet();
        bs.set(1, false);
        return bs;
    }

    public void validateDomain(DomainConfig domainConfig, boolean domainExists) throws DomainException {
        try {
            this.checkRepository(domainConfig, domainExists, domainExists);
        }
        catch (RepositoryException ex) {
            throw new DomainException(ex);
        }
    }

    public void validateAdminUserAndPassword(DomainConfig domainConfig) throws DomainException {
        try {
            this.validateAdminUserAndPassword(domainConfig, PEDomainsManager.getDomainUser(domainConfig), PEDomainsManager.getDomainPasswordClear(domainConfig));
        }
        catch (RepositoryException ex) {
            throw new DomainException(ex);
        }
    }

    public void validateMasterPassword(DomainConfig domainConfig) throws DomainException {
        try {
            this.validateMasterPassword(domainConfig, PEDomainsManager.getMasterPasswordClear(domainConfig));
        }
        catch (RepositoryException ex) {
            throw new DomainException(ex);
        }
    }

    public void createDomain(DomainConfig domainConfig) throws DomainException {
        PEFileLayout layout = this.getFileLayout(domainConfig);
        try {
            new RepositoryNameValidator(strMgr.getString("domainsRoot")).checkValidXmlToken(layout.getRepositoryRootDir().getAbsolutePath());
            layout.createRepositoryRoot();
            new PEDomainConfigValidator().validate(domainConfig);
            this.checkRepository(domainConfig, false);
        }
        catch (Exception ex) {
            throw new DomainException(ex);
        }
        try {
            String masterPassword = PEDomainsManager.getMasterPasswordClear(domainConfig);
            layout.createRepositoryDirectories();
            this.createDomainXml(domainConfig);
            this.createDomainXmlEvents(domainConfig);
            this.createScripts(domainConfig);
            this.createServerPolicyFile(domainConfig);
            this.createAdminKeyFile(domainConfig, PEDomainsManager.getDomainUser(domainConfig), PEDomainsManager.getDomainPasswordClear(domainConfig));
            this.createKeyFile(domainConfig, PEDomainsManager.getDomainUser(domainConfig), PEDomainsManager.getDomainPasswordClear(domainConfig));
            this.createAppClientContainerXml(domainConfig);
            this.createIndexFile(domainConfig);
            this.createDefaultWebXml(domainConfig);
            this.createLoginConf(domainConfig);
            this.createWssServerConfig(domainConfig);
            this.createSSLCertificateDatabase(domainConfig, masterPassword);
            this.changeMasterPasswordInMasterPasswordFile(domainConfig, masterPassword, PEDomainsManager.saveMasterPassword(domainConfig));
            this.createPasswordAliasKeystore(domainConfig, masterPassword);
            this.createTimerWal(domainConfig);
            this.createTimerDbn(domainConfig);
            this.setPermissions(domainConfig);
        }
        catch (DomainException de) {
            FileUtils.liquidate(this.getDomainDir(domainConfig));
            throw de;
        }
        catch (Exception ex) {
            FileUtils.liquidate(this.getDomainDir(domainConfig));
            throw new DomainException(ex);
        }
    }

    protected void setPermissions(DomainConfig domainConfig) throws DomainException {
        PEFileLayout layout = this.getFileLayout(domainConfig);
        try {
            this.chmod("-R u+x ", layout.getBinDir());
            this.chmod("-R g-rwx,o-rwx ", layout.getConfigRoot());
        }
        catch (Exception e) {
            throw new DomainException(strMgr.getString("setPermissionError"), e);
        }
    }

    public void deleteDomain(DomainConfig domainConfig) throws DomainException {
        try {
            this.deleteRepository(domainConfig);
        }
        catch (Exception e) {
            throw new DomainException(e);
        }
    }

    public void startDomain(DomainConfig domainConfig) throws DomainException {
        try {
            this.checkRepository(domainConfig);
            String[] options = this.getInteractiveOptions((String)domainConfig.get("domain.user"), (String)domainConfig.get("domain.password"), (String)domainConfig.get("domain.masterPassword"), (HashMap)domainConfig.get("domain.extraPasswords"));
            this.getInstancesManager(domainConfig).startInstance(options);
        }
        catch (Exception e) {
            throw new DomainException(e);
        }
    }

    public void stopDomain(DomainConfig domainConfig) throws DomainException {
        try {
            this.checkRepository(domainConfig);
            this.getInstancesManager(domainConfig).stopInstance();
        }
        catch (Exception e) {
            throw new DomainException(e);
        }
    }

    public String[] listDomainsAndStatus(DomainConfig domainConfig) throws DomainException {
        try {
            return this.listDomainsAndStatusAsString(domainConfig);
        }
        catch (Exception e) {
            throw new DomainException(e);
        }
    }

    public String[] listDomains(DomainConfig domainConfig) throws DomainException {
        try {
            return this.listRepository(domainConfig);
        }
        catch (Exception e) {
            throw new DomainException(e);
        }
    }

    protected void createDomainXmlEvents(DomainConfig domainConfig) throws DomainException {
        try {
            PEFileLayout layout = this.getFileLayout(domainConfig);
            File domainXml = layout.getDomainConfigFile();
            DomainXmlSAXParser parser = new DomainXmlSAXParser();
            try {
                parser.parse(domainXml, layout.getDtdFile());
            }
            catch (Exception e) {
                throw new DomainException(strMgr.getString("domainXmlNotParsed"), e);
            }
            String className = parser.getDomainXmlEventListenerClass();
            if (className != null) {
                DomainXmlEventListener listener = (DomainXmlEventListener)Class.forName(className).newInstance();
                listener.handleCreateEvent(domainConfig);
            }
        }
        catch (Exception e) {
            throw new DomainException(strMgr.getString("domainXmlEventsNotCreated"), e);
        }
    }

    protected TokenValueSet getDomainXmlTokens(DomainConfig domainConfig) {
        return PEDomainXmlTokens.getTokenValueSet(domainConfig);
    }

    protected void createDomainXml(DomainConfig domainConfig) throws DomainException {
        try {
            PEFileLayout layout = this.getFileLayout(domainConfig);
            File domainXml = layout.getDomainConfigFile();
            String templateName = (String)domainConfig.get("template.name");
            File domainXmlTemplate = templateName == null || templateName.equals("") ? layout.getDomainXmlTemplate() : layout.getDomainXmlTemplate(templateName);
            TokenValueSet tokens = this.getDomainXmlTokens(domainConfig);
            this.generateFromTemplate(tokens, domainXmlTemplate, domainXml);
        }
        catch (Exception e) {
            throw new DomainException(strMgr.getString("domainXmlNotCreated"), e);
        }
    }

    protected void createScripts(DomainConfig domainConfig) throws DomainException {
        TokenValueSet tokens = PEScriptsTokens.getTokenValueSet(domainConfig);
        this.createStartServ(domainConfig, tokens);
        this.createStopServ(domainConfig, tokens);
    }

    void createStartServ(DomainConfig domainConfig, TokenValueSet tokens) throws DomainException {
        try {
            PEFileLayout layout = this.getFileLayout(domainConfig);
            File startServTemplate = layout.getStartServTemplate();
            File startServ = layout.getStartServ();
            this.generateFromTemplate(tokens, startServTemplate, startServ);
        }
        catch (Exception e) {
            throw new DomainException(strMgr.getString("startServNotCreated"), e);
        }
    }

    void createStopServ(DomainConfig domainConfig, TokenValueSet tokens) throws DomainException {
        try {
            PEFileLayout layout = this.getFileLayout(domainConfig);
            File stopServTemplate = layout.getStopServTemplate();
            File stopServ = layout.getStopServ();
            this.generateFromTemplate(tokens, stopServTemplate, stopServ);
        }
        catch (Exception e) {
            throw new DomainException(strMgr.getString("stopServNotCreated"), e);
        }
    }

    protected void createAppClientContainerXml(DomainConfig domainConfig) throws DomainException {
        try {
            PEFileLayout layout = this.getFileLayout(domainConfig);
            File accXmlTemplate = layout.getAppClientContainerXmlTemplate();
            File accXml = layout.getAppClientContainerXml();
            TokenValueSet tokens = PEAccXmlTokens.getTokenValueSet(domainConfig);
            this.generateFromTemplate(tokens, accXmlTemplate, accXml);
        }
        catch (Exception e) {
            throw new DomainException(strMgr.getString("accXmlNotCreated"), e);
        }
    }

    protected void createIndexFile(DomainConfig domainConfig) throws DomainException {
        PEFileLayout layout = this.getFileLayout(domainConfig);
        File src = layout.getIndexFileTemplate();
        File dest = layout.getIndexFile();
        try {
            FileUtils.copy(src, dest);
        }
        catch (IOException ioe) {
            throw new DomainException(strMgr.getString("indexFileNotCreated"), ioe);
        }
    }

    protected void createDefaultWebXml(DomainConfig domainConfig) throws DomainException {
        PEFileLayout layout = this.getFileLayout(domainConfig);
        File src = layout.getDefaultWebXmlTemplate();
        File dest = layout.getDefaultWebXml();
        try {
            FileUtils.copy(src, dest);
        }
        catch (IOException ioe) {
            throw new DomainException(strMgr.getString("defaultWebXmlNotCreated"), ioe);
        }
    }

    protected void createLoginConf(RepositoryConfig config) throws DomainException {
        PEFileLayout layout = this.getFileLayout(config);
        File src = layout.getLoginConfTemplate();
        File dest = layout.getLoginConf();
        try {
            FileUtils.copy(src, dest);
        }
        catch (IOException ioe) {
            throw new DomainException(strMgr.getString("loginConfNotCreated"), ioe);
        }
    }

    protected void createWssServerConfig(RepositoryConfig config) throws DomainException {
        PEFileLayout layout = this.getFileLayout(config);
        File src = layout.getWssServerConfigTemplate();
        File dest = layout.getWssServerConfig();
        try {
            FileUtils.copy(src, dest);
        }
        catch (IOException ioe) {
            throw new DomainException(strMgr.getString("wssserverconfignotcreated"), ioe);
        }
    }

    protected File getDomainDir(DomainConfig domainConfig) {
        return this.getRepositoryDir(domainConfig);
    }

    protected File getDomainRoot(DomainConfig domainConfig) {
        return this.getRepositoryRootDir(domainConfig);
    }

    String getDefaultInstance() {
        return "server";
    }

    protected static String getDomainUser(DomainConfig domainConfig) {
        return (String)domainConfig.get("domain.user");
    }

    protected static String getDomainPasswordClear(DomainConfig domainConfig) {
        return (String)domainConfig.get("domain.password");
    }

    protected static String getMasterPasswordClear(DomainConfig domainConfig) {
        return (String)domainConfig.get("domain.masterPassword");
    }

    protected static String getNewMasterPasswordClear(DomainConfig domainConfig) {
        return (String)domainConfig.get("domain.newMasterPassword");
    }

    protected static boolean saveMasterPassword(DomainConfig domainConfig) {
        Boolean b = (Boolean)domainConfig.get("domain.saveMasterPassword");
        return b;
    }

    public void changeMasterPassword(DomainConfig config) throws DomainException {
        try {
            int status = this.getInstancesManager(config).getInstanceStatus();
            if (status != 3) {
                throw new DomainException(strMgr.getString("cannotChangePassword_invalidState", (Object)config.getDisplayName(), (Object)Status.getStatusString(status)));
            }
            String oldPass = PEDomainsManager.getMasterPasswordClear(config);
            String newPass = PEDomainsManager.getNewMasterPasswordClear(config);
            this.changePasswordAliasKeystorePassword(config, oldPass, newPass);
            this.changeSSLCertificateDatabasePassword(config, oldPass, newPass);
            this.changeMasterPasswordInMasterPasswordFile(config, newPass, PEDomainsManager.saveMasterPassword(config));
        }
        catch (Exception ex) {
            throw new DomainException(strMgr.getString("masterPasswordNotChanged"), ex);
        }
    }

    public String[] getExtraPasswordOptions(DomainConfig config) throws DomainException {
        return null;
    }
}

