/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.util;

import javax.management.j2ee.statistics.BoundedRangeStatistic;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.RangeStatistic;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.TimeStatistic;

final class StatisticToString {
    private final Statistic stc;
    private final String SEP = ":";

    StatisticToString(Statistic stc) {
        this.stc = stc;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        return s.append(this.baseString()).append(":").append(this.specificString()).toString();
    }

    private String baseString() {
        StringBuffer s = new StringBuffer();
        s.append(this.stc.getName()).append(":").append(this.stc.getUnit()).append(":").append(this.stc.getDescription()).append(this.stc.getStartTime()).append(this.stc.getStartTime());
        return s.toString();
    }

    private String specificString() {
        StringBuffer s = new StringBuffer();
        if (this.stc instanceof CountStatistic) {
            s.append(this.countStatisticSpecificString());
        }
        if (this.stc instanceof RangeStatistic) {
            s.append(this.rangeStatisticSpecificString());
        }
        if (this.stc instanceof BoundedRangeStatistic) {
            s.append(this.boundedRangeStatisticSpecificString());
        }
        if (this.stc instanceof TimeStatistic) {
            s.append(this.timeStatisticSpecificString());
        }
        return s.toString();
    }

    private String countStatisticSpecificString() {
        StringBuffer s = new StringBuffer();
        CountStatistic cs = (CountStatistic)this.stc;
        return s.append(cs.getCount()).toString();
    }

    private String rangeStatisticSpecificString() {
        StringBuffer s = new StringBuffer();
        RangeStatistic rs = (RangeStatistic)this.stc;
        return s.append(rs.getLowWaterMark()).append(":").append(rs.getHighWaterMark()).toString();
    }

    private String boundedRangeStatisticSpecificString() {
        StringBuffer s = new StringBuffer();
        BoundedRangeStatistic bs = (BoundedRangeStatistic)this.stc;
        return s.append(bs.getUpperBound()).append(":").append(bs.getLowerBound()).toString();
    }

    private String timeStatisticSpecificString() {
        StringBuffer s = new StringBuffer();
        TimeStatistic ts = (TimeStatistic)this.stc;
        return s.append(ts.getMaxTime()).append(":").append(ts.getMinTime()).append(":").append(ts.getTotalTime()).toString();
    }
}

