/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.stats.spi;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.JVMOperatingSystemStats;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.StringStatistic;
import com.sun.enterprise.admin.monitor.stats.StringStatisticImpl;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import javax.management.MBeanServer;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;

public class JVMOperatingSystemStatsImpl
implements JVMOperatingSystemStats {
    private GenericStatsImpl baseStatsImpl;
    private static final String STATS_INTERFACE_NAME = "com.sun.enterprise.admin.monitor.stats.JVMOperatingSystemStats";
    private MBeanServer server;
    private MutableCountStatistic availProcs;
    private StringStatistic name;
    private OperatingSystemMXBean bean;
    final long initTime = System.currentTimeMillis();

    public JVMOperatingSystemStatsImpl() {
        try {
            this.baseStatsImpl = new GenericStatsImpl(STATS_INTERFACE_NAME, (Object)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bean = ManagementFactory.getOperatingSystemMXBean();
        this.initializeStatistics();
    }

    public StringStatistic getName() {
        String name = this.bean.getName();
        return new StringStatisticImpl(name, "Name", "String", "The name of the Operating System", this.initTime, System.currentTimeMillis());
    }

    public StringStatistic getArch() {
        String arch = this.bean.getArch();
        return new StringStatisticImpl(arch, "Architecture", "String", "The architecture of the Operating System", this.initTime, System.currentTimeMillis());
    }

    public CountStatistic getAvailableProcessors() {
        long procs = this.bean.getAvailableProcessors();
        this.availProcs.setCount(procs);
        return (CountStatistic)this.availProcs.unmodifiableView();
    }

    public StringStatistic getVersion() {
        String version = this.bean.getVersion();
        return new StringStatisticImpl(version, "Version", "String", "The version of the Operating System", this.initTime, System.currentTimeMillis());
    }

    public Statistic[] getStatistics() {
        return this.baseStatsImpl.getStatistics();
    }

    public Statistic getStatistic(String str) {
        return this.baseStatsImpl.getStatistic(str);
    }

    public String[] getStatisticNames() {
        return this.baseStatsImpl.getStatisticNames();
    }

    private void initializeStatistics() {
        CountStatisticImpl c = new CountStatisticImpl("AvailableProcessors");
        this.availProcs = new MutableCountStatisticImpl(c);
    }
}

