/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.jndi;

import com.sun.enterprise.admin.monitor.jndi.JndiMBean;
import com.sun.enterprise.admin.monitor.jndi.JndiMBeanHelper;
import com.sun.enterprise.util.i18n.StringManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.naming.NamingException;

public class JndiMBeanImpl
implements JndiMBean {
    private JndiMBeanHelper helper;
    MBeanInfo mbeanInfo;
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final StringManager sm = StringManager.getManager((Class)JndiMBeanImpl.class);

    public JndiMBeanImpl() {
        this.initialize();
    }

    void initialize() {
        this.helper = new JndiMBeanHelper();
    }

    public Object getAttribute(String str) throws AttributeNotFoundException, MBeanException, ReflectionException {
        throw new UnsupportedOperationException(sm.getString("monitor.jndi.unsupported_method"));
    }

    public AttributeList getAttributes(String[] str) {
        throw new UnsupportedOperationException(sm.getString("monitor.jndi.unsupported_method"));
    }

    public MBeanInfo getMBeanInfo() {
        if (this.mbeanInfo == null) {
            this.mbeanInfo = new MBeanInfo(this.getClass().getName(), "Managed Object for " + this.getClass().getName(), null, null, this.getOperationInfo(), null);
        }
        return this.mbeanInfo;
    }

    MBeanOperationInfo[] getOperationInfo() {
        Method[] methods = this.getClass().getMethods();
        MBeanOperationInfo[] mInfo = new MBeanOperationInfo[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            mInfo[i] = this.createOperationInfo(methods[i]);
        }
        return mInfo;
    }

    MBeanOperationInfo createOperationInfo(Method method) {
        return new MBeanOperationInfo(method.getName(), "Method " + method.getName(), this.getParameterInfo(method.getParameterTypes()), method.getReturnType().getName(), 0);
    }

    MBeanParameterInfo[] getParameterInfo(Class[] paramTypes) {
        MBeanParameterInfo[] params = null;
        if (paramTypes != null) {
            params = new MBeanParameterInfo[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                try {
                    params[i] = new MBeanParameterInfo("param" + i, paramTypes[i].getName(), paramTypes[i].getName());
                    continue;
                }
                catch (IllegalArgumentException e) {
                    logger.log(Level.INFO, e.toString());
                }
            }
        }
        return params;
    }

    boolean isAttrGetterOrSetter(Method operation) {
        return operation.getName().startsWith("get") || operation.getName().startsWith("set");
    }

    public Object invoke(String str, Object[] obj, String[] str2) throws MBeanException, ReflectionException {
        Object a = null;
        Class[] c = new Class[str2.length];
        for (int i = 0; i < str2.length; ++i) {
            c[i] = str2[i].getClass();
        }
        try {
            a = this.getClass().getMethod(str, c).invoke((Object)this, obj);
        }
        catch (InvocationTargetException e) {
            logger.log(Level.INFO, e.getMessage(), e);
            MBeanException me = new MBeanException((Exception)e.getTargetException());
            throw me;
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
        return a;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new UnsupportedOperationException(sm.getString("monitor.jndi.unsupported_method"));
    }

    public AttributeList setAttributes(AttributeList attributeList) {
        throw new UnsupportedOperationException(sm.getString("monitor.jndi.unsupported_method"));
    }

    public ArrayList getNames(String context) throws NamingException {
        ArrayList names = null;
        names = this.helper.getJndiEntriesByContextPath(context);
        return names;
    }
}

